/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.common.util.OperationResultUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntRelationEntityService;
import kd.hdtc.hrdi.opplugin.web.intgovern.validate.IntRelationBatchSaveValidator;

public class IntRelationBatchSaveOp
extends HDTCDataBaseOp {
    private final IIntRelationEntityService intRelationEntityService = (IIntRelationEntityService)ServiceFactory.getService(IIntRelationEntityService.class);

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new IntRelationBatchSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        ArrayList intRelationList = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            boolean inOrOut = dataEntity.getBoolean("in_or_out");
            String prefix = inOrOut ? "in_" : "out_";
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(prefix + "entryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                DynamicObject intRelation = this.getIntRelation(prefix, entry);
                intRelationList.add(intRelation);
            }
        });
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrdi_intrelation", (DynamicObject[])intRelationList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        this.getOperationResult().setMessage(OperationResultUtils.parseResultToString((OperationResult)operationResult, (String)"save"));
    }

    private DynamicObject getIntRelation(String prefix, DynamicObject entry) {
        DynamicObject intRelation = this.intRelationEntityService.generateEmptyDynamicObject();
        intRelation.set("name", entry.get(prefix + "name"));
        intRelation.set("number", entry.get(prefix + "number"));
        intRelation.set("intsource", entry.get(prefix + "intsource"));
        intRelation.set("intdirection", entry.get(prefix + "intdirection"));
        intRelation.set("sourcesys", entry.get(prefix + "sourcesys"));
        intRelation.set("inttype", entry.get(prefix + "inttype"));
        intRelation.set("intscm", entry.get(prefix + "intscm"));
        intRelation.set("intmode", entry.get(prefix + "intmode"));
        intRelation.set("description", entry.get(prefix + "description"));
        intRelation.set("enable", (Object)"1");
        intRelation.set("status", (Object)"C");
        intRelation.set("creator", (Object)RequestContext.get().getCurrUserId());
        intRelation.set("realintmode", entry.get(prefix + "realintmode"));
        intRelation.set("msgpublisher", entry.get(prefix + "msgpublisher"));
        intRelation.set("inttype", entry.get(prefix + "inttype"));
        return intRelation;
    }
}

