/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdi.business.application.external.IIscCopyTriggerDomainService;
import kd.hdtc.hrdi.business.application.external.IMsgSubscriberDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.servicehelper.IntRelationServiceHelper;
import kd.hdtc.hrdi.opplugin.web.common.validate.EnableNameUniqueValidator;
import kd.hdtc.hrdi.opplugin.web.intgovern.validate.IntRelationEnableValidator;

public class IntRelationEnableOp
extends HDTCDataBaseOp {
    private final IIscCopyTriggerDomainService intSourceEntityService = (IIscCopyTriggerDomainService)ServiceFactory.getService(IIscCopyTriggerDomainService.class);
    private final IMsgSubscriberDomainService iMsgSubscriberDomainService = (IMsgSubscriberDomainService)ServiceFactory.getService(IMsgSubscriberDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        List fieldKeys = preparePropertysEventArgs.getFieldKeys();
        fieldKeys.add("intsource");
        fieldKeys.add("sourcesys");
        fieldKeys.add("intdirection");
        fieldKeys.add("inttype");
        fieldKeys.add("intscm");
        fieldKeys.add("msgsubscriber");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new EnableNameUniqueValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new IntRelationEnableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        List flowIdList;
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        Stream.of(dataEntities).forEach(intRelation -> {
            DynamicObjectCollection msgSubscriberCollection = intRelation.getDynamicObjectCollection("msgsubscriber");
            if (CollectionUtils.isNotEmpty((Collection)msgSubscriberCollection)) {
                List msgSubscriberIdList = msgSubscriberCollection.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
                this.iMsgSubscriberDomainService.reMsgSubscriber(msgSubscriberIdList);
            }
        });
        Map intTypeIntScmMap = IntRelationServiceHelper.getScmIdList((DynamicObject[])dataEntities);
        List triggerIdList = (List)intTypeIntScmMap.get("isc_data_copy_trigger");
        if (!CollectionUtils.isEmpty((Collection)triggerIdList)) {
            this.intSourceEntityService.enableTrigger(triggerIdList);
        }
        if (!CollectionUtils.isEmpty((Collection)(flowIdList = (List)intTypeIntScmMap.get("isc_service_flow")))) {
            OperationServiceHelper.executeOperate((String)"enable", (String)"isc_service_flow", (Object[])flowIdList.toArray(new Long[0]), (OperateOption)OperateOption.create());
        }
    }
}

