/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;

public class IntRelationImportPlugin
extends BatchImportPlugin {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntSourceSysDomainService iIntSourceSysDomainService = (IIntSourceSysDomainService)ServiceFactory.getService(IIntSourceSysDomainService.class);

    public void beforeSave(List<ImportBillData> billDataList, ImportLogger logger) {
        super.beforeSave(billDataList, logger);
        HashSet intSourceNumberSet = Sets.newHashSetWithExpectedSize((int)billDataList.size());
        HashSet sourceSysNumberSet = Sets.newHashSetWithExpectedSize((int)billDataList.size());
        billDataList.forEach(dd -> {
            if (StringUtils.isEmpty((String)dd.getData().getString("number")) || StringUtils.isEmpty((String)dd.getData().getString("name"))) {
                JSONObject sourceSys;
                JSONObject intSource = dd.getData().getJSONObject("intsource");
                if (intSource != null && StringUtils.isNotEmpty((String)intSource.getString("number"))) {
                    intSourceNumberSet.add(intSource.getString("number"));
                }
                if ((sourceSys = dd.getData().getJSONObject("sourcesys")) != null && StringUtils.isNotEmpty((String)sourceSys.getString("number"))) {
                    sourceSysNumberSet.add(sourceSys.getString("number"));
                }
            }
        });
        Map sourceSysNumberSourceSysObjMap = this.iIntSourceSysDomainService.querySourceSysByNumberList((Collection)sourceSysNumberSet);
        Map intSourceNumberIntSourceMap = this.iIntSourceDomainService.queryIntSourceByNumberList((Collection)intSourceNumberSet);
        billDataList.forEach(billData -> {
            JSONObject rowData = billData.getData();
            JSONObject intSourceJson = rowData.getJSONObject("intsource");
            JSONObject sourceSysJson = rowData.getJSONObject("sourcesys");
            boolean inOrOut = "1".equals(rowData.getString("intdirection"));
            if (intSourceJson != null && sourceSysJson != null && StringUtils.isNotEmpty((String)intSourceJson.getString("number")) && StringUtils.isNotEmpty((String)sourceSysJson.getString("number"))) {
                String intSourceNumber = intSourceJson.getString("number");
                String sourceSysNumber = sourceSysJson.getString("number");
                DynamicObject intSource = (DynamicObject)intSourceNumberIntSourceMap.get(intSourceNumber);
                DynamicObject sourceSys = (DynamicObject)sourceSysNumberSourceSysObjMap.get(sourceSysNumber);
                if (intSource != null && sourceSys != null) {
                    if (StringUtils.isEmpty((String)rowData.getString("number"))) {
                        rowData.put("number", (Object)this.iIntSourceDomainService.getIntRelationNumber(inOrOut, intSource, sourceSys));
                    }
                    if (StringUtils.isEmpty((String)rowData.getString("name"))) {
                        rowData.put("name", (Object)this.iIntSourceDomainService.getIntRelationName(inOrOut, intSource, sourceSys));
                    }
                }
            }
        });
    }
}

