/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import java.util.ArrayList;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdi.business.application.service.intgovern.IIntRelationApplicationService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.opplugin.web.intgovern.validate.IntRelationImportSaveValidator;

public class IntRelationSaveOp
extends HDTCDataBaseOp {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntRelationApplicationService applicationService = (IIntRelationApplicationService)ServiceFactory.createInstance(IIntRelationApplicationService.class);

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new IntRelationImportSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        ArrayList outBoundDynList = new ArrayList(16);
        Stream.of(dataEntities).forEach(intRelation -> {
            this.fillFields((DynamicObject)intRelation);
            String intDirection = intRelation.getString("intdirection");
            String intMode = intRelation.getString("intmode");
            if ("2".equals(intDirection) && "2".equals(intMode)) {
                outBoundDynList.add(intRelation);
            }
        });
        if (CollectionUtils.isNotEmpty(outBoundDynList)) {
            this.applicationService.outBoundRelationHandle(outBoundDynList);
        }
    }

    private void fillFields(DynamicObject intRelation) {
        String intDirection = intRelation.getString("intdirection");
        DynamicObject intSource = intRelation.getDynamicObject("intsource");
        DynamicObject sourceSys = intRelation.getDynamicObject("sourcesys");
        if (StringUtils.isEmpty((String)intRelation.getString("number"))) {
            String newNumber = this.iIntSourceDomainService.getIntRelationNumber("1".equals(intDirection), intSource, sourceSys);
            intRelation.set("number", (Object)newNumber);
        }
        if (StringUtils.isEmpty((String)intRelation.getString("name"))) {
            String newName = this.iIntSourceDomainService.getIntRelationName("1".equals(intDirection), intSource, sourceSys);
            intRelation.set("name", (Object)newName);
        }
    }
}

