/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntSourceEntityService;
import kd.hdtc.hrdi.opplugin.web.intgovern.validate.IntSourceCancelPublishValidator;

public class IntSourceCancelOpenApiOp
extends HDTCDataBaseOp {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntSourceEntityService iIntSourceEntityService = (IIntSourceEntityService)ServiceFactory.getService(IIntSourceEntityService.class);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        List fieldKeys = preparePropertysEventArgs.getFieldKeys();
        fieldKeys.add("midtableconfig");
        fieldKeys.add("ispublishapi");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new IntSourceCancelPublishValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        ArrayList midConfigIdSet = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> midConfigIdSet.add(dy.getLong("midtableconfig.id")));
        if ("cancel_openapi".equals(beginOperationTransactionArgs.getOperationKey())) {
            this.iIntSourceDomainService.cancelInOpenApiDyn((List)midConfigIdSet);
            this.iIntSourceEntityService.batchChangePublishStatus(dataEntities, false);
        }
    }
}

