/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.entity.IEntityObjectEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;

public class IntSourceImportPlugin
extends BatchImportPlugin {
    private final IEntityObjectEntityService iEntityObjectEntityService = (IEntityObjectEntityService)ServiceFactory.getService(IEntityObjectEntityService.class);

    public void beforeSave(List<ImportBillData> billDataList, ImportLogger logger) {
        super.beforeSave(billDataList, logger);
        HashSet entityNumberSet = Sets.newHashSetWithExpectedSize((int)billDataList.size());
        billDataList.forEach(dd -> {
            JSONObject entityObj;
            if ((StringUtils.isEmpty((String)dd.getData().getString("number")) || StringUtils.isEmpty((String)dd.getData().getString("name"))) && (entityObj = dd.getData().getJSONObject("entityobj")) != null && StringUtils.isNotEmpty((String)entityObj.getString("number"))) {
                entityNumberSet.add(entityObj.getString("number"));
            }
        });
        Map entityNumberEntityObjMap = this.iEntityObjectEntityService.queryByEntityNumberList((Collection)entityNumberSet);
        billDataList.forEach(billData -> {
            String entityNumber;
            DynamicObject entityDy;
            JSONObject rowData = billData.getData();
            JSONObject entityObj = rowData.getJSONObject("entityobj");
            if (entityObj != null && StringUtils.isNotEmpty((String)entityObj.getString("number")) && (entityDy = (DynamicObject)entityNumberEntityObjMap.get(entityNumber = entityObj.getString("number"))) != null) {
                if (StringUtils.isEmpty((String)rowData.getString("number"))) {
                    rowData.put("number", (Object)entityDy.getString("number"));
                }
                if (StringUtils.isEmpty((String)rowData.getString("name"))) {
                    rowData.put("name", entityDy.get("name"));
                }
            }
        });
    }
}

