/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.op;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntSourceEntityService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;

public class IntSourceSaveOp
extends HDTCDataBaseOp {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntSourceEntityService iIntSourceEntityService = (IIntSourceEntityService)ServiceFactory.getService(IIntSourceEntityService.class);
    private final IMidTableConfigEntityService iMidTableConfigEntityService = (IMidTableConfigEntityService)ServiceFactory.getService(IMidTableConfigEntityService.class);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        List fieldKeys = preparePropertysEventArgs.getFieldKeys();
        fieldKeys.add("midtableconfig");
        fieldKeys.add("ispublishapi");
        fieldKeys.add("entityobj");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        Set entityObjIdList = Stream.of(dataEntities).map(dy -> dy.getString("entityobj.number")).collect(Collectors.toSet());
        Map entityIdObjMap = this.iMidTableConfigEntityService.queryMidTablesByEntityIds("name,number,entityobj", entityObjIdList);
        Stream.of(dataEntities).forEach(dd -> {
            String name;
            DynamicObject entityObj = dd.getDynamicObject("entityobj");
            String number = dd.getString("number");
            if (StringUtils.isEmpty((String)number)) {
                dd.set("number", (Object)entityObj.getString("number"));
            }
            if (StringUtils.isEmpty((String)(name = dd.getString("number")))) {
                dd.set("name", (Object)entityObj.getString("name"));
            }
            dd.set("bizapp", entityObj.get("bizappid"));
            DynamicObject midTable = dd.getDynamicObject("midtableconfig");
            if (midTable == null) {
                dd.set("midtableconfig", entityIdObjMap.get(entityObj.getString("number")));
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        ArrayList intSourceIdList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> {
            if (dy.getDynamicObject("midtableconfig") == null && dy.getBoolean("ispublishapi")) {
                intSourceIdList.add(dy.getLong("id"));
            }
        });
        Map intSourceIdIntSourceMap = this.iIntSourceDomainService.queryByIds((List)intSourceIdList);
        ArrayList midConfigIdSet = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        if (CollectionUtils.isNotEmpty((Map)intSourceIdIntSourceMap)) {
            intSourceIdIntSourceMap.forEach((id, intSource) -> {
                DynamicObject midTableConfig = intSource.getDynamicObject("midtableconfig");
                if (midTableConfig != null) {
                    midConfigIdSet.add(midTableConfig.getLong("id"));
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)midConfigIdSet)) {
            this.iIntSourceDomainService.cancelInOpenApiDyn((List)midConfigIdSet);
            this.iIntSourceEntityService.batchChangePublishStatus(dataEntities, false);
        }
    }
}

