/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.validate;

import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class IntRelationBatchSaveValidator
extends HDTCDataBaseValidator {
    private final String entryEntityErrorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u672a\u586b\u5199", (String)"IntRelationBatchSaveValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String outIntTypeErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u65f6\u6548\u6027\u201d\u4e3a\u201c\u5b9e\u65f6\u201d\uff0c\u6216\u201c\u96c6\u6210\u65b9\u5411\u201d\u4e3a\u201cOUTBOUND\u201d\u65f6\uff0c\u201c\u96c6\u6210\u65b9\u5f0f\u201d\u4e0d\u652f\u6301\u201c\u542f\u52a8\u65b9\u6848\u201d\u3002", (String)"IntRelationImportSaveValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String inIntTypeErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u65f6\u6548\u6027\u201d\u4e3a\u201c\u5b9a\u65f6\u201d\uff0c\u6216\u201c\u96c6\u6210\u65b9\u5411\u201d\u4e3a\u201cINBOUND\u201d\u65f6\uff0c\u201c\u96c6\u6210\u65b9\u5f0f\u201d\u4e0d\u652f\u6301\u201c\u5916\u90e8\u7cfb\u7edfAPI\u201d\u3002", (String)"IntRelationImportSaveValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.validateEntryEntity();
        this.validateIntType();
    }

    protected void validateIntType() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject newIntRelation;
            boolean inOrOut = (newIntRelation = dy.getDataEntity()).getBoolean("in_or_out");
            String prefix = inOrOut ? "in_" : "out_";
            DynamicObjectCollection dynamicObjectCollection = newIntRelation.getDynamicObjectCollection(prefix + "entryentity");
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                dynamicObjectCollection.forEach(dd -> {
                    String intDirection = dd.getString(prefix + "intdirection");
                    String intMode = dd.getString(prefix + "intmode");
                    String intType = dd.getString(prefix + "inttype");
                    if ("1".equals(intMode) && "1".equals(intDirection) && "isc_apic_for_external_api".equals(intType)) {
                        this.addErrorMessage((ExtendedDataEntity)dy, this.inIntTypeErrorMsg);
                    }
                    if ("2".equals(intMode) && "2".equals(intDirection) && "isc_data_copy_trigger".equals(intType)) {
                        this.addErrorMessage((ExtendedDataEntity)dy, this.outIntTypeErrorMsg);
                    }
                });
            }
        });
    }

    private void validateEntryEntity() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject newIntRelation;
            boolean inOrOut = (newIntRelation = dy.getDataEntity()).getBoolean("in_or_out");
            String prefix = inOrOut ? "in_" : "out_";
            DynamicObjectCollection dynamicObjectCollection = newIntRelation.getDynamicObjectCollection(prefix + "entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                this.addErrorMessage((ExtendedDataEntity)dy, this.entryEntityErrorMsg);
            }
        });
    }
}

