/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.validate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;
import kd.hdtc.hrdi.common.intgovern.constants.IntRelationConstants;

public class IntRelationImportSaveValidator
extends HDTCDataBaseValidator {
    private final String realtimeOrinErrorMsg_API = ResManager.loadKDString((String)"\u5f53\u201c\u65f6\u6548\u6027\u201d\u4e3a\u201c\u5b9e\u65f6\u201d\uff0c\u6216\u201c\u96c6\u6210\u65b9\u5411\u201d\u4e3a\u201cOUTBOUND\u201d\u65f6\uff0c\u201c\u96c6\u6210\u65b9\u5f0f\u201d\u4e0d\u652f\u6301\u201c\u542f\u52a8\u65b9\u6848\u201d\u3002", (String)"IntRelationImportSaveValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String realtimeOrinErrorMsg_BaseAPI = ResManager.loadKDString((String)"\u5f53\u201c\u65f6\u6548\u6027\u201d\u4e3a\u201c\u5b9e\u65f6\u201d\uff0c\u6216\u201c\u96c6\u6210\u65b9\u5411\u201d\u4e3a\u201cOUTBOUND\u201d\u65f6\uff0c\u201c\u96c6\u6210\u65b9\u5f0f\u201d\u4e0d\u652f\u6301\u201c\u542f\u52a8\u65b9\u6848\u201d\u3002", (String)"IntRelationImportSaveValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String outIntTypeErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u65f6\u6548\u6027\u201d\u4e3a\u201c\u5b9a\u65f6\u201d\uff0c\u6216\u201c\u96c6\u6210\u65b9\u5411\u201d\u4e3a\u201cINBOUND\u201d\u65f6\uff0c\u201c\u96c6\u6210\u65b9\u5f0f\u201d\u4e0d\u652f\u6301\u201c\u5916\u90e8\u7cfb\u7edfAPI\u201d\u3002", (String)"IntRelationImportSaveValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String inModeErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u96c6\u6210\u65b9\u5411\u201d\u4e3a\u201cINBOUND\u201d\uff0c\u201c\u65f6\u6548\u6027\u201d\u4e0d\u652f\u6301\u5b9e\u65f6\u3002", (String)"IntRelationImportSaveValidator_2", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String intTypeBaseDataErrorMsg = ResManager.loadKDString((String)"\u5f53\u5b9e\u4f53\u5206\u7c7b\u4e0d\u662f\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u65f6\uff0c\u96c6\u6210\u65b9\u5f0f\u5c06\u65e0\u6cd5\u652f\u6301\u201c\u57fa\u7840\u8d44\u6599API\u201d\u3002", (String)"IntRelationImportSaveValidator_3", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String baseDataApiErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u96c6\u6210\u65b9\u5f0f\u201d\u4e3a\u201c\u57fa\u7840\u8d44\u6599API\u201d\u65f6\uff0c\u201c\u96c6\u6210\u65b9\u6848\u201d\u9ed8\u8ba4\u4e3a\u201c\u57fa\u7840\u8d44\u6599\u540c\u6b65\u201d\u3002", (String)"IntRelationImportSaveValidator_4", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String apiLinkConfigErrorMsg = ResManager.loadKDString((String)"\u5173\u8054\u7684\u76ee\u6807\u7cfb\u7edf\u201c%s\u201d\u672a\u8bbe\u7f6e\u82cd\u7a79API\u8fde\u63a5\u914d\u7f6e\u3002", (String)"IntRelationImportSaveValidator_5", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final IIntEntityCategoryDomainService categoryDomainService = (IIntEntityCategoryDomainService)ServiceFactory.getService(IIntEntityCategoryDomainService.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<String, BizCategoryEnum> bizCategoryEnumMap = this.getCategory();
        Arrays.stream(dataEntities).forEach(dy -> {
            this.validateApiLinkConfig((ExtendedDataEntity)dy);
            this.validateLinkage((ExtendedDataEntity)dy, bizCategoryEnumMap);
        });
    }

    private void validateApiLinkConfig(ExtendedDataEntity dy) {
        DynamicObject sourceSys = dy.getDataEntity().getDynamicObject("sourcesys");
        String intType = dy.getDataEntity().getString("inttype");
        Object apiLink = sourceSys.get("apilinkconfig");
        if ("open_apiservice".equals(intType) && apiLink == null) {
            this.addErrorMessage(dy, String.format(Locale.ROOT, this.apiLinkConfigErrorMsg, sourceSys.getString("name")));
        }
    }

    private Map<String, BizCategoryEnum> getCategory() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<String> bizEntitySet = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntitie : dataEntities) {
            DynamicObject intSource = dataEntitie.getDataEntity().getDynamicObject("intsource");
            bizEntitySet.add(intSource.getString("entityobj.id"));
        }
        return this.categoryDomainService.getCategoryByEntityNumber(bizEntitySet);
    }

    private void validateLinkage(ExtendedDataEntity dy, Map<String, BizCategoryEnum> bizCategoryEnumMap) {
        String intDirection = dy.getDataEntity().getString("intdirection");
        String intMode = dy.getDataEntity().getString("intmode");
        String intType = dy.getDataEntity().getString("inttype");
        boolean in = "1".equals(intDirection);
        boolean realTime = "2".equals(intMode);
        if (in) {
            this.doInValidateLinkage(dy, realTime, intType);
        } else {
            this.doOutValidateLinkage(dy, bizCategoryEnumMap, realTime, intType);
        }
    }

    private void doInValidateLinkage(ExtendedDataEntity dy, boolean realTime, String intType) {
        if (realTime) {
            this.addErrorMessage(dy, this.inModeErrorMsg);
        }
        if ("isc_apic_for_external_api".equals(intType)) {
            this.addErrorMessage(dy, this.realtimeOrinErrorMsg_API);
        }
        if ("open_apiservice".equals(intType)) {
            this.addErrorMessage(dy, this.realtimeOrinErrorMsg_BaseAPI);
        }
    }

    private void doOutValidateLinkage(ExtendedDataEntity dy, Map<String, BizCategoryEnum> bizCategoryEnumMap, boolean realTime, String intType) {
        String bizEntity = dy.getDataEntity().getDynamicObject("intsource").getString("entityobj.id");
        BizCategoryEnum bizCategory = bizCategoryEnumMap.get(bizEntity);
        long intScmId = dy.getDataEntity().getLong("intscm.id");
        if (!BizCategoryEnum.BASE_DATA.getCode().equals(bizCategory.getCode()) && "open_apiservice".equals(intType)) {
            this.addErrorMessage(dy, this.intTypeBaseDataErrorMsg);
        }
        if ("open_apiservice".equals(intType) && !IntRelationConstants.BASE_DATA_API_ID.equals(intScmId)) {
            this.addErrorMessage(dy, this.baseDataApiErrorMsg);
        }
        if (realTime && "isc_data_copy_trigger".equals(intType)) {
            this.addErrorMessage(dy, this.outIntTypeErrorMsg);
        }
    }
}

