/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.common.enums.InteDirectionEnum;

public class IntRelationSaveValidator
extends HDTCDataBaseValidator {
    private final IIntRelationDomainService iIntRelationDomainService = (IIntRelationDomainService)ServiceFactory.getService(IIntRelationDomainService.class);
    protected String combinationUniqueErrorMsg;

    public void validate() {
        this.initErrorMsg();
        this.validateCombinationUnique();
    }

    protected void validateCombinationUnique() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet sourceSysIdIntDirectionIntSourceIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet intSourceIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet sourceSysIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject newIntRelation = dy.getDataEntity();
            long sourceSysId = newIntRelation.getLong("sourcesys.id");
            sourceSysIdSet.add(sourceSysId);
            String intDirection = newIntRelation.getString("intdirection");
            long intSourceId = newIntRelation.getLong("intsource.id");
            intSourceIdSet.add(intSourceId);
            String sourceSysIdIntDirectionIntSourceId = String.join((CharSequence)"_", sourceSysId + "", intDirection, intSourceId + "");
            if (sourceSysIdIntDirectionIntSourceIdSet.contains(sourceSysIdIntDirectionIntSourceId)) {
                String sourceSysName = newIntRelation.getString("sourcesys.name");
                String intSourceName = newIntRelation.getString("intsource.name");
                String combinationUniqueErrorInfo = String.format(Locale.ROOT, this.combinationUniqueErrorMsg, sourceSysName, intDirection, intSourceName);
                this.addErrorMessage((ExtendedDataEntity)dy, combinationUniqueErrorInfo);
            }
            sourceSysIdIntDirectionIntSourceIdSet.add(sourceSysIdIntDirectionIntSourceId);
            if (newIntRelation.getLong("id") > 0L) {
                idList.add(newIntRelation.getLong("id"));
            }
        });
        this.validateCombinationUniqueInDb(intSourceIdSet, sourceSysIdSet, idList);
    }

    protected void validateCombinationUniqueInDb(Set<Long> intSourceIdSet, Set<Long> sourceSysIdSet, List<Long> idList) {
        List dynamicObjectList = this.iIntRelationDomainService.queryEnableData(intSourceIdSet, sourceSysIdSet, idList);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectList)) {
            HashSet sourceSysIdIntDirectionIntSourceIdSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectList.size());
            for (DynamicObject dbIntRelation : dynamicObjectList) {
                long sourceSysId = dbIntRelation.getLong("sourcesys.id");
                sourceSysIdSet.add(sourceSysId);
                String intDirection = dbIntRelation.getString("intdirection");
                long intSourceId = dbIntRelation.getLong("intsource.id");
                intSourceIdSet.add(intSourceId);
                String sourceSysIdIntDirectionIntSourceId = String.join((CharSequence)"_", sourceSysId + "", intDirection, intSourceId + "");
                sourceSysIdIntDirectionIntSourceIdSet.add(sourceSysIdIntDirectionIntSourceId);
            }
            Arrays.stream(this.dataEntities).forEach(dy -> {
                DynamicObject newIntRelation = dy.getDataEntity();
                long sourceSysId = newIntRelation.getLong("sourcesys.id");
                String intDirection = newIntRelation.getString("intdirection");
                long intSourceId = newIntRelation.getLong("intsource.id");
                String sourceSysIdIntDirectionIntSourceId = String.join((CharSequence)"_", sourceSysId + "", intDirection, intSourceId + "");
                if (sourceSysIdIntDirectionIntSourceIdSet.contains(sourceSysIdIntDirectionIntSourceId)) {
                    String sourceSysName = newIntRelation.getString("sourcesys.name");
                    String intSourceName = newIntRelation.getString("intsource.name");
                    String combinationUniqueErrorInfo = String.format(Locale.ROOT, this.combinationUniqueErrorMsg, sourceSysName, this.getInteDirectionDesc(intDirection), intSourceName);
                    this.addErrorMessage((ExtendedDataEntity)dy, combinationUniqueErrorInfo);
                }
            });
        }
    }

    private String getInteDirectionDesc(String inteDirection) {
        return InteDirectionEnum.getNameByCode((String)inteDirection);
    }

    protected void initErrorMsg() {
        this.combinationUniqueErrorMsg = ResManager.loadKDString((String)"\u6765\u6e90/\u76ee\u6807\u7cfb\u7edf\u201c%1s\u201d\u3001\u96c6\u6210\u65b9\u5411\u503c\u201c%2s\u201d\u548cHR\u96c6\u6210\u8d44\u6e90\u201c%3s\u201d\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u3002", (String)"IntRelationBatchAddValidator_2", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    }
}

