/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.validate;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class IntSourcePublishValidator
extends HDTCDataBaseValidator {
    private final String publishErrorMsg = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u96c6\u6210\u5b57\u6bb5\u914d\u7f6e\u201d\uff0c\u4ee5\u4fbf\u53d1\u5e03\u5199\u5165API\u3002", (String)"IntSourcePublishValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String enableErrorMsg = ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u6570\u636e\u65e0\u6cd5\u53d1\u5e03\u5199\u5165/\u5220\u9664API\u3002", (String)"IntSourcePublishValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String midTableErrorMsg = ResManager.loadKDString((String)"\u4e2d\u95f4\u8868\u4e0d\u5b58\u5728\u3002\u8bf7\u5230\u96c6\u6210\u5b57\u6bb5\u914d\u7f6e\u4e2d\u67e5\u627e\u5b9e\u4f53\u201c%s\u201d\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u70b9\u5f00\u7f16\u8f91\u754c\u9762\u91cd\u65b0\u4fdd\u5b58\uff0c\u786e\u4fdd\u5bf9\u5e94\u4e2d\u95f4\u8868\u5df2\u7ecf\u751f\u6210\u3002", (String)"IntSourcePublishValidator_2", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public Set<String> preparePropertys() {
        Set properties = super.preparePropertys();
        properties.add("entityobj");
        properties.add("midtableconfig");
        properties.add("enable");
        return properties;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            this.midTableEntityValidate((ExtendedDataEntity)dy);
            this.enableValidate((ExtendedDataEntity)dy);
            this.publishValidate((ExtendedDataEntity)dy);
        });
    }

    private void midTableEntityValidate(ExtendedDataEntity dy) {
        DynamicObject intSource = dy.getDataEntity();
        if (!MetadataUtils.isExist((String)intSource.getString("midtableconfig.midentitynumber"))) {
            this.addErrorMessage(dy, String.format(Locale.ROOT, this.midTableErrorMsg, intSource.getString("entityobj.name")));
        }
    }

    private void publishValidate(ExtendedDataEntity dy) {
        DynamicObject dataEntity = dy.getDataEntity();
        DynamicObject midTableConfig = dataEntity.getDynamicObject("midtableconfig");
        if (midTableConfig == null) {
            this.addErrorMessage(dy, this.publishErrorMsg);
        }
    }

    private void enableValidate(ExtendedDataEntity dy) {
        DynamicObject dataEntity = dy.getDataEntity();
        String enable = dataEntity.getString("enable");
        if (!"1".endsWith(enable)) {
            this.addErrorMessage(dy, this.enableErrorMsg);
        }
    }
}

