/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;

public class IntSourceUniqueValidator
extends HDTCDataBaseValidator {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    protected String entityObjErrorMsg;

    public Set<String> preparePropertys() {
        Set properties = super.preparePropertys();
        properties.add("entityobj");
        return properties;
    }

    public void validate() {
        this.initErrorMsg(this.getOperateKey());
        this.validateEntityObjUnique();
    }

    protected void initErrorMsg(String operateKey) {
        if (operateKey.equals("save")) {
            this.entityObjErrorMsg = ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"IntSourceUniqueValidator_2", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
        }
        if (operateKey.equals("enable")) {
            this.entityObjErrorMsg = ResManager.loadKDString((String)"%s\uff1a\u5df2\u542f\u7528\u6570\u636e\u4e2d\u5b58\u5728\u76f8\u540c\u5b9e\u4f53\u5bf9\u8c61\uff0c\u65e0\u6cd5\u542f\u7528\u3002", (String)"IntSourceUniqueValidator_5", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
        }
    }

    private void validateEntityObjUnique() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList entityObjIdList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dyn = dy.getDataEntity();
            entityObjIdList.add(dy.getDataEntity().getString("entityobj.id"));
            if (dyn.getLong("id") > 0L) {
                if (idList.contains(dyn.getLong("id"))) {
                    String nameErrorInfo = String.format(Locale.ROOT, this.entityObjErrorMsg, dyn.getString("entityobj.number"));
                    this.addErrorMessage((ExtendedDataEntity)dy, nameErrorInfo);
                }
                idList.add(dyn.getLong("id"));
            }
        });
        List dynamicObjectList = this.iIntSourceDomainService.queryOriginalEnableDataByEntityObjIds((List)entityObjIdList, (List)idList);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectList)) {
            HashSet entityObjIdSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectList.size());
            dynamicObjectList.forEach(dy -> entityObjIdSet.add(dy.getString("entityobj.id")));
            Arrays.stream(dataEntities).forEach(dy -> {
                DynamicObject dyx = dy.getDataEntity();
                String entityObjId = dyx.getString("entityobj.id");
                if (entityObjIdSet.contains(entityObjId)) {
                    String nameErrorInfo = String.format(Locale.ROOT, this.entityObjErrorMsg, dyx.getString("entityobj.number"));
                    this.addErrorMessage((ExtendedDataEntity)dy, nameErrorInfo);
                }
            });
        }
    }
}

