/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.intgovern.validate;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class IntegratedConfImportValidator
extends HDTCDataBaseValidator {
    private final String bizOpEmptyErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u5b9e\u4f53\u5206\u7c7b\u201d\u4e3a\u201c\u57fa\u7840\u8d44\u6599\u201d\u65f6\uff0c\u201c\u4e1a\u52a1\u64cd\u4f5c\u201d\u5fc5\u987b\u586b\u5199\u3002", (String)"IntegratedConfImportValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String bizOpErrorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c\u201c%1$s\u201d\u5728\u5b9e\u4f53\u201c%2$s\u201d\u7684\u64cd\u4f5c\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8fdb\u884c\u8c03\u6574\u3002", (String)"IntegratedConfImportValidator_2", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String personAttachErrorMsg = ResManager.loadKDString((String)"\u5f53\u201c\u5b9e\u4f53\u5206\u7c7b\u201d\u4e3a\u201c\u4eba\u5458\u9644\u8868\u201d\uff0c\u201c\u4e1a\u52a1\u64cd\u4f5c\u201d\u4e0d\u9700\u8981\u586b\u503c\u3002", (String)"IntegratedConfImportValidator_3", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String mainDataErrorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4eba\u5458\u9644\u8868\u201d\u6216\u201c\u57fa\u7840\u8d44\u6599\u201d\uff0c\u4e0d\u652f\u6301\u201c\u4e3b\u6570\u636e\u201d\u7c7b\u578b\u5bfc\u5165\u3002", (String)"IntegratedConfImportValidator_4", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(entity -> {
            String entityType;
            DynamicObject intConfig = entity.getDataEntity();
            switch (entityType = intConfig.getString("entitytype")) {
                case "1": {
                    this.mainDataTypeValidate((ExtendedDataEntity)entity);
                    break;
                }
                case "2": {
                    this.personAttachTypeValidate((ExtendedDataEntity)entity);
                    break;
                }
                case "3": {
                    this.basedataTypeValidate((ExtendedDataEntity)entity);
                    break;
                }
            }
        });
    }

    private void mainDataTypeValidate(ExtendedDataEntity entity) {
        this.addErrorMessage(entity, this.mainDataErrorMsg);
    }

    private void personAttachTypeValidate(ExtendedDataEntity entity) {
        DynamicObject intConfig = entity.getDataEntity();
        String opType = intConfig.getString("bizop");
        if (StringUtils.isNotEmpty((String)opType)) {
            this.addErrorMessage(entity, this.personAttachErrorMsg);
        }
    }

    private void basedataTypeValidate(ExtendedDataEntity entity) {
        DynamicObject intConfig = entity.getDataEntity();
        String entityId = intConfig.getString("entityobj.number");
        String opType = intConfig.getString("bizop");
        if (StringUtils.isEmpty((String)opType)) {
            this.addErrorMessage(entity, this.bizOpEmptyErrorMsg);
            return;
        }
        String[] ops = opType.split(",");
        Set opNumberSet = MetadataUtils.getDataEntityOperate((String)entityId);
        Arrays.stream(ops).forEach(op -> {
            String[] opCodeNames = op.split("!");
            String opCodeName = opCodeNames[0];
            if (!opNumberSet.contains(opCodeName)) {
                String bizMessageErrorMsgInfo = String.format(Locale.ROOT, this.bizOpErrorMsg, opCodeName, entityId);
                this.addErrorMessage(entity, bizMessageErrorMsgInfo);
            }
        });
    }
}

