/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.middle.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;

public class EntityObjUniqueValidator
extends HDTCDataBaseValidator {
    private IIntSceneRuleDomainService sceneRuleService = (IIntSceneRuleDomainService)ServiceFactory.getService(IIntSceneRuleDomainService.class);

    public Set<String> preparePropertys() {
        Set properties = super.preparePropertys();
        properties.add("entityobj");
        return properties;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.validateDBEntityObj(dataEntities);
    }

    private void validateDBEntityObj(ExtendedDataEntity[] dataEntities) {
        DynamicObject[] dbSceneRules;
        String entityId;
        ArrayList<Long> ids = new ArrayList<Long>();
        String errorMsg = ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61(%s)\u5df2\u5b58\u5728\u5df2\u542f\u7528\u89c4\u5219,\u8bf7\u4fee\u6539", (String)"EntityObjUniqueValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
        HashMap<String, ExtendedDataEntity> dataEntitiesMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            entityId = dyn.getString("entityobj.id");
            if (dataEntitiesMap.get(entityId) != null) {
                this.addErrorMsg(dataEntity, errorMsg);
                continue;
            }
            dataEntitiesMap.put(entityId, dataEntity);
            ids.add(dyn.getLong("id"));
        }
        for (DynamicObject dbSceneRule : dbSceneRules = this.sceneRuleService.getEnabledSceneRule(dataEntitiesMap.keySet(), ids)) {
            entityId = dbSceneRule.getString("entityobj.id");
            this.addErrorMsg((ExtendedDataEntity)dataEntitiesMap.get(entityId), errorMsg);
        }
    }

    private void addErrorMsg(ExtendedDataEntity dataEntities, String errorMsg) {
        DynamicObject dyn = dataEntities.getDataEntity();
        String entityName = dyn.getString("entityobj.name");
        this.addErrorMessage(dataEntities, String.format(Locale.ROOT, errorMsg, entityName));
    }
}

