/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.middle.validate;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;

public class InitEntityObjUniqueValidator
extends HDTCDataBaseValidator {
    private final IMidTableConfigDomainService midTableConfigDomainService = (IMidTableConfigDomainService)ServiceFactory.getService(IMidTableConfigDomainService.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.validateInitEntityObj(dataEntities);
    }

    private void validateInitEntityObj(ExtendedDataEntity[] dataEntities) {
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String entityNumber = dataEntities[0].getDataEntity().getDataEntityType().getName();
        List ids = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("id")).collect(Collectors.toList());
        String errorMsg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b9e\u4f53\u5bf9\u8c61\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"InitEntityObjUniqueValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
        Object[] midTableConfigList = this.midTableConfigDomainService.queryMidTableConfig(entityNumber, "id, initentityobject", ids);
        if (ArrayUtils.isEmpty((Object[])midTableConfigList)) {
            return;
        }
        Set<String> initEntityObjectLists = this.getAllInitEntityObjectFromDB((DynamicObject[])midTableConfigList);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection initEntityObjectList = dynamicObject.getDynamicObjectCollection("initentityobject");
            if (CollectionUtils.isEmpty((Collection)initEntityObjectList)) continue;
            for (DynamicObject initEntityObjects : initEntityObjectList) {
                DynamicObject initEntityObject = initEntityObjects.getDynamicObject("fbasedataid");
                if (initEntityObject == null || !initEntityObjectLists.contains(initEntityObject.getString("id"))) continue;
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, initEntityObject.getString("name")));
            }
        }
    }

    private Set<String> getAllInitEntityObjectFromDB(DynamicObject[] midTableConfigList) {
        HashSet initEntityObject = Sets.newHashSetWithExpectedSize((int)midTableConfigList.length);
        for (DynamicObject midTableConfig : midTableConfigList) {
            DynamicObjectCollection initEntityObjectList = midTableConfig.getDynamicObjectCollection("initentityobject");
            if (CollectionUtils.isEmpty((Collection)initEntityObjectList)) continue;
            for (DynamicObject dynamicObject : initEntityObjectList) {
                initEntityObject.add(dynamicObject.getString("fbasedataid_id"));
            }
        }
        return initEntityObject;
    }
}

