/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.middle.validate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;

public class MidTableIntFieldValidator
extends HDTCDataBaseValidator {
    private final IIntSceneRuleDomainService sceneRuleService = (IIntSceneRuleDomainService)ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private final String errorMsg = ResManager.loadKDString((String)"%1$s\u4e3a\u5b9e\u4f53\u5bf9\u8c61(%2$s)\u96c6\u6210\u5fc5\u987b\u7684\u5b57\u6bb5\uff0c\u4e0d\u80fd\u53bb\u6389", (String)"MidTableIntFieldValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.doValidate(dataEntities);
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) {
        HashSet entitySet = new HashSet();
        Arrays.stream(dataEntities).forEach(dataEntity -> entitySet.add(dataEntity.getDataEntity().getString("entityobj.id")));
        Map sceneRuleFieldsMap = this.sceneRuleService.getPresetSceneRuleFields(entitySet);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            String entityId = dataEntity2.getDataEntity().getString("entityobj.id");
            String sceneRuleField = (String)sceneRuleFieldsMap.get(entityId);
            if (StringUtils.isEmpty((String)sceneRuleField)) continue;
            this.validateMidTableIntFields(dataEntity2, sceneRuleField);
        }
    }

    private void validateMidTableIntFields(ExtendedDataEntity dataEntity, String fields) {
        DynamicObject midTableDyn = dataEntity.getDataEntity();
        DynamicObjectCollection entryColl = midTableDyn.getDynamicObjectCollection("treeentryentity");
        String entityName = midTableDyn.getString("entityobj.name");
        Map<Long, DynamicObject> treeEntryMap = entryColl.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (o1, o2) -> o1));
        for (DynamicObject dyn2 : entryColl) {
            boolean isField = dyn2.getBoolean("isfield");
            if (!isField) continue;
            String field = this.getField(dyn2, treeEntryMap);
            boolean isIntField = dyn2.getBoolean("isintegrationfield");
            if (!fields.contains(field) || isIntField) continue;
            String fieldName = dyn2.getString("entityname");
            if (!StringUtils.isEmpty((String)fieldName) && fieldName.endsWith("*")) {
                fieldName = fieldName.substring(0, fieldName.length() - 1);
            }
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.errorMsg, fieldName, entityName));
        }
    }

    private String getField(DynamicObject dyn, Map<Long, DynamicObject> treeEntryMap) {
        Long pid = dyn.getLong("pid");
        String field = dyn.getString("entitynumber");
        DynamicObject pDyn = treeEntryMap.get(pid);
        if ("billhead".equals(pDyn.getString("entitynumber"))) {
            pDyn = treeEntryMap.get(pDyn.getLong("pid"));
        }
        String entity = pDyn.getString("entitynumber");
        return entity + '.' + field;
    }
}

