/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.middle.validate;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class MidTableIntStatusValidator
extends HDTCDataBaseValidator {
    private final String errorMsg = ResManager.loadKDString((String)"%1s_%2s\uff1a\u4ec5\u652f\u6301\u4fee\u8ba2\u96c6\u6210\u72b6\u6001\u4e3a\u201c\u5f85\u540c\u6b65\u201d\u6216\u201c\u540c\u6b65\u5931\u8d25\u201d\u7684\u6570\u636e\u3002", (String)"MidTableIntStatusValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.doIntStatusValidate(dataEntities);
    }

    private void doIntStatusValidate(ExtendedDataEntity[] dataEntities) {
        List<String> needIntStatusList = Arrays.asList("0", "1");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String intStatus2 = entity.getString("hrdiintstatus");
            if (needIntStatusList.contains(intStatus2)) continue;
            String sourceSys = entity.getString("hrdisourcesys");
            String sourceSysKey = entity.getString("hrdisourcesyskey");
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.errorMsg, sourceSys, sourceSysKey));
        }
    }
}

