/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.middle.validate;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableDataVersionValidateBo;

public class MidTableRetryValidator
extends HDTCDataBaseValidator {
    private final String errorMsg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5f85\u540c\u6b65\u201d\u6216\u201c\u540c\u6b65\u5931\u8d25\u201d\u65f6\uff0c\u53ef\u91cd\u65b0\u540c\u6b65\u3002", (String)"MidTableRetryValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String exceptionMsg = ResManager.loadKDString((String)"\u670d\u52a1\u5f02\u5e38\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\uff0c\u8bf7\u5728\u5411\u5185\u96c6\u6210\u65e5\u5fd7\u4e2d\u91cd\u8bd5\u3002", (String)"MidTableRetryValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String lastVersionMsg = ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u552f\u4e00\u6807\u8bc6+\u6765\u6e90\u7cfb\u7edf(%1$s+%2$s)\u5df2\u6709\u6700\u65b0\u540c\u6b65\u6210\u529f\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"MidTableRetryValidator_2", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public Set<String> preparePropertys() {
        Set properties = super.preparePropertys();
        properties.add("hrdiintstatus");
        properties.add("is_exception");
        properties.add("hrdisourcesys");
        properties.add("hrdisourcesyskey");
        properties.add("hrdimodifydate");
        return properties;
    }

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List dynList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        MidTableDataVersionValidateBo validateBo = new MidTableDataVersionValidateBo(dynList);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.doIntStatusValidate(dataEntity);
            this.doLastVersionValidate(dataEntity, validateBo);
        }
    }

    private void doLastVersionValidate(ExtendedDataEntity dataEntity, MidTableDataVersionValidateBo validateBo) {
        DynamicObject dyn = dataEntity.getDataEntity();
        boolean validate = validateBo.isLastVersion(dyn);
        if (!validate) {
            String msg = String.format(Locale.ROOT, this.lastVersionMsg, dyn.getString("hrdisourcesyskey"), dyn.getString("hrdisourcesys"));
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private void doIntStatusValidate(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        String intStatus2 = entity.getString("hrdiintstatus");
        boolean exception = entity.getBoolean("is_exception");
        if ("2".equals(intStatus2) || "-1".equals(intStatus2)) {
            this.addErrorMessage(dataEntity, this.errorMsg);
        } else if (exception) {
            this.addErrorMessage(dataEntity, this.exceptionMsg);
        }
    }
}

