/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.monitor.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;

public class IntLogRetryStatusValidator
extends HDTCDataBaseValidator {
    private final IIntLogDomainService iIntLogDomainService = (IIntLogDomainService)ServiceFactory.getService(IIntLogDomainService.class);
    private final String intLogStatusErrorMsg = ResManager.loadKDString((String)"\u8bf7\u91cd\u8bd5\u201c\u72b6\u6001\u201d\u4e3a\u201c\u670d\u52a1\u5f02\u5e38\u201d\u7684\u65e5\u5fd7\u3002", (String)"IntLogRetryStatusValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);

    public Set<String> preparePropertys() {
        Set fieldKeys = super.preparePropertys();
        fieldKeys.add("operatestatus");
        fieldKeys.add("parent");
        return fieldKeys;
    }

    public void validate() {
        this.validateStatus();
    }

    private void validateStatus() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap intLogIdIntLogDataEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList parentIdList = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject intLog = dy.getDataEntity();
            String operateStatus = intLog.getString("operatestatus");
            String parent = intLog.getString("parent");
            if (parent != null) {
                if (!OperateStatusEnum.SERVICE_EXCEPTION.getCode().equals(operateStatus)) {
                    this.addFatalErrorMessage((ExtendedDataEntity)dy, this.intLogStatusErrorMsg);
                }
            } else {
                intLogIdIntLogDataEntityMap.put(intLog.getLong("id"), dy);
                parentIdList.add(intLog.getLong("id"));
            }
        });
        Set withErrorParentIntLogIdList = this.iIntLogDomainService.queryWithErrorParentIntLogIdList((List)parentIdList);
        intLogIdIntLogDataEntityMap.forEach((parentId, intLogDataEntity) -> {
            if (!withErrorParentIntLogIdList.contains(parentId)) {
                this.addFatalErrorMessage((ExtendedDataEntity)intLogDataEntity, this.intLogStatusErrorMsg);
            }
        });
    }
}

