/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.queryapi.validate;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryConditionValueBo;
import kd.hdtc.hrdi.business.domain.queryapi.enums.ConditionOperatorEnum;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryCondition;

public class QueryApiConditionValidator
extends HDTCDataBaseValidator {
    private final String paramMustError = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570%s\u5df2\u88ab\u8fc7\u6ee4\u6761\u4ef6\u5f15\u7528\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u975e\u5fc5\u586b\u3002", (String)"QueryApiConditionValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final String paramMulValueError = ResManager.loadKDString((String)"\u6761\u4ef6%1$s\u7684\u6bd4\u8f83\u7c7b\u578b\u4e3a%2$s\uff0c\u8bf7\u6c42\u53c2\u6570%3$s\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u591a\u503c\u3002", (String)"QueryApiConditionValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    private final Set<String> mulValueOperateTypeSet = ImmutableSet.builder().add((Object)CompareTypeEnum.IN.getId()).add((Object)CompareTypeEnum.NOTIN.getId()).build();

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(this::conditionValidate);
    }

    private void conditionValidate(ExtendedDataEntity dy) {
        DynamicObject dyn = dy.getDataEntity();
        QueryConditionValueBo valueBo = new QueryConditionValueBo(dyn);
        String msg = valueBo.conditionCompleteValidate();
        if (StringUtils.isEmpty((String)msg)) {
            msg = valueBo.qFilterValidate();
        }
        if (StringUtils.isNotEmpty((String)(msg = msg + this.paramNumberValidate(valueBo, dyn)))) {
            this.addErrorMessage(dy, msg);
        }
    }

    private String paramNumberValidate(QueryConditionValueBo valueBo, DynamicObject dyn) {
        Map paramConditionMap = valueBo.getConditionParamNumber();
        DynamicObjectCollection requestEntry = dyn.getDynamicObjectCollection("requestentryentity");
        StringBuilder msgBuilder = new StringBuilder();
        requestEntry.forEach(entryDyn -> {
            String paramNumber = entryDyn.getString("paramnumber");
            if (paramConditionMap.containsKey(paramNumber) && !entryDyn.getBoolean("must")) {
                msgBuilder.append(String.format(Locale.ROOT, this.paramMustError, paramNumber));
            }
            msgBuilder.append(this.paramMulValueValidate((List)paramConditionMap.get(paramNumber), paramNumber, entryDyn.getBoolean("mulvalue")));
        });
        return msgBuilder.toString();
    }

    private String paramMulValueValidate(List<QueryCondition> queryConditionList, String paramNumber, boolean mulValue) {
        StringBuilder msgBuilder = new StringBuilder();
        if (CollectionUtils.isEmpty(queryConditionList)) {
            return msgBuilder.toString();
        }
        queryConditionList.forEach(condition -> {
            if (!this.mulValueOperateTypeSet.contains(condition.getOperators()) && mulValue) {
                String operateName = ConditionOperatorEnum.getName((String)condition.getOperators());
                msgBuilder.append(String.format(Locale.ROOT, this.paramMulValueError, condition.getName(), operateName, paramNumber));
            }
        });
        return msgBuilder.toString();
    }
}

