/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.formplugin.web.examine.HRExamineDataBo;
import kd.hdtc.hrdt.formplugin.web.examine.business.IHRExamineListService;
import kd.hdtc.hrdt.formplugin.web.examine.business.impl.HRExamineListServiceImpl;
import kd.hdtc.hrdt.formplugin.web.examine.business.impl.ODCExamineListServiceImpl;
import kd.hdtc.hrdt.formplugin.web.examine.business.impl.SITExamineListServiceImpl;
import kd.hdtc.hrdt.formplugin.web.examine.business.impl.SWCExamineListServiceImpl;
import kd.hdtc.hrdt.formplugin.web.examine.business.impl.WTCExamineListServiceImpl;

public class HRExamineListDataPlugin
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(HRExamineListDataPlugin.class);
    private static final String ENTITY_NAME = "hrdt_examine";
    private List<HRExamineDataBo> fieldsList = new ArrayList<HRExamineDataBo>(10);
    private List<IHRExamineListService> serviceList = new ArrayList<IHRExamineListService>(10);

    private void init() {
        this.fieldsList.add(new HRExamineDataBo("examinedate", (DataType)DataType.DateType, false));
        this.fieldsList.add(new HRExamineDataBo("userid", (DataType)DataType.LongType, false));
        this.fieldsList.add(new HRExamineDataBo("username", (DataType)DataType.StringType, false));
        this.fieldsList.add(new HRExamineDataBo("usernumber", (DataType)DataType.StringType, false));
        this.fieldsList.add(new HRExamineDataBo("totalscore", (DataType)DataType.BigDecimalType, false));
        this.serviceList.add(new ODCExamineListServiceImpl());
        this.serviceList.add(new HRExamineListServiceImpl());
        this.serviceList.add(new SITExamineListServiceImpl());
        this.serviceList.add(new SWCExamineListServiceImpl());
        this.serviceList.add(new WTCExamineListServiceImpl());
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object obj) throws Throwable {
        Set queryUserIds;
        this.init();
        this.addField();
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObjectCollection selectUsers = filter.getDynamicObjectCollection("selectuser");
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(selectUsers.size());
        Date currDate = new Date();
        for (DynamicObject selectUser : selectUsers) {
            Long userId = selectUser.getLong("id");
            HashMap<String, Object> statData = new HashMap<String, Object>(16);
            statData.put("userid", userId);
            statData.put("usernumber", selectUser.getString("number"));
            statData.put("username", selectUser.getString("name"));
            statData.put("examinedate", currDate);
            dataMap.put(userId, statData);
        }
        boolean isQueryNew = filter.getBoolean("isnew");
        if (isQueryNew) {
            this.setHRExamineScore(dataMap);
            this.saveExamineData(dataMap);
            List<Object[]> dataList = this.buildShowData(dataMap);
            Iterator algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            Iterator<Object[]> iterator = dataList.iterator();
            return algo.createDataSet(iterator, this.getRowMeta());
        }
        HashSet<Long> userIds = new HashSet<Long>(selectUsers.size());
        for (DynamicObject user : selectUsers) {
            userIds.add(user.getLong("id"));
        }
        ArrayList<Long> existedUserIds = new ArrayList<Long>(userIds.size());
        QFilter qFilter = new QFilter("userid", "in", userIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryExamUser", (String)ENTITY_NAME, (String)this.getSelectFields(), (QFilter[])qFilter.toArray(), (String)"examinedate desc");
        DataSet copyDataSet = dataSet.copy();
        if (copyDataSet != null) {
            while (copyDataSet.hasNext()) {
                Row row = copyDataSet.next();
                existedUserIds.add(row.getLong("userid"));
            }
        }
        if (CollectionUtils.isNotEmpty(queryUserIds = userIds.stream().filter(id -> !existedUserIds.contains(id)).collect(Collectors.toSet()))) {
            Iterator userIterator = dataMap.entrySet().iterator();
            while (userIterator.hasNext()) {
                Map.Entry entry = userIterator.next();
                Long userId = (Long)entry.getKey();
                if (queryUserIds.contains(userId)) continue;
                userIterator.remove();
            }
            this.setHRExamineScore(dataMap);
            this.saveExamineData(dataMap);
            List<Object[]> dataList = this.buildShowData(dataMap);
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            Iterator<Object[]> iterator = dataList.iterator();
            DataSet ds = algo.createDataSet(iterator, this.getRowMeta());
            dataSet = dataSet.union(ds).orderBy(new String[]{"examinedate desc"});
        }
        return dataSet;
    }

    private void addField() {
        if (CollectionUtils.isNotEmpty(this.serviceList)) {
            for (IHRExamineListService service : this.serviceList) {
                service.addFields(this.fieldsList);
            }
        }
    }

    private void setHRExamineScore(Map<Long, Map<String, Object>> dataMap) {
        if (CollectionUtils.isNotEmpty(this.serviceList)) {
            for (IHRExamineListService service : this.serviceList) {
                service.setExamineScore(dataMap);
            }
        }
        this.setTotalScore(dataMap);
    }

    private void setTotalScore(Map<Long, Map<String, Object>> dataMap) {
        if (ObjectUtils.isEmpty(dataMap)) {
            return;
        }
        for (Map<String, Object> scoreInfo : dataMap.values()) {
            BigDecimal total = this.accumulateTotalScore(scoreInfo);
            scoreInfo.put("totalscore", total);
        }
    }

    private BigDecimal accumulateTotalScore(Map<String, Object> examineInfo) {
        BigDecimal totalScore = new BigDecimal("0");
        AtomicReference<BigDecimal> finalTotalScore = new AtomicReference<BigDecimal>(totalScore);
        for (HRExamineDataBo field : this.fieldsList) {
            Object score;
            if (!field.isAccumulate() || (score = examineInfo.get(field.getFieldNumber())) == null || !(score instanceof Number)) continue;
            String numValue = String.valueOf(score);
            totalScore = totalScore.add(new BigDecimal(numValue));
        }
        return totalScore;
    }

    private void saveExamineData(Map<Long, Map<String, Object>> dataMap) {
        QFilter qFilter = new QFilter("userid", "in", dataMap.keySet());
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)this.getSelectFields(), (QFilter[])qFilter.toArray());
        HashMap resultMap = userArr.length > 0 ? Arrays.stream(userArr).collect(Collectors.toMap(user -> user.getLong("userid"), v -> v)) : new HashMap();
        ArrayList<DynamicObject> statisticDataList = new ArrayList<DynamicObject>(dataMap.size());
        for (Map<String, Object> examineInfo : dataMap.values()) {
            Long userId = (Long)examineInfo.get("userid");
            DynamicObject statisticData = (DynamicObject)resultMap.get(userId);
            if (statisticData == null) {
                statisticData = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            }
            this.setValToDyn(statisticData, examineInfo);
            statisticDataList.add(statisticData);
        }
        SaveServiceHelper.save((DynamicObject[])statisticDataList.toArray(new DynamicObject[0]));
    }

    private List<Object[]> buildShowData(Map<Long, Map<String, Object>> dataMap) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(dataMap.size());
        for (Map<String, Object> info : dataMap.values()) {
            Object[] data = new Object[this.fieldsList.size()];
            for (int index = 0; index < this.fieldsList.size(); ++index) {
                HRExamineDataBo fieldBo = this.fieldsList.get(index);
                data[index] = info.get(fieldBo.getFieldNumber());
            }
            dataList.add(data);
        }
        return dataList;
    }

    private void setValToDyn(DynamicObject statisticData, Map<String, Object> examineInfo) {
        if (statisticData == null || ObjectUtils.isEmpty(examineInfo)) {
            return;
        }
        for (HRExamineDataBo bo : this.fieldsList) {
            Object value = examineInfo.get(bo.getFieldNumber());
            if (value != null) {
                statisticData.set(bo.getFieldNumber(), value);
                continue;
            }
            statisticData.set(bo.getFieldNumber(), (Object)0);
        }
    }

    private String getSelectFields() {
        List fieldNameList = this.fieldsList.stream().map(HRExamineDataBo::getFieldNumber).collect(Collectors.toList());
        return Joiner.on((String)",").join(fieldNameList);
    }

    private RowMeta getRowMeta() {
        ArrayList showFieldList = new ArrayList(this.fieldsList.size());
        this.fieldsList.stream().forEach(data -> showFieldList.add(new Field(data.getFieldNumber(), data.getDataType())));
        return new RowMeta(showFieldList.toArray(new Field[0]));
    }
}

