/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRExamineQueryFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("selectuser");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection selectUser = filterInfo.getDynamicObjectCollection("selectuser");
        if (CollectionUtils.isEmpty((Collection)selectUser)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b66\u5458", (String)"HRExamineQueryFormPlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public Set<String> getTraineeWhiteList() {
        HashSet<String> retSet = new HashSet<String>(16);
        CommonServiceImpl commonService = new CommonServiceImpl("hrdt_baseconfig");
        QFilter blackListNumFilter = new QFilter("number", "=", (Object)"hrdt_examinereport");
        Map mapFromCacheDyn = commonService.getMapFromCache("id,number,value", new QFilter[]{blackListNumFilter});
        if (ObjectUtils.isEmpty((Object)mapFromCacheDyn)) {
            return retSet;
        }
        for (DynamicObject blackDyn : mapFromCacheDyn.values()) {
            String confValue = blackDyn.getString("value");
            if (HRStringUtils.isEmpty((String)confValue)) continue;
            HashSet<String> finalRetSet = retSet;
            Arrays.stream(confValue.split(",")).forEach(be -> finalRetSet.add(be.trim()));
        }
        return retSet;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long currUserId = RequestContext.get().getCurrUserId();
        CommonServiceImpl userService = new CommonServiceImpl("bos_user");
        Map userDynMap = userService.getMapFromCache("id,number", new QFilter[]{new QFilter("id", "=", (Object)currUserId)});
        DynamicObject userDyn = (DynamicObject)userDynMap.get(currUserId);
        Set<String> traineeWhiteList = this.getTraineeWhiteList();
        if (!traineeWhiteList.contains(userDyn.getString("number"))) {
            ArrayList<QFilter> userFilterList = new ArrayList<QFilter>(10);
            userFilterList.add(new QFilter("number", "=", (Object)userDyn.getString("number")));
            beforeF7SelectEvent.setCustomQFilters(userFilterList);
        }
    }
}

