/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine.business.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.util.CollectionUtils;
import kd.hdtc.hrdt.formplugin.web.examine.HRExamineDataBo;
import kd.hdtc.hrdt.formplugin.web.examine.business.IHRExamineListService;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRExamineListServiceImpl
implements IHRExamineListService {
    private static final String HR_DB_KEY = "hr";
    private static final String HRB_HOM_DB_KEY = "hrb.hom";
    private static final String HRB_HLCM_DB_KEY = "hrb.hlcm";
    private static final String HRB_HDM_DB_KEY = "hrb.hdm";
    private static final String HMP_DB_KEY = "hmp";
    private static final String ALGO_KEY = "queryDataPerm";
    private static final String HLCM_APPID = "1WXBXYCLS05D";
    private static final String HSPM_APPID = "1WXBPN7+OHJZ";
    private static final String NUM = "num";
    private static final String FCREATORID = "fcreatorid";
    private static final String ACTSCHEME_COLUMN = "actscheme";
    private static final String ONBOARDACTIVE_COLUMN = "onboardactive";
    private static final String INFORCOLLECT_COLUMN = "inforcollect";
    private static final String ONBOARDCOMPLETE_COLUMN = "onboardcomplete";
    private static final String SIGNATURETEMPLATE_COLUMN = "signaturetemplate";
    private static final String CONTRACTSTRATEGY_COLUMN = "contractstrategy";
    private static final String CONTRACTSIGNING_COLUMN = "contractsigning";
    private static final String APPLYFORFULLMEMBER_COLUMN = "applyforfullmember";
    private static final String POSITIVERESULT_COLUMN = "positiveresult";
    private static final String FILEVIEW_COLUMN = "fileview";
    private static final String FILESTRATEGY_COLUMN = "filestrategy";
    private static final HashMap<String, Integer> scoreMap = new HashMap();

    @Override
    public void addFields(List<HRExamineDataBo> fieldsList) {
        fieldsList.add(new HRExamineDataBo(ACTSCHEME_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(ONBOARDACTIVE_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(INFORCOLLECT_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(ONBOARDCOMPLETE_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(SIGNATURETEMPLATE_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(CONTRACTSTRATEGY_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(CONTRACTSIGNING_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(APPLYFORFULLMEMBER_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(POSITIVERESULT_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(FILEVIEW_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(FILESTRATEGY_COLUMN, (DataType)DataType.BigDecimalType, true));
    }

    @Override
    public void setExamineScore(Map<Long, Map<String, Object>> dataMap) {
        this.calculateActSchemeScore(dataMap);
        this.calculateOnboardActiveScore(dataMap);
        this.calculateInforCollectScore(dataMap);
        this.calculateOnboardCompleteScore(dataMap);
        this.calculateSignatureTemplateScore(dataMap);
        this.calculateContractStrategyScore(dataMap);
        this.calculateContractSigningScore(dataMap);
        this.calculateApplyForFullMemberScore(dataMap);
        this.calculatePositiveResultScore(dataMap);
        this.calculateFileViewScore(dataMap);
        this.calculateFileStrategyScore(dataMap);
    }

    private void calculateActSchemeScore(Map<Long, Map<String, Object>> dataMap) {
        String name = ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6", (String)"HRExamineListServiceImpl_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        String otherfilter = "fid in (select fid from t_hrcs_actschemeentry where factivityid in (select fid from t_hrcs_activity where fname = '" + name + "' or fid = 1295624259862963200))";
        SqlBuilder sqlBuilder = this.getSelectSql(dataMap.keySet(), "t_hrcs_actscheme", "", otherfilter);
        this.calculatePersonScore(dataMap, sqlBuilder, ACTSCHEME_COLUMN, HMP_DB_KEY);
    }

    private void calculateOnboardActiveScore(Map<Long, Map<String, Object>> dataMap) {
        HashMap<Long, Set<Long>> actChemeMap = this.getActCheme();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fmodifierid as fcreatorid,factivityschemeid,count(fid) as num from t_hom_activityinfo where", new Object[0]);
        sqlBuilder.appendIn(" fmodifierid", dataMap.keySet().toArray());
        sqlBuilder.append(" group by fmodifierid,factivityschemeid", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HRB_HOM_DB_KEY), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Set<Long> set;
                    Long fcreatorid = row.getLong(FCREATORID);
                    Long factivityschemeid = row.getLong("factivityschemeid");
                    Map<String, Object> info = dataMap.get(fcreatorid);
                    if (row.getInteger(NUM) <= 0 || actChemeMap.get(fcreatorid) == null || !(set = actChemeMap.get(fcreatorid)).contains(factivityschemeid) || info.containsKey(ONBOARDACTIVE_COLUMN)) continue;
                    info.put(ONBOARDACTIVE_COLUMN, scoreMap.get(ONBOARDACTIVE_COLUMN));
                }
            }
        }
    }

    private void calculateInforCollectScore(Map<Long, Map<String, Object>> dataMap) {
        for (Map.Entry<Long, Map<String, Object>> entry : dataMap.entrySet()) {
            Map<String, Object> info = entry.getValue();
            info.put(INFORCOLLECT_COLUMN, scoreMap.get(INFORCOLLECT_COLUMN));
        }
    }

    private void calculateOnboardCompleteScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fcreatorid as fcreatorid,count(bill.fid) as num", new Object[0]);
        sqlBuilder.append(" from t_hom_onbrdbill bill", new Object[0]);
        sqlBuilder.append(" left join t_hom_onbrdbill_a a on bill.fid = a.fid", new Object[0]);
        sqlBuilder.appendIn(" where a.fcreatorid ", dataMap.keySet().toArray());
        sqlBuilder.append(" and bill.fenrollstatus = '3'", new Object[0]);
        sqlBuilder.append(" group by a.fcreatorid", new Object[0]);
        this.calculatePersonScore(dataMap, sqlBuilder, ONBOARDCOMPLETE_COLUMN, HRB_HOM_DB_KEY);
    }

    private void calculateSignatureTemplateScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = this.getSelectSql(dataMap.keySet(), "t_hlcm_contracttemp", "", "");
        this.calculatePersonScore(dataMap, sqlBuilder, SIGNATURETEMPLATE_COLUMN, HRB_HLCM_DB_KEY);
    }

    private void calculateContractStrategyScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = this.getSelectSql(dataMap.keySet(), "t_brm_policy", "", "fbizappid = '1WXBXYCLS05D'");
        this.calculatePersonScore(dataMap, sqlBuilder, CONTRACTSTRATEGY_COLUMN, HMP_DB_KEY);
    }

    private void calculateContractSigningScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select p.fcreatorid as fcreatorid,count(bill.fid) as num", new Object[0]);
        sqlBuilder.append(" from t_hlcm_signbill bill", new Object[0]);
        sqlBuilder.append(" left join t_hlcm_signbill_p p on bill.fid = p.fid", new Object[0]);
        sqlBuilder.appendIn(" where p.fcreatorid ", dataMap.keySet().toArray());
        sqlBuilder.append(" group by p.fcreatorid", new Object[0]);
        this.calculatePersonScore(dataMap, sqlBuilder, CONTRACTSIGNING_COLUMN, HRB_HLCM_DB_KEY);
    }

    private void calculateApplyForFullMemberScore(Map<Long, Map<String, Object>> dataMap) {
        Map<Long, Long> assessorIdUserIdMap = this.getUserIdByAssessorId(dataMap.keySet());
        if (CollectionUtils.isEmpty(assessorIdUserIdMap)) {
            return;
        }
        SqlBuilder sqlBuilder = this.getSelectSql(new HashSet<Long>(assessorIdUserIdMap.values()), "t_hdm_regbasebill", "", "");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HRB_HDM_DB_KEY), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Long creatorId = row.getLong(FCREATORID);
                    assessorIdUserIdMap.forEach((assessorId, userId) -> {
                        if (userId != null && userId.equals(creatorId)) {
                            Map info = (Map)dataMap.get(assessorId);
                            if (row.getInteger(NUM) > 0) {
                                info.put(APPLYFORFULLMEMBER_COLUMN, scoreMap.get(APPLYFORFULLMEMBER_COLUMN));
                            }
                        }
                    });
                }
            }
        }
    }

    private void calculatePositiveResultScore(Map<Long, Map<String, Object>> dataMap) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        SqlBuilder empSqlBuilder = this.getSelectSql(dataMap.keySet(), "t_hdm_regaskdetails", "finitiatorid", "fstatus = '1030'");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HRB_HDM_DB_KEY), (SqlBuilder)empSqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    if (row.getInteger(NUM) <= 0) continue;
                    set.add(row.getLong("finitiatorid"));
                }
            }
        }
        Map<Long, Long> assessorIdUserIdMap = this.getUserIdByAssessorId(dataMap.keySet());
        if (CollectionUtils.isEmpty(assessorIdUserIdMap)) {
            return;
        }
        SqlBuilder sqlBuilder = this.getSelectSql(new HashSet<Long>(assessorIdUserIdMap.values()), "t_hdm_regbasebill", "", "fregstatus = '1040'");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HRB_HDM_DB_KEY), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Long creatorId = row.getLong(FCREATORID);
                    if (creatorId == null) continue;
                    assessorIdUserIdMap.forEach((assessorId, userId) -> {
                        if (creatorId.equals(userId) && row.getInteger(NUM) > 0 && set.contains(assessorId)) {
                            Map info = (Map)dataMap.get(assessorId);
                            info.put(POSITIVERESULT_COLUMN, scoreMap.get(POSITIVERESULT_COLUMN));
                        }
                    });
                }
            }
        }
    }

    private void calculateFileViewScore(Map<Long, Map<String, Object>> dataMap) {
        HashSet<Long> set = new HashSet<Long>();
        SqlBuilder empSqlBuilder = this.getSelectSql(dataMap.keySet(), "t_hspm_multiviewconfig", "", "femployee = '1'");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HR_DB_KEY), (SqlBuilder)empSqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Map<String, Object> info = dataMap.get(row.getLong(FCREATORID));
                    if (row.getInteger(NUM) <= 0) continue;
                    set.add(row.getLong(FCREATORID));
                }
            }
        }
        SqlBuilder sqlBuilder = this.getSelectSql(dataMap.keySet(), "t_hspm_multiviewconfig", "", "femployee = '0'");
        DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HR_DB_KEY), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    Map<String, Object> info = dataMap.get(row.getLong(FCREATORID));
                    if (row.getInteger(NUM) <= 0 || !set.contains(row.getLong(FCREATORID))) continue;
                    info.put(FILEVIEW_COLUMN, scoreMap.get(FILEVIEW_COLUMN));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
    }

    private void calculateFileStrategyScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = this.getSelectSql(dataMap.keySet(), "t_brm_policy", "", "fbizappid = '1WXBPN7+OHJZ'");
        this.calculatePersonScore(dataMap, sqlBuilder, FILESTRATEGY_COLUMN, HMP_DB_KEY);
    }

    private void calculatePersonScore(Map<Long, Map<String, Object>> dataMap, SqlBuilder sqlBuilder, String columnName, String dbKey) {
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Map<String, Object> info = dataMap.get(row.getLong(FCREATORID));
                    if (row.getInteger(NUM) <= 0) continue;
                    info.put(columnName, scoreMap.get(columnName));
                }
            }
        }
    }

    private SqlBuilder getSelectSql(Set<Long> userId, String tableName, String groupByColumn, String otherfilter) {
        if (groupByColumn.equals("")) {
            groupByColumn = FCREATORID;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(groupByColumn, new Object[0]).append(",count(fid) as ", new Object[0]).append(NUM, new Object[0]).append(" from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn(groupByColumn, userId.toArray());
        if (!otherfilter.equals("")) {
            sqlBuilder.append(" and " + otherfilter, new Object[0]);
        }
        sqlBuilder.append(" group by ", new Object[0]).append(groupByColumn, new Object[0]);
        return sqlBuilder;
    }

    private HashMap<Long, Set<Long>> getActCheme() {
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>();
        Long fcreatorid = 0L;
        HashSet<Long> set = new HashSet<Long>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcreatorid,fid from t_hrcs_actscheme order by fcreatorid", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)HMP_DB_KEY), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                HashSet<Long> resultSet;
                for (Row row : ds) {
                    if (fcreatorid == 0L) {
                        fcreatorid = row.getLong(FCREATORID);
                    }
                    if (fcreatorid.intValue() == row.getLong(FCREATORID).intValue()) {
                        set.add(row.getLong("fid"));
                        continue;
                    }
                    resultSet = new HashSet();
                    resultSet.addAll(set);
                    resultMap.put(fcreatorid, resultSet);
                    fcreatorid = row.getLong(FCREATORID);
                    set.clear();
                    set.add(row.getLong("fid"));
                }
                resultSet = new HashSet<Long>();
                resultSet.addAll(set);
                resultMap.put(fcreatorid, resultSet);
            }
        }
        return resultMap;
    }

    private Map<Long, Long> getUserIdByAssessorId(Set<Long> assessorId) {
        HashMap userIdMap = Maps.newHashMapWithExpectedSize((int)16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fphone from t_sec_user where ", new Object[0]).appendIn("fid", assessorId.toArray());
        HashMap userIdPhoneMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    userIdPhoneMap.put(row.getLong("fid"), row.getString("fphone"));
                }
            }
        }
        if (CollectionUtils.isEmpty((Map)userIdPhoneMap)) {
            return userIdMap;
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fnumber from t_sec_user where ", new Object[0]).appendIn("fnumber", userIdPhoneMap.values().toArray());
        HashMap numberUserIdMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    numberUserIdMap.put(row.getString("fnumber"), row.getLong("fid"));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        assessorId.forEach(assessorUserId -> {
            Long userId;
            String phone = (String)userIdPhoneMap.get(assessorUserId);
            if (!HRStringUtils.isEmpty((String)phone) && (userId = (Long)numberUserIdMap.get(phone)) != null) {
                userIdMap.put(assessorUserId, userId);
            }
        });
        return userIdMap;
    }

    static {
        scoreMap.put(ACTSCHEME_COLUMN, 5);
        scoreMap.put(ONBOARDACTIVE_COLUMN, 4);
        scoreMap.put(INFORCOLLECT_COLUMN, 4);
        scoreMap.put(ONBOARDCOMPLETE_COLUMN, 2);
        scoreMap.put(SIGNATURETEMPLATE_COLUMN, 2);
        scoreMap.put(CONTRACTSTRATEGY_COLUMN, 2);
        scoreMap.put(CONTRACTSIGNING_COLUMN, 1);
        scoreMap.put(APPLYFORFULLMEMBER_COLUMN, 4);
        scoreMap.put(POSITIVERESULT_COLUMN, 1);
        scoreMap.put(FILEVIEW_COLUMN, 2);
        scoreMap.put(FILESTRATEGY_COLUMN, 3);
    }
}

