/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine.business.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.hdtc.hrdt.formplugin.web.examine.HRExamineDataBo;
import kd.hdtc.hrdt.formplugin.web.examine.business.IHRExamineListService;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ODCExamineListServiceImpl
implements IHRExamineListService {
    private static final String HR_DB_KEY = "hr";
    private static final String ORGBILL_COLUMN = "orgbill";
    private static final String STAFF_COLUMN = "staff";
    private static final int ORGBILL_SCORE = 2;
    private static final int STAFF_SCORE = 3;

    @Override
    public void addFields(List<HRExamineDataBo> fieldsList) {
        fieldsList.add(new HRExamineDataBo(ORGBILL_COLUMN, (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo(STAFF_COLUMN, (DataType)DataType.BigDecimalType, true));
    }

    @Override
    public void setExamineScore(Map<Long, Map<String, Object>> dataMap) {
        this.calculateOrgBillScore(dataMap);
        this.calculateStaffScore(dataMap);
    }

    private void calculateOrgBillScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcreatorid,count(fid) as num from t_homs_orgchgbill where", new Object[0]);
        sqlBuilder.appendIn(" fcreatorid", dataMap.keySet().toArray());
        sqlBuilder.append(" and fbillstatus = 'C'", new Object[0]);
        sqlBuilder.append(" group by fcreatorid", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryDataPerm", (DBRoute)DBRoute.of((String)HR_DB_KEY), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Map<String, Object> info = dataMap.get(row.getLong("fcreatorid"));
                    if (row.getInteger("num") <= 0) continue;
                    info.put(ORGBILL_COLUMN, 2);
                }
            }
        }
    }

    private void calculateStaffScore(Map<Long, Map<String, Object>> dataMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcreatorid,fyear,count(fid) as num from t_haos_staff where fenable = '1'", new Object[0]);
        sqlBuilder.appendIn(" and fcreatorid", dataMap.keySet().toArray());
        sqlBuilder.append(" group by fcreatorid,fyear", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryDataPerm", (DBRoute)DBRoute.of((String)HR_DB_KEY), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    Map<String, Object> info = dataMap.get(row.getLong("fcreatorid"));
                    Date year = row.getDate("fyear");
                    if (row.getInteger("num") <= 0 || year == null || HRDateTimeUtils.getYear((Date)year) != 2024) continue;
                    info.put(STAFF_COLUMN, 3);
                }
            }
        }
    }
}

