/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine.business.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdt.formplugin.web.examine.HRExamineDataBo;
import kd.hdtc.hrdt.formplugin.web.examine.business.IHRExamineListService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.MapUtils;

public class SITExamineListServiceImpl
implements IHRExamineListService {
    private static final boolean checkEmpNumber = true;
    private static Set<String> itemSet1 = new HashSet<String>();
    private static Set<String> itemSet2 = new HashSet<String>();

    @Override
    public void addFields(List<HRExamineDataBo> fieldsList) {
        fieldsList.add(new HRExamineDataBo("endowment", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("reservefund", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("socialpromotion", (DataType)DataType.BigDecimalType, true));
    }

    @Override
    public void setExamineScore(Map<Long, Map<String, Object>> dataMap) {
        QFilter qFilter1 = new QFilter("id", "in", dataMap.keySet());
        DynamicObject[] dynColl1 = new HRBaseServiceHelper("bos_user").query("id,phone", new QFilter[]{qFilter1});
        Map<Long, DynamicObject> userMap = this.transferMapObjWithLong(dynColl1, "id");
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            DynamicObject dynamicObject = userMap.get(userId);
            mapEntry.getValue().put("phone", dynamicObject.getString("phone"));
        }
        this.calSinSurData(dataMap);
    }

    private void calSinSurData(Map<Long, Map<String, Object>> dataMap) {
        QFilter qFilter1 = new QFilter("creator", "in", dataMap.keySet());
        DynamicObject[] dynColl1 = new HRBaseServiceHelper("hcsi_sinsurtask").query("id,creator.id,welfarepayer.name,mulsinsurstd.name,actualwelfarepayer.name,pushstatus", new QFilter[]{qFilter1});
        Map<Long, List<DynamicObject>> sinsurtaskMap = this.transferMapListWithLong(dynColl1, "creator.id");
        HashMap<Long, Long> taskMap = new HashMap<Long, Long>();
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            String userNumber = MapUtils.getString(mapEntry.getValue(), (Object)"usernumber");
            String userName = MapUtils.getString(mapEntry.getValue(), (Object)"username");
            String preName = userNumber + userName;
            DynamicObject sinsurtask = null;
            List<DynamicObject> sinsurtaskList = sinsurtaskMap.get(userId);
            if (sinsurtaskList == null) continue;
            for (DynamicObject dynamicObject : sinsurtaskList) {
                if (!this.checkSinsurstd(dynamicObject, preName) || !HRStringUtils.equals((String)dynamicObject.getString("welfarepayer.name"), (String)ResManager.loadKDString((String)"%s\u793e\u4fdd\u5355\u4f4d", (String)"SITExamineListServiceImpl_4", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{preName}))) continue;
                sinsurtask = dynamicObject;
                taskMap.put(userId, sinsurtask.getLong("id"));
            }
        }
        QFilter qFilter3 = new QFilter("sinsurtask.id", "in", taskMap.values());
        DynamicObject[] dynColl3 = new HRBaseServiceHelper("hcsi_calperson").query("sinsurtask.id,empnumberdb,pushstatus,insuranceitem.name,amountvalue", new QFilter[]{qFilter3});
        Map<Long, List<DynamicObject>> calpersonMap = this.transferMapListWithLong(dynColl3, "sinsurtask.id");
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            String userNumber = MapUtils.getString(mapEntry.getValue(), (Object)"usernumber");
            String phone = MapUtils.getString(mapEntry.getValue(), (Object)"phone");
            Long taskId = (Long)taskMap.get(userId);
            List<DynamicObject> calPersonList = calpersonMap.get(taskId);
            if (calPersonList == null) continue;
            for (DynamicObject dynamicObject : calPersonList) {
                String empNumber = dynamicObject.getString("empnumberdb");
                if (!HRStringUtils.equals((String)empNumber, (String)phone)) continue;
                Map<String, Object> map = this.checkSinsurItem(dynamicObject);
                mapEntry.getValue().putAll(map);
                if (dynamicObject == null || !HRStringUtils.equals((String)dynamicObject.getString("pushstatus"), (String)"pushed")) continue;
                mapEntry.getValue().put("socialpromotion", 2);
            }
        }
    }

    private boolean checkSinsurstd(DynamicObject dynamicObject, String preName) {
        DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("mulsinsurstd");
        if (coll == null) {
            return false;
        }
        for (DynamicObject dy : coll) {
            if (!HRStringUtils.equals((String)dy.getLocaleString("fbasedataid.name").getLocaleValue(), (String)ResManager.loadKDString((String)"%s\u53c2\u4fdd\u6807\u51c6", (String)"SITExamineListServiceImpl_5", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{preName}))) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> checkSinsurItem(DynamicObject dynamicObject) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        int num1 = 0;
        int num2 = 0;
        DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity");
        if (coll != null) {
            for (DynamicObject dy : coll) {
                if (itemSet1.contains(dy.getString("insuranceitem.name")) && this.isBigDecimalEquals(dy.getBigDecimal("amountvalue"), new BigDecimal("2000"))) {
                    ++num1;
                }
                if (!itemSet2.contains(dy.getString("insuranceitem.name")) || !this.isBigDecimalEquals(dy.getBigDecimal("amountvalue"), new BigDecimal("1000"))) continue;
                ++num2;
            }
        }
        if (num1 == 2) {
            map.put("endowment", 4);
        }
        if (num2 == 2) {
            map.put("reservefund", 4);
        }
        return map;
    }

    private Map<Long, DynamicObject> transferMapObjWithLong(DynamicObject[] dynColl, String field) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : dynColl) {
            Long LongValue = dynamicObject.getLong(field);
            map.put(LongValue, dynamicObject);
        }
        return map;
    }

    private Map<Long, List<DynamicObject>> transferMapListWithLong(DynamicObject[] dynColl, String field) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : dynColl) {
            Long longValue = dynamicObject.getLong(field);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(longValue);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                map.put(longValue, list);
            }
            list.add(dynamicObject);
        }
        return map;
    }

    private Map<String, List<DynamicObject>> transferMapListWithString(DynamicObject[] dynColl, String field) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : dynColl) {
            String name = dynamicObject.getString(field);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(name);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                map.put(name, list);
            }
            list.add(dynamicObject);
        }
        return map;
    }

    private boolean isBigDecimalEquals(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return false;
        }
        return a.compareTo(b) == 0;
    }

    static {
        itemSet1.add(ResManager.loadKDString((String)"\u517b\u8001\u4fdd\u9669\u4e2a\u4eba\u7f34\u8d39\u91d1\u989d", (String)"SITExamineListServiceImpl_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        itemSet1.add(ResManager.loadKDString((String)"\u517b\u8001\u4fdd\u9669\u5355\u4f4d\u7f34\u8d39\u91d1\u989d", (String)"SITExamineListServiceImpl_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        itemSet2.add(ResManager.loadKDString((String)"\u4f4f\u623f\u516c\u79ef\u91d1\u4e2a\u4eba\u7f34\u8d39\u91d1\u989d", (String)"SITExamineListServiceImpl_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        itemSet2.add(ResManager.loadKDString((String)"\u4f4f\u623f\u516c\u79ef\u91d1\u5355\u4f4d\u7f34\u8d39\u91d1\u989d", (String)"SITExamineListServiceImpl_3", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
    }
}

