/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine.business.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdt.formplugin.web.examine.HRExamineDataBo;
import kd.hdtc.hrdt.formplugin.web.examine.business.IHRExamineListService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.MapUtils;

public class SWCExamineListServiceImpl
implements IHRExamineListService {
    private static final boolean checkEmpNumber = true;

    @Override
    public void addFields(List<HRExamineDataBo> fieldsList) {
        fieldsList.add(new HRExamineDataBo("salarystructure", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("decideperson", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("itemandvalue", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("itemovertime", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("itemshoudissued", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("itemendowment", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("itemreservefund", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("itemactualissued", (DataType)DataType.BigDecimalType, true));
    }

    @Override
    public void setExamineScore(Map<Long, Map<String, Object>> dataMap) {
        QFilter qFilter1 = new QFilter("id", "in", dataMap.keySet());
        DynamicObject[] dynColl1 = new HRBaseServiceHelper("bos_user").query("id,phone", new QFilter[]{qFilter1});
        Map<Long, DynamicObject> userMap = this.transferMapObjWithLong(dynColl1, "id");
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            DynamicObject dynamicObject = userMap.get(userId);
            mapEntry.getValue().put("phone", dynamicObject.getString("phone"));
        }
        this.calHcdmData(dataMap);
        this.calHsasData(dataMap);
    }

    private void calHsasData(Map<Long, Map<String, Object>> dataMap) {
        QFilter qFilter1 = new QFilter("creator", "in", dataMap.keySet());
        DynamicObject[] dynColl1 = new HRBaseServiceHelper("hsas_calpayrolltask").query("id,creator.id,name,payrollscene.name,period.perioddate", new QFilter[]{qFilter1});
        Map<Long, List<DynamicObject>> calpayrolltaskMap = this.transferMapListWithLong(dynColl1, "creator.id");
        HashMap<Long, ArrayList<Long>> map = new HashMap<Long, ArrayList<Long>>();
        HashSet<Long> idSet = new HashSet<Long>(16);
        HashSet<Object> empNumberSet = new HashSet<Object>(16);
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            String userNumber = MapUtils.getString(mapEntry.getValue(), (Object)"usernumber");
            String userName = MapUtils.getString(mapEntry.getValue(), (Object)"username");
            String phone = MapUtils.getString(mapEntry.getValue(), (Object)"phone");
            String string = userNumber + userName;
            List<DynamicObject> calpayrolltaskList = calpayrolltaskMap.get(userId);
            if (calpayrolltaskList == null) continue;
            for (DynamicObject dynamicObject : calpayrolltaskList) {
                String name1 = ResManager.loadKDString((String)"%s\u85aa\u8d44\u6838\u7b97", (String)"SWCExamineListServiceImpl_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{string});
                String name2 = ResManager.loadKDString((String)"%s\u85aa\u8d44\u6838\u7b97\u573a\u666f", (String)"SWCExamineListServiceImpl_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{string});
                if (!HRStringUtils.equals((String)dynamicObject.getString("name"), (String)name1) || !HRStringUtils.equals((String)dynamicObject.getString("payrollscene.name"), (String)name2) || !HRStringUtils.equals((String)HRDateTimeUtils.format((Date)dynamicObject.getDate("period.perioddate"), (String)"yyyy-MM"), (String)"2024-01")) continue;
                ArrayList<Long> tmpIds = (ArrayList<Long>)map.get(userId);
                if (tmpIds == null) {
                    tmpIds = new ArrayList<Long>(10);
                    map.put(userId, tmpIds);
                }
                tmpIds.add(dynamicObject.getLong("id"));
                idSet.add(dynamicObject.getLong("id"));
            }
            empNumberSet.add(phone);
        }
        QFilter qFilter2 = new QFilter("caltask.id", "in", idSet);
        qFilter2.and("empnumber", "in", empNumberSet);
        DynamicObject[] dynColl2 = new HRBaseServiceHelper("hsas_calperson").query("id,caltask.id,empnumber", new QFilter[]{qFilter2});
        HashMap<Long, ArrayList<Long>> calpersonMap = new HashMap<Long, ArrayList<Long>>();
        Map<Long, List<DynamicObject>> map2 = this.transferMapListWithLong(dynColl2, "caltask.id");
        HashSet<Long> idSet2 = new HashSet<Long>(16);
        for (Map.Entry entry : dataMap.entrySet()) {
            Long userId = (Long)entry.getKey();
            String userNumber = MapUtils.getString((Map)((Map)entry.getValue()), (Object)"usernumber");
            String string = MapUtils.getString((Map)((Map)entry.getValue()), (Object)"username");
            String phone = MapUtils.getString((Map)((Map)entry.getValue()), (Object)"phone");
            String preName = userNumber + string;
            List taskIds = (List)map.get(userId);
            if (taskIds == null) continue;
            for (Long taskId : taskIds) {
                List<DynamicObject> calPersonList = map2.get(taskId);
                if (calPersonList == null) continue;
                for (DynamicObject dynamicObject : calPersonList) {
                    if (!HRStringUtils.equals((String)dynamicObject.getString("empnumber"), (String)phone)) continue;
                    ArrayList<Long> tmpIds = (ArrayList<Long>)calpersonMap.get(userId);
                    if (tmpIds == null) {
                        tmpIds = new ArrayList<Long>(10);
                        calpersonMap.put(userId, tmpIds);
                    }
                    tmpIds.add(dynamicObject.getLong("id"));
                    idSet2.add(dynamicObject.getLong("id"));
                }
            }
        }
        QFilter qFilter3 = new QFilter("calpersonid", "in", idSet2);
        DynamicObject[] dynamicObjectArray = new HRBaseServiceHelper("hsas_caltable").query("id,calpersonid,salaryitem.name,calamountvalue", new QFilter[]{qFilter3});
        Map<Long, List<DynamicObject>> CalTableMap = this.transferMapListWithLong(dynamicObjectArray, "calpersonid");
        for (Map.Entry entry : dataMap.entrySet()) {
            Long userId = (Long)entry.getKey();
            String userNumber = MapUtils.getString((Map)((Map)entry.getValue()), (Object)"usernumber");
            List calPersonIds = (List)calpersonMap.get(userId);
            if (calPersonIds == null) continue;
            for (Long calPersonId : calPersonIds) {
                List<DynamicObject> calTableList = CalTableMap.get(calPersonId);
                if (calTableList == null) continue;
                String name1 = ResManager.loadKDString((String)"%s\u8282\u5047\u65e5\u52a0\u73ed\u8d39", (String)"SWCExamineListServiceImpl_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
                String name2 = ResManager.loadKDString((String)"%s\u5e94\u53d1\u5408\u8ba1", (String)"SWCExamineListServiceImpl_3", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
                String name3 = ResManager.loadKDString((String)"%s\u5458\u5de5\u4e2a\u4eba\u517b\u8001\u4fdd\u9669", (String)"SWCExamineListServiceImpl_4", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
                String name4 = ResManager.loadKDString((String)"%s\u5458\u5de5\u4e2a\u4eba\u516c\u79ef\u91d1", (String)"SWCExamineListServiceImpl_5", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
                String name5 = ResManager.loadKDString((String)"%s\u5b9e\u53d1\u5408\u8ba1", (String)"SWCExamineListServiceImpl_6", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
                for (DynamicObject dynamicObject : calTableList) {
                    DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("hsas_caltableentry");
                    if (coll == null) continue;
                    for (DynamicObject dy : coll) {
                        if (HRStringUtils.equals((String)dy.getString("salaryitem.name"), (String)name1) && this.isBigDecimalEquals(dy.getBigDecimal("calamountvalue"), new BigDecimal("1379.31"))) {
                            ((Map)entry.getValue()).put("itemovertime", 3);
                        }
                        if (HRStringUtils.equals((String)dy.getString("salaryitem.name"), (String)name2) && this.isBigDecimalEquals(dy.getBigDecimal("calamountvalue"), new BigDecimal("7379.31"))) {
                            ((Map)entry.getValue()).put("itemshoudissued", 3);
                        }
                        if (HRStringUtils.equals((String)dy.getString("salaryitem.name"), (String)name3) && this.isBigDecimalEquals(dy.getBigDecimal("calamountvalue"), new BigDecimal("2000"))) {
                            ((Map)entry.getValue()).put("itemendowment", 3);
                        }
                        if (HRStringUtils.equals((String)dy.getString("salaryitem.name"), (String)name4) && this.isBigDecimalEquals(dy.getBigDecimal("calamountvalue"), new BigDecimal("1000"))) {
                            ((Map)entry.getValue()).put("itemreservefund", 3);
                        }
                        if (!HRStringUtils.equals((String)dy.getString("salaryitem.name"), (String)name5) || !this.isBigDecimalEquals(dy.getBigDecimal("calamountvalue"), new BigDecimal("4379.31"))) continue;
                        ((Map)entry.getValue()).put("itemactualissued", 3);
                    }
                }
            }
        }
    }

    private void calHcdmData(Map<Long, Map<String, Object>> dataMap) {
        QFilter qFilter1 = new QFilter("creator", "in", dataMap.keySet());
        DynamicObject[] dynColl1 = new HRBaseServiceHelper("hcdm_salaystructure").query("id,creator.id,name,country.name,standarditem.name,fixeditem", new QFilter[]{qFilter1});
        Map<Long, List<DynamicObject>> salaystructureMap = this.transferMapListWithLong(dynColl1, "creator.id");
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            String userNumber = MapUtils.getString(mapEntry.getValue(), (Object)"usernumber");
            String userName = MapUtils.getString(mapEntry.getValue(), (Object)"username");
            String preName = userNumber + userName;
            List<DynamicObject> list = salaystructureMap.get(userId);
            if (list == null) continue;
            String name = ResManager.loadKDString((String)"%s\u85aa\u916c\u7ed3\u6784", (String)"SWCExamineListServiceImpl_7", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{preName});
            String countryname = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"SWCExamineListServiceImpl_11", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{preName});
            for (DynamicObject dynamicObject : list) {
                boolean flag;
                if (!HRStringUtils.equals((String)dynamicObject.getString("name"), (String)name) || !HRStringUtils.equals((String)dynamicObject.getString("country.name"), (String)countryname) || !(flag = this.checkSalayStructure(dynamicObject, userNumber))) continue;
                mapEntry.getValue().put("salarystructure", 3);
            }
        }
        QFilter qFilter2 = new QFilter("creator", "in", dataMap.keySet());
        DynamicObject[] dynColl2 = new HRBaseServiceHelper("hcdm_adjapprbill").query("id,creator.id,billname", new QFilter[]{qFilter2});
        Map<Long, List<DynamicObject>> map = this.transferMapListWithLong(dynColl2, "creator.id");
        HashMap<Long, ArrayList<Long>> adjapprbillMap = new HashMap<Long, ArrayList<Long>>();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (Map.Entry entry : dataMap.entrySet()) {
            Long userId = (Long)entry.getKey();
            String userNumber = MapUtils.getString((Map)((Map)entry.getValue()), (Object)"usernumber");
            String userName = MapUtils.getString((Map)((Map)entry.getValue()), (Object)"username");
            String preName = userNumber + userName;
            List<DynamicObject> list = map.get(userId);
            if (list == null) continue;
            String name = ResManager.loadKDString((String)"%s\u5b9a\u85aa\u7533\u8bf7\u5355", (String)"SWCExamineListServiceImpl_8", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{preName});
            for (DynamicObject dynamicObject : list) {
                if (!HRStringUtils.startsWithIgnoreCase((String)dynamicObject.getString("billname"), (String)name)) continue;
                ArrayList<Long> tmpIds = (ArrayList<Long>)adjapprbillMap.get(userId);
                if (tmpIds == null) {
                    tmpIds = new ArrayList<Long>(10);
                    adjapprbillMap.put(userId, tmpIds);
                }
                tmpIds.add(dynamicObject.getLong("id"));
                idSet.add(dynamicObject.getLong("id"));
            }
        }
        QFilter qFilter3 = new QFilter("adjapprbill", "in", idSet);
        DynamicObject[] dynamicObjectArray = new HRBaseServiceHelper("hcdm_adjapprperson").query("id,adjapprbill,number,salarystructure.name,standarditem.name,amount,salbsed", new QFilter[]{qFilter3});
        Map<Long, List<DynamicObject>> adjapprpersonListMap = this.transferMapListWithLong(dynamicObjectArray, "adjapprbill");
        for (Map.Entry<Long, Map<String, Object>> mapEntry : dataMap.entrySet()) {
            Long userId = mapEntry.getKey();
            String userNumber = MapUtils.getString(mapEntry.getValue(), (Object)"usernumber");
            String phone = MapUtils.getString(mapEntry.getValue(), (Object)"phone");
            String userName = MapUtils.getString(mapEntry.getValue(), (Object)"username");
            String preName = userNumber + userName;
            List adjapprbillIds = (List)adjapprbillMap.get(userId);
            if (adjapprbillIds == null) continue;
            for (Long adjapprbillId : adjapprbillIds) {
                List<DynamicObject> list = adjapprpersonListMap.get(adjapprbillId);
                if (list == null) continue;
                String name = ResManager.loadKDString((String)"%s\u85aa\u916c\u7ed3\u6784", (String)"SWCExamineListServiceImpl_7", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{preName});
                for (DynamicObject dynamicObject : list) {
                    if (!HRStringUtils.equals((String)dynamicObject.getString("number"), (String)phone) || !HRStringUtils.equals((String)dynamicObject.getString("salarystructure.name"), (String)name)) continue;
                    mapEntry.getValue().put("decideperson", 2);
                    boolean flag = this.checkadjapprperson(dynamicObject, userNumber);
                    if (!flag) continue;
                    mapEntry.getValue().put("itemandvalue", 5);
                }
            }
        }
    }

    private boolean checkadjapprperson(DynamicObject dynamicObject, String userNumber) {
        int num = 0;
        DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity");
        if (coll == null) {
            return false;
        }
        String name1 = ResManager.loadKDString((String)"%s\u57fa\u672c\u5de5\u8d44", (String)"SWCExamineListServiceImpl_9", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
        String name2 = ResManager.loadKDString((String)"%s\u7ee9\u6548\u5de5\u8d44", (String)"SWCExamineListServiceImpl_10", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
        for (DynamicObject dy : coll) {
            if (!HRStringUtils.equals((String)HRDateTimeUtils.format((Date)dy.getDate("salbsed"), (String)"yyyy-MM-dd"), (String)"2024-01-01")) continue;
            if (HRStringUtils.equals((String)dy.getString("standarditem.name"), (String)name1) && this.isBigDecimalEquals(dy.getBigDecimal("amount"), new BigDecimal("3000"))) {
                ++num;
                continue;
            }
            if (!HRStringUtils.equals((String)dy.getString("standarditem.name"), (String)name2) || !this.isBigDecimalEquals(dy.getBigDecimal("amount"), new BigDecimal("2000"))) continue;
            ++num;
        }
        return num == 2;
    }

    private boolean checkSalayStructure(DynamicObject dynamicObject, String userNumber) {
        int num = 0;
        DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity");
        if (coll == null) {
            return false;
        }
        String name1 = ResManager.loadKDString((String)"%s\u57fa\u672c\u5de5\u8d44", (String)"SWCExamineListServiceImpl_9", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
        String name2 = ResManager.loadKDString((String)"%s\u7ee9\u6548\u5de5\u8d44", (String)"SWCExamineListServiceImpl_10", (String)"hdtc-hrdt-formplugin", (Object[])new Object[]{userNumber});
        for (DynamicObject dy : coll) {
            if (HRStringUtils.equals((String)dy.getString("standarditem.name"), (String)name1) && HRStringUtils.equals((String)dy.getString("fixeditem"), (String)"1")) {
                ++num;
            }
            if (!HRStringUtils.equals((String)dy.getString("standarditem.name"), (String)name2) || !HRStringUtils.equals((String)dy.getString("fixeditem"), (String)"0")) continue;
            ++num;
        }
        return num == 2;
    }

    private Map<Long, List<DynamicObject>> transferMapListWithLong(DynamicObject[] dynColl, String field) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        if (dynColl == null) {
            return map;
        }
        for (DynamicObject dynamicObject : dynColl) {
            Long longValue = dynamicObject.getLong(field);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(longValue);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                map.put(longValue, list);
            }
            list.add(dynamicObject);
        }
        return map;
    }

    private boolean isBigDecimalEquals(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return false;
        }
        return a.compareTo(b) == 0;
    }

    private Map<Long, DynamicObject> transferMapObjWithLong(DynamicObject[] dynColl, String field) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : dynColl) {
            Long LongValue = dynamicObject.getLong(field);
            map.put(LongValue, dynamicObject);
        }
        return map;
    }
}

