/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.examine.business.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdt.common.enums.WTCItemUnitEnum;
import kd.hdtc.hrdt.formplugin.web.examine.HRExamineDataBo;
import kd.hdtc.hrdt.formplugin.web.examine.business.IHRExamineListService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;

public class WTCExamineListServiceImpl
implements IHRExamineListService {
    private Map<Long, Long> personWithUserIdMap = Maps.newHashMapWithExpectedSize((int)16);

    @Override
    public void addFields(List<HRExamineDataBo> fieldsList) {
        fieldsList.add(new HRExamineDataBo("tcardrule", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("shift", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("vaplan", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("explan", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attgateway", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("qtdetail", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attfile", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("vaapply", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("exrecord", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attdatapushrule", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attdatapushresult", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("effcard", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attresultitem", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attlateness", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attnightshifts", (DataType)DataType.BigDecimalType, true));
        fieldsList.add(new HRExamineDataBo("attovertime", (DataType)DataType.BigDecimalType, true));
    }

    @Override
    public void setExamineScore(Map<Long, Map<String, Object>> dataMap) {
        Map<Object, Object> phoneWithUserIdMap = dataMap.values().stream().collect(Collectors.toMap(map -> map.get("phone"), map -> map.get("userid"), (a, b) -> a));
        List numberList = dataMap.values().stream().map(map -> map.get("phone")).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attendperson");
        DynamicObject[] personDys = helper.queryOriginalArray("id, number", new QFilter[]{new QFilter("number", "in", numberList)});
        this.personWithUserIdMap = Arrays.stream(personDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> (Long)phoneWithUserIdMap.get(dy.getString("number")), (a, b) -> a));
        this.addScoreByTarget(dataMap, "tcardrule", "t_wtbd_tcardrule", new BigDecimal("1"));
        this.addScoreByTarget(dataMap, "shift", "t_wtbd_shift", new BigDecimal("1"));
        this.addScoreByTarget(dataMap, "vaplan", "t_wtp_vacationplan", new BigDecimal("1"));
        this.addScoreByTarget(dataMap, "explan", "t_wtp_exscheme", new BigDecimal("1"));
        this.addAttFileScore(dataMap);
        this.addVAScore(dataMap);
        this.addExScore(dataMap);
        this.addAttReCord(dataMap);
        this.addAttresultitem(dataMap);
        this.addScoreByTarget(dataMap, "attdatapushrule", "t_wtis_integrationrule", new BigDecimal("2"));
        this.addAttDataPushResult(dataMap);
    }

    private void addAttDataPushResult(Map<Long, Map<String, Object>> dataMap) {
        ArrayList personIdList = Lists.newArrayListWithExpectedSize((int)1);
        HashMap personIdUserIdMap = Maps.newHashMapWithExpectedSize((int)1);
        this.callHRPIPersonByUserId(dataMap, personIdList, personIdUserIdMap);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("generstatus", "=", (Object)"1").and("creator", "in", (Object)dataMap.keySet().toArray())};
        DynamicObject[] attDataPushDys = helper.query("id,creator.id", qFilters);
        Map<Long, DynamicObject> personIdAttFileMap = Arrays.stream(attDataPushDys).collect(Collectors.toMap(item -> item.getLong("creator.id"), item -> item, (item1, item2) -> item1));
        personIdAttFileMap.forEach((creatorId, attFile) -> {
            Map info = (Map)dataMap.get(creatorId);
            info.put("attdatapushresult", 3);
        });
    }

    private void addExScore(Map<Long, Map<String, Object>> dataMap) {
        HRBaseServiceHelper attFileServiceHelper = new HRBaseServiceHelper("wtte_exrecord");
        DynamicObject[] exRecordDys = attFileServiceHelper.query("id, personid.id, recorddate", new QFilter[]{new QFilter("personid", "in", this.personWithUserIdMap.keySet()).and("confirmstatus", "=", (Object)"1")});
        HRBaseServiceHelper supSignHelper = new HRBaseServiceHelper("wtpm_supsignpc");
        DynamicObject[] supSignDys = supSignHelper.queryOriginalArray("personid, entryentity.signdate", new QFilter[]{new QFilter("personid", "in", this.personWithUserIdMap.keySet())});
        Map<Long, List<DynamicObject>> supSignMap = Arrays.stream(supSignDys).collect(Collectors.groupingBy(dy -> dy.getLong("personid")));
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)exRecordDys.length);
        for (DynamicObject exRecordDy : exRecordDys) {
            boolean anyMatch;
            long personId2 = exRecordDy.getLong("personid.id");
            Date recordDate = exRecordDy.getDate("recorddate");
            List<DynamicObject> dys = supSignMap.get(personId2);
            if (CollectionUtils.isEmpty(dys) || !(anyMatch = dys.stream().anyMatch(dy -> DateTimeUtils.dayEquals((Date)recordDate, (Date)dy.getDate("entryentity.signdate"))))) continue;
            personIdSet.add(personId2);
        }
        personIdSet.forEach(personId -> {
            Map info = (Map)dataMap.get(this.personWithUserIdMap.get(personId));
            info.put("exrecord", 4);
        });
    }

    private void addScoreByTarget(Map<Long, Map<String, Object>> dataMap, String target, String tableName, BigDecimal score) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcreatorid,count(*) as num from ", new Object[0]).append(tableName, new Object[0]).append(" where", new Object[0]);
        sqlBuilder.appendIn("fcreatorid", dataMap.keySet().toArray());
        sqlBuilder.append("group by fcreatorid", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryDataPerm", (DBRoute)DBRoute.of((String)"wtc"), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    int num = row.getInteger("num");
                    Long creatorId = row.getLong("fcreatorid");
                    Map<String, Object> info = dataMap.get(creatorId);
                    if (num <= 0) continue;
                    info.put(target, score);
                }
            }
        }
    }

    private void addAttFileScore(Map<Long, Map<String, Object>> dataMap) {
        HRBaseServiceHelper attFileServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject[] attFileArr = attFileServiceHelper.query("id, person", new QFilter[]{new QFilter("person", "in", this.personWithUserIdMap.keySet()).and("iscurrentversion", "=", (Object)"1")});
        Map<Long, DynamicObject> personIdAttFileMap = Arrays.stream(attFileArr).collect(Collectors.toMap(item -> item.getLong("person.id"), item -> item, (item1, item2) -> item1));
        personIdAttFileMap.forEach((personId, attFile) -> {
            Map info = (Map)dataMap.get(this.personWithUserIdMap.get(personId));
            info.put("attfile", 3);
        });
    }

    private void addQTScore(Map<Long, Map<String, Object>> dataMap) {
        DynamicObject[] qtDetailArr;
        ArrayList personIdList = Lists.newArrayListWithExpectedSize((int)1);
        HashMap personIdUserIdMap = Maps.newHashMapWithExpectedSize((int)1);
        this.callHRPIPersonByUserId(dataMap, personIdList, personIdUserIdMap);
        HRBaseServiceHelper qtDetailServiceHelper = new HRBaseServiceHelper("wtp_qtlinedetail");
        String vacationTypeNameStr = ResManager.loadKDString((String)"%\u5e74\u5047%", (String)"WTCExamineListServiceImpl_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        try {
            qtDetailArr = qtDetailServiceHelper.queryOriginalArray("id,attfileid", new QFilter[]{new QFilter("source", "=", (Object)"DT-000").and("qttype.name", "like", (Object)vacationTypeNameStr).and("usestartdate", ">=", (Object)HRDateTimeUtils.parseDate((String)"20240101", (String)"yyyyMMdd")).and("usestartdate", "<", (Object)HRDateTimeUtils.parseDate((String)"20240102", (String)"yyyyMMdd")).and("useenddate", ">=", (Object)HRDateTimeUtils.parseDate((String)"20241231", (String)"yyyyMMdd")).and("useenddate", "<", (Object)HRDateTimeUtils.parseDate((String)"20250101", (String)"yyyyMMdd")).and("creator", "in", dataMap.keySet())});
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        Set attFileId = Arrays.stream(qtDetailArr).map(dy -> dy.getLong("attfileid")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject[] attFileDys = helper.queryOriginalArray("id, person", new QFilter[]{new QFilter("id", "in", attFileId)});
        Map<Long, Long> attFileMap = Arrays.stream(attFileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person"), (a, b) -> a));
        Map<Long, DynamicObject> personIdAttFileMap = Arrays.stream(qtDetailArr).collect(Collectors.toMap(item -> (Long)attFileMap.get(item.getLong("attfileid")), item -> item, (item1, item2) -> item1));
        personIdAttFileMap.forEach((personId, attFile) -> {
            Map info = (Map)dataMap.get(personIdUserIdMap.get(personId));
            info.put("qtdetail", 3);
        });
    }

    private void addVAScore(Map<Long, Map<String, Object>> dataMap) {
        HRBaseServiceHelper qtDetailServiceHelper = new HRBaseServiceHelper("wtabm_vaapplyself");
        String vacationTypeNameStr = ResManager.loadKDString((String)"%\u5e74\u5047%", (String)"WTCExamineListServiceImpl_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        DynamicObject[] vaDetailArr = qtDetailServiceHelper.query("id,personid", new QFilter[]{new QFilter("applytyperadio", "=", (Object)"0").and("entryentity.entryvacationtype.name", "like", (Object)vacationTypeNameStr).and("personid", "in", this.personWithUserIdMap.keySet()).and("billstatus", "=", (Object)"C")});
        Map<Long, DynamicObject> personIdAttFileMap = Arrays.stream(vaDetailArr).collect(Collectors.toMap(item -> item.getLong("personid.id"), item -> item, (item1, item2) -> item1));
        personIdAttFileMap.forEach((personId, attFile) -> {
            Map info = (Map)dataMap.get(this.personWithUserIdMap.get(personId));
            info.put("vaapply", 4);
        });
    }

    private void addAttReCord(Map<Long, Map<String, Object>> dataMap) {
        HRBaseServiceHelper wtsPersonrosterHelper = new HRBaseServiceHelper("wts_personroster");
        DynamicObject[] vaDetailArr = wtsPersonrosterHelper.query("id,attperson,shiftid", new QFilter[]{new QFilter("attperson", "in", this.personWithUserIdMap.keySet()).and("datastatus", "=", (Object)"1")});
        List collect = Arrays.stream(vaDetailArr).collect(Collectors.toList());
        HRBaseServiceHelper wtpmMulticardHelper = new HRBaseServiceHelper("wtpm_multicard");
        DynamicObject[] vaDetailArr1 = wtpmMulticardHelper.query("id,attperson,shift", new QFilter[]{new QFilter("attperson", "in", this.personWithUserIdMap.keySet())});
        List collect1 = Arrays.stream(vaDetailArr1).collect(Collectors.toList());
        HRBaseServiceHelper wtpmOncecardHelper = new HRBaseServiceHelper("wtpm_oncecard");
        DynamicObject[] vaDetailArr2 = wtpmOncecardHelper.query("id,attperson,shift", new QFilter[]{new QFilter("attperson", "in", this.personWithUserIdMap.keySet())});
        List collect2 = Arrays.stream(vaDetailArr2).collect(Collectors.toList());
        collect1.addAll(collect2);
        HRBaseServiceHelper wtpmLackcardHelper = new HRBaseServiceHelper("wtpm_lackcard");
        DynamicObject[] vaDetailArr3 = wtpmLackcardHelper.query("id,attperson,shift", new QFilter[]{new QFilter("attperson", "in", this.personWithUserIdMap.keySet())});
        List collect3 = Arrays.stream(vaDetailArr3).collect(Collectors.toList());
        collect1.addAll(collect3);
        HRBaseServiceHelper wtpmCheckcardHelper = new HRBaseServiceHelper("wtpm_checkcard");
        DynamicObject[] vaDetailArr4 = wtpmCheckcardHelper.query("id,attperson,shift", new QFilter[]{new QFilter("attperson", "in", this.personWithUserIdMap.keySet())});
        List collect4 = Arrays.stream(vaDetailArr4).collect(Collectors.toList());
        collect1.addAll(collect4);
        if (CollectionUtils.isEmpty(collect1) || CollectionUtils.isEmpty(collect)) {
            return;
        }
        Map<Long, DynamicObject> personIdAttFileMap = collect.stream().collect(Collectors.toMap(item -> item.getLong("attperson.id"), item -> item, (item1, item2) -> item1));
        Map<Long, DynamicObject> dynamicObjectMap = collect1.stream().collect(Collectors.toMap(item -> item.getLong("attperson.id"), item -> item, (item1, item2) -> item1));
        personIdAttFileMap.keySet().stream().filter(dynamicObjectMap::containsKey).map(personId -> (Map)dataMap.get(this.personWithUserIdMap.get(personId))).forEach(info -> info.put("effcard", 2));
    }

    private void addAttresultitem(Map<Long, Map<String, Object>> dataMap) {
        DynamicObject[] attTotalDetailDys;
        HRBaseServiceHelper wtbdAttitemHelper = new HRBaseServiceHelper("wtbd_attitem");
        DynamicObject[] vaDetailArr = wtbdAttitemHelper.query("id,creator,", new QFilter[]{new QFilter("creator", "in", dataMap.keySet()).and("datastatus", "=", (Object)"1").and("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
        List itemIds = Arrays.stream(vaDetailArr).mapToLong(dynamicObject -> dynamicObject.getLong("id")).boxed().collect(Collectors.toList());
        String kdString = ResManager.loadKDString((String)"\u8fdf\u5230", (String)"WTCExamineListServiceImpl_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        String kdString1 = ResManager.loadKDString((String)"\u591c\u73ed", (String)"WTCExamineListServiceImpl_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        String kdString2 = ResManager.loadKDString((String)"\u52a0\u73ed", (String)"WTCExamineListServiceImpl_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        HRBaseServiceHelper wtdtdAttrecorddetailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        DynamicObject[] vaDetailArr1 = wtdtdAttrecorddetailHelper.queryOriginalArray("id,attitemid,attmain,valuesecond,attmain.personid,attitemid.name,attitemid.id", new QFilter[]{new QFilter("attitemid", "in", itemIds).or(new QFilter("attitemid.name", "like", (Object)("%" + kdString + "%")).and("attmain.personid", "in", this.personWithUserIdMap.keySet())).or(new QFilter("attitemid.name", "like", (Object)("%" + kdString1 + "%")).and("attmain.personid", "in", this.personWithUserIdMap.keySet())).or(new QFilter("attitemid.name", "like", (Object)("%" + kdString2 + "%")).and("attmain.personid", "in", this.personWithUserIdMap.keySet()))});
        HRBaseServiceHelper attTotalDetailHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        for (DynamicObject attTotalDetailDy : attTotalDetailDys = attTotalDetailHelper.queryOriginalArray("id,attitemid,attmain,attitemid.unit,valuelong,attmain.personid,attitemid.name,attitemid.id", new QFilter[]{new QFilter("attitemid", "in", itemIds).or(new QFilter("attitemid.name", "like", (Object)("%" + kdString + "%")).and("attmain.personid", "in", this.personWithUserIdMap.keySet())).or(new QFilter("attitemid.name", "like", (Object)("%" + kdString1 + "%")).and("attmain.personid", "in", this.personWithUserIdMap.keySet())).or(new QFilter("attitemid.name", "like", (Object)("%" + kdString2 + "%")).and("attmain.personid", "in", this.personWithUserIdMap.keySet()))})) {
            long valueLong;
            String unit = attTotalDetailDy.getString("attitemid.unit");
            BigDecimal bigDecimal = WTCItemUnitEnum.changeValueToSecond((String)unit, (BigDecimal)new BigDecimal(valueLong = attTotalDetailDy.getLong("valuelong")));
            if (bigDecimal == null || new BigDecimal(0).compareTo(bigDecimal) >= 0) continue;
            attTotalDetailDy.set("valuelong", (Object)bigDecimal);
        }
        ArrayList<DynamicObject> personIdAttFileList = new ArrayList<DynamicObject>(10);
        personIdAttFileList.addAll(Arrays.asList(vaDetailArr1));
        personIdAttFileList.addAll(Arrays.asList(attTotalDetailDys));
        for (DynamicObject obj : personIdAttFileList) {
            Map<String, Object> info;
            Map<String, Object> info2;
            long valuesecond;
            String attItemName;
            Map<String, Object> info3;
            long personId = obj.getLong("attmain.personid");
            if (itemIds.contains(obj.getLong("attitemid.id")) && (info3 = dataMap.get(this.personWithUserIdMap.get(personId))) != null) {
                info3.put("attresultitem", 2);
            }
            if (StringUtils.isEmpty((Object)(attItemName = obj.getString("attitemid.name")))) continue;
            if (attItemName.contains(kdString) && (valuesecond = obj.getDataEntityType().getProperties().containsKey((Object)"valuesecond") ? obj.getLong("valuesecond") : obj.getLong("valuelong")) >= 1800L && (info2 = dataMap.get(this.personWithUserIdMap.get(personId))) != null) {
                info2.put("attlateness", 2);
            }
            if (attItemName.contains(kdString1) && (info = dataMap.get(this.personWithUserIdMap.get(personId))) != null) {
                info.put("attnightshifts", 2);
            }
            if (!attItemName.contains(kdString2) || (valuesecond = obj.getDataEntityType().getProperties().containsKey((Object)"valuesecond") ? obj.getLong("valuesecond") : obj.getLong("valuelong")) < 3600L || (info2 = dataMap.get(this.personWithUserIdMap.get(personId))) == null) continue;
            info2.put("attovertime", 2);
        }
    }

    private void callHRPIPersonByUserId(Map<Long, Map<String, Object>> dataMap, List<Long> personIdList, Map<Long, Long> personIdUserIdMap) {
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonService", (String)"queryPersonInfoByUserIds", (Object[])new Object[]{new ArrayList<Long>(dataMap.keySet())});
        if (!HRMapUtils.isEmpty((Map)resMap) && ((Boolean)resMap.get("success")).booleanValue()) {
            Map personMap = (Map)resMap.get("data");
            personMap.forEach((k, v) -> {
                personIdList.add((Long)v.get("person"));
                personIdUserIdMap.put((Long)v.get("person"), (Long)k);
            });
        }
    }
}

