/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.base;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelTypeEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelConfigEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String BIZ_MODEL_PANEL = "bizmodelpanelap";
    private static final String INHERIT_FLEX = "inheritflex";
    private static final String SUB_ENTITY_FLEX = "subentityflex";
    private static final String[] GROUP_FIELDS = new String[]{"bizapp", "bizunitname", "bizunit", "isaddmodel"};
    private static final String[] ENTITY_FIELDS = new String[]{"mainentity", "ismodmodel", "isaddfield"};
    private static final String[] MUST_INPUT_FIELDS = new String[]{"bizapp", "bizunitname", "mainentity"};
    private static final String[] BIZ_MODEL_FIELDS = new String[]{"bizapp", "bizunitname", "bizunit", "isaddmodel", "mainentity", "ismodmodel", "isaddfield"};
    private static final String CHOOSE_UNIT_CALLBACK = "chooseunitcallback";
    private static final List<String> BASEDATA_TYPE_LIST = ImmutableList.of((Object)"BaseFormModel", (Object)"BillFormModel");
    private IBizModelTypeEntityService bizModelTypeEntityService = (IBizModelTypeEntityService)ServiceFactory.getService(IBizModelTypeEntityService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit bizModelType = (BasedataEdit)this.getView().getControl("bizmodeltype");
        bizModelType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mainEntity = (BasedataEdit)this.getView().getControl("mainentity");
        mainEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit bizUnitName = (TextEdit)this.getView().getControl("bizunitname");
        bizUnitName.addClickListener((ClickListener)this);
    }

    public void afterLoadData(EventObject eventObject) {
        AppFunctionPacketElement functionPacket;
        IBillView billView = (IBillView)eventObject.getSource();
        DynamicObject bizApp = (DynamicObject)billView.getModel().getValue("bizapp");
        String bizUnitId = (String)billView.getModel().getValue("bizunit");
        if (bizApp != null && StringUtils.isNotEmpty((String)bizUnitId) && (functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizApp.getString("id"), (boolean)false)) != null) {
            billView.getModel().setValue("bizunitname", (Object)functionPacket.getName().getLocaleValue());
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.initVisible();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((String)"bizunitname", (String)control.getKey())) {
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
            if (bizApp == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u4e1a\u52a1\u9886\u57df\u3002", (String)"BizModelConfigEditPlugin_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                return;
            }
            this.chooseUnit(bizApp.getString("id"));
        }
    }

    private void chooseUnit(String appId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_selectunit");
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u529f\u80fd\u5206\u7ec4", (String)"BizModelConfigEditPlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        JSONObject map = new JSONObject();
        map.put("appid", (Object)appId);
        map.put("runtime", (Object)Boolean.FALSE);
        parameter.setCustomParams((Map)map);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CHOOSE_UNIT_CALLBACK);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map result = (Map)event.getReturnData();
        if (result != null && CHOOSE_UNIT_CALLBACK.equals(event.getActionId())) {
            String bizUnitId = (String)result.get("nodeid");
            String bizUnitName = (String)result.get("nodename");
            this.getModel().setValue("bizunitname", (Object)bizUnitName);
            if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{bizUnitId})) {
                this.getModel().setValue("bizunit", (Object)bizUnitId);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        IDataEntityProperty property = propertyChangedArgs.getProperty();
        if ("bizmodeltype".equals(property.getName())) {
            this.setVisibleByBizModelTypeChange();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject bizModel;
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        if ("bizmodeltype".equals(property.getName())) {
            DynamicObject bizModel2 = (DynamicObject)this.getModel().getValue("parent");
            if (HRObjectUtils.isEmpty((Object)bizModel2)) {
                return;
            }
            DynamicObject bizModelType = this.bizModelTypeEntityService.queryOne("id, number, name, level", bizModel2.getDynamicObject("bizmodeltype").get("id"));
            if (bizModelType != null) {
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("level", (Object)bizModelType.getString("level"));
                List filters = beforeF7SelectEvent.getCustomQFilters();
                int level = bizModelType.getInt("level");
                QFilter qFilter = new QFilter("level", ">=", (Object)level);
                filters.add(qFilter);
            }
        } else if (HRStringUtils.equals((String)property.getName(), (String)"mainentity") && (bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodeltype")).getLong("id") == 1686373805922075648L) {
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("modeltype", "in", BASEDATA_TYPE_LIST));
        }
    }

    private void setVisibleByBizModelTypeChange() {
        this.setPropertyValue((DynamicObject)this.getModel().getValue("bizmodeltype"));
        this.initVisible();
    }

    private void initVisible() {
        DynamicObject bizModelType = (DynamicObject)this.getModel().getValue("bizmodeltype");
        if (HRObjectUtils.isEmpty((Object)bizModelType) || "bizarea".equals(bizModelType.getString("number")) || "bizsubarea".equals(bizModelType.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZ_MODEL_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{INHERIT_FLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{SUB_ENTITY_FLEX});
        } else if ("bizunit".equals(bizModelType.getString("number"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BIZ_MODEL_PANEL});
            this.setVisible(Boolean.TRUE, GROUP_FIELDS);
            this.getView().setVisible(Boolean.TRUE, new String[]{INHERIT_FLEX});
            this.setVisible(Boolean.FALSE, ENTITY_FIELDS);
            this.getView().setVisible(Boolean.FALSE, new String[]{SUB_ENTITY_FLEX});
        } else if ("entity".equals(bizModelType.getString("number"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BIZ_MODEL_PANEL});
            this.setVisible(Boolean.FALSE, GROUP_FIELDS);
            this.getView().setVisible(Boolean.FALSE, new String[]{INHERIT_FLEX});
            this.setVisible(Boolean.TRUE, ENTITY_FIELDS);
            this.getView().setVisible(Boolean.TRUE, new String[]{SUB_ENTITY_FLEX});
        }
    }

    private void setPropertyValue(DynamicObject bizModelType) {
        if (HRObjectUtils.isEmpty((Object)bizModelType) || "bizarea".equals(bizModelType.getString("number")) || "bizsubarea".equals(bizModelType.getString("number"))) {
            this.clearValue(BIZ_MODEL_FIELDS);
            this.clearEntryValue("inheritentryentity");
            this.clearEntryValue("subentryentity");
        } else if ("bizunit".equals(bizModelType.getString("number"))) {
            this.clearValue(ENTITY_FIELDS);
            this.clearEntryValue("subentryentity");
        } else if ("entity".equals(bizModelType.getString("number"))) {
            this.clearValue(GROUP_FIELDS);
            this.clearEntryValue("inheritentryentity");
        }
    }

    private void setVisible(Boolean isVisible, String[] fields) {
        if (ObjectUtils.isEmpty((Object[])fields)) {
            return;
        }
        for (String field : fields) {
            if (!Arrays.asList(MUST_INPUT_FIELDS).contains(field)) continue;
            Control control = this.getView().getControl(field);
            if (control instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)control;
                basedataEdit.setMustInput(isVisible.booleanValue());
                continue;
            }
            if (!(control instanceof TextEdit)) continue;
            TextEdit textEdit = (TextEdit)control;
            textEdit.setMustInput(isVisible.booleanValue());
        }
        this.getView().setVisible(isVisible, fields);
    }

    private void clearEntryValue(String entryEntity) {
        IDataModel entryOperate = this.getModel();
        entryOperate.deleteEntryData(entryEntity);
    }

    private void clearValue(String[] fields) {
        if (ObjectUtils.isEmpty((Object[])fields)) {
            return;
        }
        for (String field : fields) {
            IDataEntityProperty property = this.getModel().getProperty(field);
            if (property instanceof BooleanProp) {
                BooleanProp booleanProp = (BooleanProp)property;
                this.getModel().setValue(field, booleanProp.getDefaultValue());
                continue;
            }
            this.getModel().setValue(field, null);
        }
    }
}

