/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.base;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.IBizModelRecordApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.common.util.HRDyObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelRecordDetailEditPlugin
extends HDTCDataBaseEdit {
    IBizModelRecordApplicationService bizModelRecordApplicationService = (IBizModelRecordApplicationService)ServiceFactory.createInstance(IBizModelRecordApplicationService.class);
    IBizModelRecordDomainService bizModelRecordDomainService = (IBizModelRecordDomainService)ServiceFactory.getService(IBizModelRecordDomainService.class);
    private Map<String, FormMetadata> formData = new HashMap<String, FormMetadata>(4);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("menulist")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operatepanel"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        if (HRStringUtils.equals((String)arg.getOperateKey(), (String)"rollbackdata")) {
            Long id = this.getModel().getDataEntity().getLong("id");
            if (this.bizModelRecordApplicationService.downloadRollbackStrByIds((List)Lists.newArrayList((Object[])new Object[]{id}), this.getView())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f", (String)"BizModelRecordListPlugin_0", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"BizModelRecordListPlugin_1", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.setValue(this.bizModelRecordDomainService.getBizModelRecordById(id));
    }

    private void setValue(DynamicObject bizModelRecord) {
        if (bizModelRecord == null) {
            return;
        }
        this.getModel().setValue("id", (Object)bizModelRecord.getLong("id"));
        this.getModel().setValue("bizmodelnumber", bizModelRecord.getDynamicObject("bizmodel").get("number"));
        this.getModel().setValue("bizmodelname", bizModelRecord.getDynamicObject("bizmodel").get("name"));
        if (HRStringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("viewdetail")))) {
            this.setEntry(bizModelRecord.getDynamicObjectCollection("entryentity"));
        } else {
            Long entryId = (Long)this.getView().getFormShowParameter().getCustomParam("entryentity");
            DynamicObjectCollection entryCollect = bizModelRecord.getDynamicObjectCollection("entryentity").stream().filter(it -> it.getLong("id") == entryId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
            this.setEntry(entryCollect);
        }
    }

    private void setEntry(DynamicObjectCollection entry) {
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return;
        }
        Map<String, List<DynamicObject>> entryMap = entry.stream().collect(Collectors.groupingBy(it -> it.getDynamicObject("ability").getString("name")));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("metaentity");
        model.deleteEntryData("dataentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("metanumber", new Object[0]);
        vs.addField("metaname", new Object[0]);
        vs.addField("metabizappid", new Object[0]);
        vs.addField("metaability", new Object[0]);
        TableValueSetter dataVs = new TableValueSetter(new String[0]);
        dataVs.addField("datanumber", new Object[0]);
        dataVs.addField("datatable", new Object[0]);
        dataVs.addField("dataid", new Object[0]);
        dataVs.addField("dataid_tag", new Object[0]);
        dataVs.addField("dataabilety", new Object[0]);
        for (Map.Entry<String, List<DynamicObject>> map : entryMap.entrySet()) {
            List<DynamicObject> value = map.getValue();
            ArrayList metaList = new ArrayList(value.size());
            ArrayList dataList = new ArrayList(value.size());
            value.forEach(it -> dataList.addAll(ToolResultBo.analysisJsonToData((String)HRDyObjectUtils.getBigText((DynamicObject)it, (String)"result"))));
            value.forEach(it -> metaList.addAll(ToolResultBo.analysisJsonToMeta((String)HRDyObjectUtils.getBigText((DynamicObject)it, (String)"result"))));
            metaList.forEach(it -> {
                FormMetadata formMetadata = this.getFormDataByNumber(it.getNumber());
                if (formMetadata != null) {
                    vs.addRow(new Object[]{it.getNumber(), formMetadata.getName().getLocaleValue(), formMetadata.getBizappNumber(), map.getKey()});
                }
            });
            dataList.forEach(it -> {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)it.getNumber());
                if (HRStringUtils.isNotEmpty((String)entityType.getAlias())) {
                    dataVs.addRow(new Object[]{it.getNumber(), entityType.getAlias(), StringUtils.join((Object[])it.getIds().toArray(), (String)","), StringUtils.join((Object[])it.getIds().toArray(), (String)","), map.getKey()});
                }
            });
        }
        model.batchCreateNewEntryRow("metaentity", vs);
        model.batchCreateNewEntryRow("dataentity", dataVs);
        model.endInit();
    }

    private FormMetadata getFormDataByNumber(String number) {
        FormMetadata formMetadata = this.formData.get(number);
        if (formMetadata == null) {
            try {
                formMetadata = MetadataUtils.getFormMetadataByNumber((String)number);
            }
            catch (Exception e) {
                return null;
            }
        }
        return formMetadata;
    }
}

