/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hdtc.hrdt.business.application.service.IWorkBenchServiceApplication;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.model.BizModelTreeBo;
import kd.hdtc.hrdt.business.application.service.extendplatform.client.IExtendPlatformClientServiceApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.OpenPageCommonUtils;

public class ExtendPlatformClientPlugin
extends AbstractHDTCFormPlugin {
    private IExtendPlatformClientServiceApplication extendPlatformClientServiceApplication = (IExtendPlatformClientServiceApplication)ServiceFactory.getService(IExtendPlatformClientServiceApplication.class);
    private IWorkBenchServiceApplication workBenchServiceApplication = (IWorkBenchServiceApplication)ServiceFactory.getService(IWorkBenchServiceApplication.class);
    private static final String CURRENT_INFO_JSON = "currentInfoJson";
    private static final String OPEN_ABILITY_IN_CURRENT_FORM = "openAbilityInCurrentForm";
    private static final String RIGHT_CONTENT_CODE = "flexpanelap1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.initAbilities(null);
        this.initAbilitiesBig(null);
        this.initDescData(null);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        JSONObject json = JSON.parseObject((String)args);
        if ("showPage".equals(eventName)) {
            String type = json.getString("type");
            if ("knowledge".equals(type)) {
                OpenPageCommonUtils.openLine((IFormView)this.getView(), (String)json.getString("knowledgelink"), null);
            } else if ("tool".equals(type)) {
                this.recordToolUseInfo(Long.parseLong(json.getString("id")));
                OpenPageCommonUtils.openToolPageLine((IFormView)this.getView(), (String)json.getString("toolpageaddr"), param -> {
                    if (param == null) {
                        return null;
                    }
                    JSONObject currentTreeJson = null;
                    String currentJsonStr = this.getPageCache().get(CURRENT_INFO_JSON);
                    if (StringUtils.isNotEmpty((String)currentJsonStr)) {
                        currentTreeJson = JSON.parseObject((String)currentJsonStr);
                    }
                    if (param instanceof FormShowParameter) {
                        ((FormShowParameter)param).setCustomParam("effectivestatus", (Object)"1");
                        if (currentTreeJson != null) {
                            ((FormShowParameter)param).setCustomParam("bizmodel.id", (Object)currentTreeJson.getString("id"));
                        }
                    } else if (param instanceof Map) {
                        ((Map)param).put("effectivestatus", "1");
                        if (currentTreeJson != null) {
                            ((Map)param).put("bizmodel.id", currentTreeJson.getString("id"));
                        }
                    }
                    return param;
                });
            }
        } else if ("showInfo".equals(eventName)) {
            this.showInfoByBizModelType(json);
            this.getPageCache().put(CURRENT_INFO_JSON, args);
        } else if ("showAbility".equals(eventName)) {
            this.showOpPage(json);
        }
        this.updateBizModelCache(json);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("refresh".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.initData();
        }
    }

    private void initData() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map treeData = this.extendPlatformClientServiceApplication.buildExtendPlatformTree();
        if (CollectionUtils.isNotEmpty((Map)treeData)) {
            result.put("random", new SecureRandom().nextInt(10000000));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String selectedNodeId = String.valueOf(formShowParameter.getCustomParams().get("selectedNodeId"));
            List tree = (List)treeData.get("tree");
            result.put("dataArr", tree);
            List allData = (List)treeData.get("data");
            this.putSelectNodeInfo(tree, allData, selectedNodeId, result);
        }
        customcontrol.setData(result);
        this.getView().updateView("customcontrolap");
    }

    private void initDescData(JSONObject json) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap_desc");
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        result.put("random", new SecureRandom().nextInt(10000000));
        ImmutableMap showData = new HashMap(4);
        if (json != null) {
            showData = ImmutableMap.builder().put((Object)"title", (Object)json.getString("name")).put((Object)"description", (Object)json.getString("description")).build();
        }
        result.put("showData", (Integer)showData);
        customcontrol.setData(result);
        this.getView().updateView("customcontrolap_desc");
    }

    private void initAbilities(JSONObject json) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("controlap_abilities");
        if (customcontrol == null) {
            return;
        }
        List abilities = new ArrayList(1);
        if (json != null) {
            abilities = this.extendPlatformClientServiceApplication.getAbilitiesByBizModel(json.getLong("id").longValue());
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(16);
        result.put("random", Integer.valueOf(new SecureRandom().nextInt(10000000)));
        result.put("abilities", (Serializable)((Object)abilities));
        customcontrol.setData(result);
        this.getView().updateView("controlap_abilities");
    }

    private void initAbilitiesBig(JSONObject json) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("controlap_abilities_big");
        if (customcontrol == null) {
            return;
        }
        List abilities = new ArrayList(1);
        if (json != null) {
            abilities = this.extendPlatformClientServiceApplication.getAbilitiesByBizModel(json.getLong("id").longValue());
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(16);
        result.put("random", Integer.valueOf(new SecureRandom().nextInt(10000000)));
        result.put("abilities", (Serializable)((Object)abilities));
        customcontrol.setData(result);
        this.getView().updateView("controlap_abilities_big");
    }

    private void updateBizModelCache(JSONObject json) {
        if (json != null) {
            String bizModelId = json.getString("id");
            this.getPageCache().put("bizmodel.id", bizModelId);
        }
    }

    private void showOpPage(JSONObject json) {
        IFormView view = this.getView();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, OPEN_ABILITY_IN_CURRENT_FORM);
        this.recordToolUseInfo(Long.parseLong(json.getString("id")));
        OpenPageCommonUtils.openPageInContainer((IFormView)this.getView(), (String)"op_ap", (String)json.getString("formtoolpageaddr"), (CloseCallBack)callBack, data -> {
            view.setVisible(Boolean.FALSE, new String[]{"desc_ap", "ability_ap", "ability_ap_big"});
            view.setVisible(Boolean.TRUE, new String[]{"op_ap"});
            view.updateView(RIGHT_CONTENT_CODE);
            return data;
        });
    }

    private void showInfoByBizModelType(JSONObject json) {
        String bizModelType = json.getString("bizModelType");
        if (StringUtils.equalsIgnoreCase((String)"entity", (String)bizModelType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"desc_ap", "ability_ap_big"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"op_ap", "ability_ap"});
            this.initAbilities(json);
            this.showDetail(json);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"op_ap", "ability_ap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"desc_ap", "ability_ap_big"});
            this.initDescData(json);
            this.initAbilitiesBig(json);
        }
        this.getView().updateView(RIGHT_CONTENT_CODE);
    }

    private void showDetail(JSONObject json) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("hrdt_bizmodel_entity");
        param.setPkId((Object)json.getLong("id"));
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("op_ap");
        this.getView().showForm((FormShowParameter)param);
    }

    private void putSelectNodeInfo(List<BizModelTreeBo> tree, List<BizModelTreeBo> allData, String selectedNodeId, Map<String, Object> result) {
        Map<String, BizModelTreeBo> allDataMap;
        BizModelTreeBo selectedNode = null;
        if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{selectedNodeId}) && !"null".equals(selectedNodeId) && CollectionUtils.isNotEmpty(allData) && (selectedNode = (allDataMap = allData.stream().collect(Collectors.toMap(BizModelTreeBo::getKey, v1 -> v1, (v1, v2) -> v2))).get(selectedNodeId)) == null) {
            Map<String, BizModelTreeBo> allDataNumberMap = allData.stream().collect(Collectors.toMap(BizModelTreeBo::getNumber, v1 -> v1, (v1, v2) -> v2));
            selectedNode = allDataNumberMap.get(selectedNodeId);
        }
        if (selectedNode == null) {
            selectedNode = tree.get(0);
        }
        result.put("selectedNode", selectedNode);
        this.putKeysByNode(selectedNode, result);
    }

    private void putKeysByNode(BizModelTreeBo node, Map<String, Object> result) {
        if (node != null) {
            ArrayList<String> defaultExpandedKeys = new ArrayList<String>(4);
            ArrayList<String> selectedKeys = new ArrayList<String>(4);
            String longNumber = node.getKey();
            selectedKeys.add(longNumber);
            result.put("selectedKeys", selectedKeys);
            result.put("scrollToKey", longNumber);
            String[] numbers = longNumber.split("\\.");
            StringBuilder currentNumber = new StringBuilder();
            for (String number : numbers) {
                currentNumber.append(number);
                defaultExpandedKeys.add(currentNumber.toString());
                currentNumber.append('.');
            }
            result.put("defaultExpandedKeys", defaultExpandedKeys);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (OPEN_ABILITY_IN_CURRENT_FORM.equals(event.getActionId())) {
            String jsonStr = this.getPageCache().get(CURRENT_INFO_JSON);
            JSONObject json = JSON.parseObject((String)jsonStr);
            Object returnData = event.getReturnData();
            if (returnData instanceof Map) {
                Map returnDataMap = (Map)returnData;
                String selectedNodeId = String.valueOf(returnDataMap.get("selectedNodeId"));
                this.getView().getFormShowParameter().getCustomParams().put("selectedNodeId", StringUtils.isNotEmpty((String)selectedNodeId) ? selectedNodeId : json.getString("key"));
            } else {
                this.getView().getFormShowParameter().getCustomParams().put("selectedNodeId", json.getString("key"));
            }
            this.initData();
        }
    }

    private void recordToolUseInfo(Long toolId) {
        SessionManager currentSessionManager = SessionManager.getCurrent();
        String currentWorkBenchRoleId = currentSessionManager.get("workbenchrole");
        if (StringUtils.isNotEmpty((String)currentWorkBenchRoleId)) {
            this.workBenchServiceApplication.saveOrUpdateCommonTool(Long.valueOf(RequestContext.get().getCurrUserId()), Long.valueOf(Long.parseLong(currentWorkBenchRoleId)), toolId);
        }
    }
}

