/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.tools.biztools;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.common.IToolsApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.EntityInfoUtils;
import kd.hdtc.hrdt.common.enums.HRPITplEnum;

public class CadreFileToolEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private IToolsApplicationService toolsApplicationService = (IToolsApplicationService)ServiceFactory.getService(IToolsApplicationService.class);

    public void registerListener(EventObject e) {
        BasedataEdit bizModelEdit;
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("cadrefileviews");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizModelEdit = (BasedataEdit)this.getView().getControl("bizmodel")) != null) {
            bizModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
        if (StringUtils.isNotEmpty((String)bizModelId)) {
            this.getModel().setValue("bizmodel", (Object)Long.parseLong(bizModelId));
        }
    }

    public void beforeBindData(EventObject eventObject) {
        String name;
        super.beforeBindData(eventObject);
        Boolean isCopy = (Boolean)((BillView)eventObject.getSource()).getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            this.getModel().setValue("effectivestatus", (Object)"1");
        }
        if (StringUtils.isNotEmpty((String)(name = this.getView().getModel().getDataEntity().getString("name")))) {
            String tittle = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0\u5e72\u90e8\u9644\u8868-%s", (String)"CadreFileToolEditPlugin_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), name);
            this.getView().getFormShowParameter().setCaption(tittle);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LocaleString caption = this.getView().getFormShowParameter().getFormConfig().getCaption();
        this.getView().setFormTitle(caption);
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        if (bizModel != null) {
            this.setShowView(bizModel);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "bizmodel": {
                this.onBizModelChange(propertyChangedArgs);
                break;
            }
            case "filetype": {
                this.onFileTypeChange();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject fileType = this.getModel().getDataEntity().getDynamicObject("filetype");
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (fieldName.equals("cadrefileviews")) {
            if (fileType != null) {
                QFilter erFileTypeIdFilter = new QFilter("erfiletype.id", "=", (Object)fileType.getLong("id"));
                beforeF7SelectEvent.addCustomQFilter(erFileTypeIdFilter);
            }
            boolean employee = "1".equals(this.getModel().getDataEntity().getString("biztype"));
            QFilter employeeFilter = new QFilter("employee", "=", (Object)employee);
            beforeF7SelectEvent.addCustomQFilter(employeeFilter);
        } else if ("bizmodel".equals(fieldName)) {
            beforeF7SelectEvent.addCustomQFilter(this.toolsApplicationService.buildBizModelQFilter(Long.valueOf(1813974162247768064L)));
        }
    }

    private void onFileTypeChange() {
        this.getModel().setValue("cadrefileviews", null);
    }

    private void onBizModelChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject bizModel = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        this.setShowView(bizModel);
    }

    private void setShowView(DynamicObject bizModel) {
        if (bizModel != null) {
            String entityNumber = bizModel.getString("mainentity.number");
            if (!MetadataUtils.checkNumber((String)entityNumber)) {
                String info = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b:%s\u5173\u8054\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4", (String)"CadreFileToolEditPlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), bizModel.getString("name"));
                this.getView().showErrorNotification(info);
                this.getModel().setValue("bizmodel", null);
                return;
            }
            String tplType = EntityInfoUtils.getHrpiEntityInhRelationType((String)entityNumber);
            String bizType = this.getModel().getDataEntity().getString("biztype");
            if (bizType.equals("0")) {
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    this.getModel().setValue("pcview", (Object)"2");
                } else {
                    this.getModel().setValue("pcview", (Object)"1");
                }
            }
        }
    }
}

