/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.tools.biztools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.common.IToolsApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.EntityInfoUtils;
import kd.hdtc.hrdt.common.enums.HRPITplEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class MulPersonFileToolEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private IToolsApplicationService toolsApplicationService = (IToolsApplicationService)ServiceFactory.getService(IToolsApplicationService.class);

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "bizmodel": {
                this.onBizModelChange(propertyChangedArgs);
                break;
            }
            case "biztype": {
                this.onBizTypeChange(propertyChangedArgs);
                break;
            }
            case "filetype": {
                this.onFileTypeChange();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
        if (StringUtils.isNotEmpty((String)bizModelId)) {
            this.getModel().setValue("bizmodel", (Object)Long.parseLong(bizModelId));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LocaleString caption = this.getView().getFormShowParameter().getFormConfig().getCaption();
        this.getView().setFormTitle(caption);
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        this.setShowView(bizModel);
    }

    private void onBizTypeChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        if (bizModel == null) {
            String info = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u5b9e\u4f53", (String)"MulPersonFileToolEditPlugin_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showErrorNotification(info);
            this.getModel().setValue("biztype", null);
            return;
        }
        String bizType = (String)propertyChangedArgs.getChangeSet()[0].getNewValue();
        if ("0".equals(bizType)) {
            this.getModel().setValue("region", (Object)"3");
        } else {
            this.getModel().setValue("region", (Object)"1");
        }
        this.setCurrentRowShowView(bizModel);
    }

    private void setCurrentRowShowView(DynamicObject bizModel) {
        if (bizModel != null) {
            String entityNumber = bizModel.getString("mainentity.number");
            if (!MetadataUtils.checkNumber((String)entityNumber)) {
                String info = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b:%s\u5173\u8054\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4", (String)"MulPersonFileToolEditPlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), bizModel.getString("name"));
                this.getView().showErrorNotification(info);
                this.getModel().setValue("bizmodel", null);
                return;
            }
            String tplType = EntityInfoUtils.getHrpiEntityInhRelationType((String)entityNumber);
            String bizType = String.valueOf(this.getModel().getValue("biztype"));
            if ("0".equals(bizType)) {
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    this.getModel().setValue("pcview", (Object)"2");
                } else {
                    this.getModel().setValue("pcview", (Object)"1");
                }
                this.getModel().setValue("employeemobileview", null);
                this.getModel().setValue("employeepcview", null);
                this.getModel().setValue("pcfileviews", null);
            } else if ("1".equals(bizType)) {
                ComboEdit employeePcFieldEdit = (ComboEdit)this.getControl("employeepcview");
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    this.setComboItems(employeePcFieldEdit, "2");
                    this.getModel().setValue("employeepcview", (Object)"2");
                } else {
                    this.setComboItems(employeePcFieldEdit, "1");
                    this.getModel().setValue("employeepcview", (Object)"1");
                }
                this.getModel().setValue("pcview", null);
                this.getModel().setValue("personfileviews", null);
                ComboEdit employeeMobileFieldEdit = (ComboEdit)this.getControl("employeemobileview");
                List<ComboItem> comboItemTwoList = this.getItems((List<String>)ImmutableList.of((Object)"2"));
                List<ComboItem> comboItemOneList = this.getItems((List<String>)ImmutableList.of((Object)"1"));
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    if (employeeMobileFieldEdit != null && CollectionUtils.isNotEmpty(comboItemTwoList)) {
                        this.getModel().setValue("employeemobileview", (Object)comboItemTwoList.get(0).getValue());
                    }
                } else if (employeeMobileFieldEdit != null && CollectionUtils.isNotEmpty(comboItemOneList)) {
                    this.getModel().setValue("employeemobileview", (Object)comboItemOneList.get(0).getValue());
                }
            }
        }
        this.getView().updateView("personfileentry");
    }

    private void setComboItems(ComboEdit employeePcFieldEdit, String bizType) {
        if (employeePcFieldEdit != null) {
            employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList(bizType)));
        }
    }

    private void onFileTypeChange() {
        this.getModel().setValue("personfileviews", null);
        this.getModel().setValue("pcfileviews", null);
    }

    private void onBizModelChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject bizModel = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        this.setShowView(bizModel);
    }

    private void setShowView(DynamicObject bizModel) {
        if (bizModel == null) {
            return;
        }
        String entityNumber = bizModel.getString("mainentity.number");
        if (!MetadataUtils.checkNumber((String)entityNumber)) {
            String info = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b:%s\u5173\u8054\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4", (String)"MulPersonFileToolEditPlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), bizModel.getString("name"));
            this.getView().showErrorNotification(info);
            this.getModel().setValue("bizmodel", null);
            return;
        }
        String tplType = EntityInfoUtils.getHrpiEntityInhRelationType((String)entityNumber);
        DynamicObjectCollection dynamicObjectList = this.getModel().getDataEntity().getDynamicObjectCollection("personfileentry");
        for (DynamicObject object : dynamicObjectList) {
            String bizType = object.getString("biztype");
            if ("0".equals(bizType)) {
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    object.set("pcview", (Object)"2");
                } else {
                    object.set("pcview", (Object)"1");
                }
                object.set("employeemobileview", null);
                object.set("employeepcview", null);
                object.set("pcfileviews", null);
                continue;
            }
            if (!"1".equals(bizType)) continue;
            ComboEdit employeePcFieldEdit = (ComboEdit)this.getControl("employeepcview");
            if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                this.setComboItems(employeePcFieldEdit, "2");
                object.set("employeepcview", (Object)"2");
            } else {
                this.setComboItems(employeePcFieldEdit, "1");
                object.set("employeepcview", (Object)"1");
            }
            object.set("pcview", null);
            object.set("personfileviews", null);
            ComboEdit employeeMobileFieldEdit = (ComboEdit)this.getControl("employeemobileview");
            List<ComboItem> comboItemTwoList = this.getItems((List<String>)ImmutableList.of((Object)"2"));
            List<ComboItem> comboItemOneList = this.getItems((List<String>)ImmutableList.of((Object)"1"));
            if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                if (employeeMobileFieldEdit == null || !CollectionUtils.isNotEmpty(comboItemTwoList)) continue;
                object.set("employeemobileview", (Object)comboItemTwoList.get(0).getValue());
                continue;
            }
            if (employeeMobileFieldEdit == null || !CollectionUtils.isNotEmpty(comboItemOneList)) continue;
            object.set("employeemobileview", (Object)comboItemOneList.get(0).getValue());
        }
        this.getView().updateView("personfileentry");
    }

    private List<ComboItem> getItems(List<String> valueList) {
        ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)valueList.size());
        valueList.forEach(value -> {
            LocaleString caption;
            ComboItem comboItem = new ComboItem();
            switch (value) {
                case "1": {
                    caption = new LocaleString(ResManager.loadKDString((String)"\u5168\u9875\u9762", (String)"PersonFileToolEditPlugin_3", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    caption = new LocaleString(ResManager.loadKDString((String)"\u5361\u7247", (String)"PersonFileToolEditPlugin_4", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    value = "0";
                    caption = new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5c55\u793a", (String)"PersonFileToolEditPlugin_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                }
            }
            comboItem.setValue(value);
            comboItem.setCaption(caption);
            comboItemList.add(comboItem);
        });
        return comboItemList;
    }

    public void beforeBindData(EventObject eventObject) {
        String name;
        super.beforeBindData(eventObject);
        Boolean isCopy = (Boolean)((BillView)eventObject.getSource()).getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            this.getModel().setValue("effectivestatus", (Object)"1");
        }
        if (StringUtils.isNotEmpty((String)(name = this.getView().getModel().getDataEntity().getString("name")))) {
            String tittle = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65b0\u589e\u4eba\u5458\u6863\u6848\u4fe1\u606f\uff08\u6279\u91cf\uff09-%s", (String)"MulPersonFileToolEditPlugin_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), name);
            this.getView().getFormShowParameter().setCaption(tittle);
        }
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        ComboEdit employeePcFieldEdit = (ComboEdit)this.getControl("employeepcview");
        ComboEdit employeeMobileFieldEdit = (ComboEdit)this.getControl("employeemobileview");
        DynamicObjectCollection dynamicObjectList = this.getModel().getDataEntity().getDynamicObjectCollection("personfileentry");
        block8: for (DynamicObject dynamicObject : dynamicObjectList) {
            String tplType;
            String entityNumber;
            String bizType = dynamicObject.getString("biztype");
            if (employeeMobileFieldEdit == null || employeePcFieldEdit == null || bizModel == null || !bizType.equals("1") || HRStringUtils.isEmpty((String)(entityNumber = bizModel.getString("mainentity.number")))) continue;
            switch (tplType = EntityInfoUtils.getHrpiEntityInhRelationType((String)entityNumber)) {
                case "6": {
                    employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("1")));
                    continue block8;
                }
                case "4": {
                    employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("1")));
                }
            }
            employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("1")));
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit bizModelEdit;
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("personfileviews");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit pcFieldEdit = (BasedataEdit)this.getView().getControl("pcfileviews");
        if (fieldEdit != null) {
            pcFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizModelEdit = (BasedataEdit)this.getView().getControl("bizmodel")) != null) {
            bizModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (fieldName.equals("personfileviews") || fieldName.equals("pcfileviews")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("personfileentry");
            DynamicObject object = this.getModel().getEntryRowEntity("personfileentry", entryCurrentRowIndex);
            DynamicObject fileType = object.getDynamicObject("filetype");
            if (fileType != null) {
                QFilter erFileTypeIdFilter = new QFilter("erfiletype.id", "=", (Object)fileType.getLong("id"));
                beforeF7SelectEvent.addCustomQFilter(erFileTypeIdFilter);
            }
            boolean employee = "1".equals(object.getString("biztype"));
            QFilter employeeFilter = new QFilter("employee", "=", (Object)employee);
            beforeF7SelectEvent.addCustomQFilter(employeeFilter);
        } else if ("bizmodel".equals(fieldName)) {
            beforeF7SelectEvent.addCustomQFilter(this.toolsApplicationService.buildBizModelQFilter(Long.valueOf(1827609938260771840L)));
        }
    }
}

