/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.tools.biztools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.common.IToolsApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.EntityInfoUtils;
import kd.hdtc.hrdt.common.enums.HRPITplEnum;

public class PersonFileToolEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(PersonFileToolEditPlugin.class);
    private IToolsApplicationService toolsApplicationService = (IToolsApplicationService)ServiceFactory.getService(IToolsApplicationService.class);

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "bizmodel": {
                this.onBizModelChange(propertyChangedArgs);
                break;
            }
            case "biztype": {
                this.onBizTypeChange(propertyChangedArgs);
                break;
            }
            case "filetype": {
                this.onFileTypeChange(propertyChangedArgs);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
        if (StringUtils.isNotEmpty((String)bizModelId)) {
            this.getModel().setValue("bizmodel", (Object)Long.parseLong(bizModelId));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LocaleString caption = this.getView().getFormShowParameter().getFormConfig().getCaption();
        this.getView().setFormTitle(caption);
        this.changeMustInput();
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        if (bizModel != null) {
            this.setShowView(bizModel);
        }
    }

    private void onBizTypeChange(PropertyChangedArgs propertyChangedArgs) {
        String bizType = (String)propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (StringUtils.isNotEmpty((String)bizType)) {
            this.getModel().setValue("region", (Object)"1");
        }
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        this.setShowView(bizModel);
    }

    private void onFileTypeChange(PropertyChangedArgs propertyChangedArgs) {
        this.getModel().setValue("personfileviews", null);
        this.getModel().setValue("pcfileviews", null);
    }

    private void onBizModelChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject bizModel = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        this.setShowView(bizModel);
    }

    private void setShowView(DynamicObject bizModel) {
        if (bizModel != null) {
            String entityNumber = bizModel.getString("mainentity.number");
            if (!MetadataUtils.checkNumber((String)entityNumber)) {
                String info = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b:%s\u5173\u8054\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4", (String)"PersonFileToolEditPlugin_5", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), bizModel.getString("name"));
                this.getView().showErrorNotification(info);
                this.getModel().setValue("bizmodel", null);
                return;
            }
            String tplType = EntityInfoUtils.getHrpiEntityInhRelationType((String)entityNumber);
            String bizType = this.getModel().getDataEntity().getString("biztype");
            if (bizType.equals("0")) {
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    this.getModel().setValue("pcview", (Object)"2");
                } else {
                    this.getModel().setValue("pcview", (Object)"1");
                }
            } else {
                ComboEdit employeePcFieldEdit = (ComboEdit)this.getControl("employeepcview");
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    if (employeePcFieldEdit != null) {
                        employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("2")));
                    }
                    this.getModel().setValue("employeepcview", (Object)"2");
                } else {
                    if (employeePcFieldEdit != null) {
                        employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("1")));
                    }
                    this.getModel().setValue("employeepcview", (Object)"1");
                }
                ComboEdit employeeMobileFieldEdit = (ComboEdit)this.getControl("employeemobileview");
                if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                    if (employeeMobileFieldEdit != null) {
                        employeeMobileFieldEdit.setComboItems(this.getItems((List<String>)ImmutableList.of((Object)"2")));
                    }
                } else if (employeeMobileFieldEdit != null) {
                    employeeMobileFieldEdit.setComboItems(this.getItems((List<String>)ImmutableList.of((Object)"1")));
                }
            }
        }
        this.changeMustInput();
    }

    private void changeMustInput() {
        String bizType = this.getModel().getDataEntity().getString("biztype");
        if (bizType.equals("0")) {
            ((ComboEdit)this.getControl("pcview")).setMustInput(true);
            ((ComboEdit)this.getControl("employeemobileview")).setMustInput(false);
            ((ComboEdit)this.getControl("employeepcview")).setMustInput(false);
        } else {
            ((ComboEdit)this.getControl("pcview")).setMustInput(false);
            ((ComboEdit)this.getControl("employeemobileview")).setMustInput(true);
            ((ComboEdit)this.getControl("employeepcview")).setMustInput(true);
        }
    }

    private List<ComboItem> getItems(List<String> values) {
        ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)values.size());
        values.forEach(dy -> {
            ComboItem comboItem = new ComboItem();
            String value = "0";
            LocaleString caption = new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5c55\u793a", (String)"PersonFileToolEditPlugin_2", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
            switch (dy) {
                case "1": {
                    caption = new LocaleString(ResManager.loadKDString((String)"\u5168\u9875\u9762", (String)"PersonFileToolEditPlugin_3", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                    value = "1";
                    break;
                }
                case "2": {
                    caption = new LocaleString(ResManager.loadKDString((String)"\u5361\u7247", (String)"PersonFileToolEditPlugin_4", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                    value = "2";
                    break;
                }
            }
            comboItem.setValue(value);
            comboItem.setCaption(caption);
            comboItemList.add(comboItem);
        });
        return comboItemList;
    }

    public void beforeBindData(EventObject eventObject) {
        String name;
        super.beforeBindData(eventObject);
        Boolean isCopy = (Boolean)((BillView)eventObject.getSource()).getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            this.getModel().setValue("effectivestatus", (Object)"1");
        }
        if (StringUtils.isNotEmpty((String)(name = this.getView().getModel().getDataEntity().getString("name")))) {
            String tittle = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u6dfb\u52a0\u9644\u8868-%s", (String)"PersonFileToolEditPlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), name);
            this.getView().getFormShowParameter().setCaption(tittle);
        }
        DynamicObject bizModel = this.getModel().getDataEntity().getDynamicObject("bizmodel");
        ComboEdit employeePcFieldEdit = (ComboEdit)this.getControl("employeepcview");
        ComboEdit employeeMobileFieldEdit = (ComboEdit)this.getControl("employeemobileview");
        String bizType = this.getModel().getDataEntity().getString("biztype");
        if (employeeMobileFieldEdit != null && employeePcFieldEdit != null && bizModel != null && bizType.equals("1")) {
            String entityNumber = bizModel.getString("mainentity.number");
            String tplType = EntityInfoUtils.getHrpiEntityInhRelationType((String)entityNumber);
            if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
                employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("2")));
            } else {
                employeePcFieldEdit.setComboItems(this.getItems(Collections.singletonList("1")));
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit bizModelEdit;
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("personfileviews");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit pcFieldEdit = (BasedataEdit)this.getView().getControl("pcfileviews");
        if (fieldEdit != null) {
            pcFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizModelEdit = (BasedataEdit)this.getView().getControl("bizmodel")) != null) {
            bizModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject fileType = this.getModel().getDataEntity().getDynamicObject("filetype");
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (fieldName.equals("personfileviews") || fieldName.equals("pcfileviews")) {
            if (fileType != null) {
                QFilter erFileTypeIdFilter = new QFilter("erfiletype.id", "=", (Object)fileType.getLong("id"));
                beforeF7SelectEvent.addCustomQFilter(erFileTypeIdFilter);
            }
            boolean employee = "1".equals(this.getModel().getDataEntity().getString("biztype"));
            QFilter employeeFilter = new QFilter("employee", "=", (Object)employee);
            beforeF7SelectEvent.addCustomQFilter(employeeFilter);
        } else if ("bizmodel".equals(fieldName)) {
            beforeF7SelectEvent.addCustomQFilter(this.toolsApplicationService.buildBizModelQFilter(Long.valueOf(1692182687508395008L)));
        }
    }
}

