/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.tools.biztools;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.IBizModelApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.BizModelConfigFieldBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.BizModelMainEntityBo;

public class SyncSearchEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private IBizModelApplicationService bizModelApplicationService = (IBizModelApplicationService)ServiceFactory.getService(IBizModelApplicationService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("bizmodel");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
        if (StringUtils.isNotEmpty((String)bizModelId)) {
            this.getModel().setValue("bizmodel", (Object)Long.parseLong(bizModelId));
        }
    }

    public void afterBindData(EventObject e) {
        Long bizModelId = this.getModel().getDataEntity().getLong("bizmodel.id");
        BizModelMainEntityBo mainEntityInfo = this.bizModelApplicationService.getMainEntityInfoByBizModelId(bizModelId.longValue(), true);
        this.showBizModelDetail(mainEntityInfo);
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String selectCoin = beforeF7SelectEvent.getProperty().getName();
        if ("bizmodel".equals(selectCoin)) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "bizmodel": {
                this.onBizModelChange(propertyChangedArgs);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result.isSuccess()) {
            FormShowParameter show = new FormShowParameter();
            show.getOpenStyle().setShowType(ShowType.Modal);
            show.setFormId("hrdt_sysresult");
            show.setCustomParam("scence", this.getModel().getDataEntity().get("basedatafield.id"));
            this.getView().showForm(show);
        }
    }

    private void onBizModelChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject bizModel = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (bizModel != null) {
            String entityNumber = bizModel.getString("mainentity.number");
            if (!MetadataUtils.checkNumber((String)entityNumber)) {
                String info = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b:%s\u5173\u8054\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4", (String)"PersonFileToolEditPlugin_5", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]), bizModel.getString("name"));
                this.getModel().setValue("bizmodel", null);
                this.getView().showErrorNotification(info);
            }
            BizModelMainEntityBo mainEntityInfo = this.bizModelApplicationService.getMainEntityInfoByBizModelId(bizModel.getLong("id"), true);
            this.showBizModelDetail(mainEntityInfo);
        }
    }

    private void showBizModelDetail(BizModelMainEntityBo mainEntityInfo) {
        if (mainEntityInfo == null) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List mainEntityFields = mainEntityInfo.getMainEntityFields();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("fieldtype", new Object[0]);
        tableValueSetter.addField("fieldcode", new Object[0]);
        tableValueSetter.addField("fieldname", new Object[0]);
        tableValueSetter.addField("fieldconfig", new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)mainEntityFields)) {
            for (int index = mainEntityFields.size() - 1; index >= 0; --index) {
                BizModelConfigFieldBo mainEntityField = (BizModelConfigFieldBo)mainEntityFields.get(index);
                if (mainEntityField.isInherit()) continue;
                String config = "";
                IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)mainEntityField.getFieldType());
                if (metaDataFieldParser != null) {
                    config = metaDataFieldParser.parseAlias(mainEntityField.getFieldRuleContent());
                }
                tableValueSetter.addRow(new Object[]{mainEntityField.getFieldType(), mainEntityField.getNumber(), mainEntityField.getName(), config});
            }
        }
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

