/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.tools.commontools;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools.IBizModelToolDomainService;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class BatchBizModeToolEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String MAIN_ENTITY_OBJ_ID = "dentityid";
    private static final String CUS_SAVE = "cus_save";
    private IBizModelDomainService bizModelDomainService = (IBizModelDomainService)ServiceFactory.getService(IBizModelDomainService.class);
    private IBizModelToolDomainService bizModelToolDomainService = (IBizModelToolDomainService)ServiceFactory.getService(IBizModelToolDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("mainentity");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
        if (StringUtils.isNotEmpty((String)bizModelId)) {
            this.getModel().setValue("bizmodel", (Object)Long.parseLong(bizModelId));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"mainentity")) {
            DynamicObject bizmodel = (DynamicObject)this.getModel().getValue("bizmodel");
            DynamicObject bizModelDyn = this.bizModelDomainService.queryById(bizmodel.getLong("id"));
            DynamicObjectCollection inheritEntryEntity = bizModelDyn.getDynamicObjectCollection("inheritentryentity");
            List dEntityIdList = inheritEntryEntity.stream().map(entry -> ((DynamicObject)entry.get(1)).getString(MAIN_ENTITY_OBJ_ID)).collect(Collectors.toList());
            DynamicObject[] formMetaDys = this.bizModelToolDomainService.getFormMetaByEntityIdList(dEntityIdList);
            Set entityNumberSet = Arrays.stream(formMetaDys).map(dyc -> dyc.getString("number")).collect(Collectors.toSet());
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", entityNumberSet));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"mainentity")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            if (ObjectUtils.isEmpty((Object)newValue)) {
                this.getModel().setValue("enumber", null, rowIndex);
                this.getModel().setValue("ename", null, rowIndex);
            } else {
                this.getModel().setValue("enumber", (Object)((DynamicObject)newValue).getString("number"), rowIndex);
                this.getModel().setValue("ename", (Object)((DynamicObject)newValue).getString("name"), rowIndex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)CUS_SAVE) && args.getOperationResult().isSuccess()) {
            if (this.bizModelToolDomainService.batchSaveBizModeConfig(this.getModel().getDataEntity())) {
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().showSuccessNotification(BizModeMsgEnum.SAVE_SUCCESS_MSG.get());
                }
                this.getModel().setDataChanged(false);
                String number = this.getModel().getDataEntity().getString("bizmodel.number");
                ImmutableMap returnData = ImmutableMap.of((Object)"selectedNodeId", (Object)number);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(BizModeMsgEnum.SAVE_FAIL_MSG.get());
            }
        }
    }
}

