/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.extendplatform.form.tools.commontools;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.IBizModelApplicationService;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.common.IToolsApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrdt.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.common.utils.platform.ISVServiceUtils;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.BizModelConfigFieldBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.BizModelMainEntityBo;
import kd.hr.hbp.common.util.HRObjectUtils;

public class BizModelToolEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String SELECT_ITEMS = "selectitmes";
    private static final String ALIAS = "alias";
    private static final String INHERIT_ENTRY_ENTITY = "inheritentryentity";
    private static final String ISV_PRE = "ISVPRE";
    private IMetadataDomainService metadataDomainService = (IMetadataDomainService)ServiceFactory.getService(IMetadataDomainService.class);
    private IToolsApplicationService toolsApplicationService = (IToolsApplicationService)ServiceFactory.getService(IToolsApplicationService.class);
    private IBizModelApplicationService bizModelApplicationService = (IBizModelApplicationService)ServiceFactory.getService(IBizModelApplicationService.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        BizModelToolEditPlugin.setCaption(e.getFormShowParameter());
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getView().getControl("fieldextattrname");
        textEdit.addClickListener((ClickListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("bizmodel");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String showType = (String)formShowParameter.getCustomParam("sourcetype");
        if ("copy".equals(showType)) {
            String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            BizModelMainEntityBo mainEntityInfo = this.bizModelApplicationService.getMainEntityInfoByBizModelId(Long.parseLong(bizModelId), false);
            this.copyBizModel(model, mainEntityInfo);
        } else {
            String bizModelId = (String)formShowParameter.getCustomParam("bizmodel.id");
            if (StringUtils.isNotEmpty((String)bizModelId)) {
                this.getModel().setValue("bizmodel", (Object)Long.parseLong(bizModelId));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String selectCoin = beforeF7SelectEvent.getProperty().getName();
        if ("bizmodel".equals(selectCoin)) {
            beforeF7SelectEvent.addCustomQFilter(this.toolsApplicationService.buildBizModelQFilter(Long.valueOf(1692173864764765184L)));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handleEntityField();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String effectStatus = (String)this.getModel().getValue("effectivestatus");
        if (StringUtils.equals((String)effectStatus, (String)"2")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
        this.setInheritTPLComboItems();
        this.setInheritTPLField();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyKey = propertyChangedArgs.getProperty().getName();
        if ("fieldtype".equals(propertyKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            String fieldType = entryRowEntity.getString("fieldtype");
            if (StringUtils.isEmpty((String)fieldType)) {
                return;
            }
            this.setExtFieldEnable(fieldType, entryCurrentRowIndex, true);
        } else if ("bizmodel".equals(propertyKey)) {
            this.deleteComboItem();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject bizModel = dataEntity.getDynamicObject("bizmodel");
            if (HRObjectUtils.isEmpty((Object)bizModel)) {
                return;
            }
            this.setInheritTPLComboItems();
        } else if ("inherittpl".equals(propertyKey)) {
            this.getModel().deleteEntryData(INHERIT_ENTRY_ENTITY);
            this.setInheritTPLField();
        } else if ("fieldcode".equals(propertyKey)) {
            String fieldCode = (String)this.getModel().getValue("fieldcode");
            String currentISV = this.getCurrentISV();
            if ("kingdee".equals(currentISV)) {
                if (StringUtils.isNotEmpty((String)fieldCode)) {
                    this.getModel().setValue("fieldcode", (Object)fieldCode.toLowerCase());
                }
                return;
            }
            if (StringUtils.isNotEmpty((String)fieldCode) && !fieldCode.startsWith(currentISV)) {
                StringBuilder sb = new StringBuilder();
                StringBuilder append = sb.append(currentISV).append('_').append(fieldCode.toLowerCase());
                this.getModel().setValue("fieldcode", (Object)append.toString());
            }
        } else if ("number".equals(propertyKey)) {
            String number = (String)this.getModel().getValue("number");
            this.getModel().setValue("number", (Object)number.toLowerCase());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((String)"fieldextattrname", (String)control.getKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
            String item = entryRowEntity.getString("fieldconfig");
            String fieldType = entryRowEntity.getString("fieldtype");
            IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
            if (metaDataFieldParser != null) {
                parameter.setFormId(metaDataFieldParser.getMetaDataNumber());
                if (StringUtils.isNotEmpty((String)item)) {
                    parameter.setCustomParam("value", metaDataFieldParser.parseItems(item));
                }
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_ITEMS));
                this.getView().showForm(parameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        if ("saveandeffect".equals(eventArgs.getOperateKey())) {
            OperationResult operationResult = eventArgs.getOperationResult();
            if (operationResult.isSuccess() && StringUtils.isNotEmpty((String)operationResult.getMessage())) {
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().showTipNotification(operationResult.getMessage());
                }
                operationResult.setSuccess(false);
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
            if (operationResult.isSuccess()) {
                String number = this.getModel().getDataEntity().getString("number");
                ImmutableMap returnData = ImmutableMap.of((Object)"selectedNodeId", (Object)number);
                this.getView().returnDataToParent((Object)returnData);
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        if (SELECT_ITEMS.equals(closedCallBackEvent.getActionId()) && CollectionUtils.isNotEmpty((Map)(returnData = (Map)closedCallBackEvent.getReturnData()))) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("fieldextattrname", returnData.get(ALIAS), entryCurrentRowIndex);
            this.getModel().setValue("fieldconfig", returnData.get("value"), entryCurrentRowIndex);
        }
    }

    private void handleEntityField() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!ObjectUtils.isEmpty((Object)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryEntity.get(i);
                String item = entity.getString("fieldconfig");
                this.setFieldItemName(entity, item);
                this.setExtFieldEnable(entity.getString("fieldtype"), i, false);
            }
        }
    }

    private void setFieldItemName(DynamicObject entity, String item) {
        if (StringUtils.isEmpty((String)item)) {
            return;
        }
        String fieldType = entity.getString("fieldtype");
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
        if (metaDataFieldParser != null) {
            String alias = metaDataFieldParser.parseAlias(item);
            entity.set("fieldextattrname", (Object)alias);
        }
    }

    private void setExtFieldEnable(String fieldType, int entryCurrentRowIndex, boolean isDeleteAllValue) {
        boolean hasFieldConfig = FieldTypeEnum.getExtField((String)fieldType);
        this.getView().setEnable(Boolean.valueOf(hasFieldConfig), entryCurrentRowIndex, new String[]{"fieldextattrname"});
        if (isDeleteAllValue) {
            this.getModel().setValue("fieldextattrname", null, entryCurrentRowIndex);
            this.getModel().setValue("fieldconfig", null, entryCurrentRowIndex);
        }
    }

    private void setInheritTPLField() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String inheritTPL = dataEntity.getString("inherittpl");
        if (StringUtils.isEmpty((String)inheritTPL)) {
            return;
        }
        TableValueSetter tableValueSetter = this.buildTableValueSetter(inheritTPL);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(INHERIT_ENTRY_ENTITY, tableValueSetter);
        model.endInit();
        this.getView().updateView(INHERIT_ENTRY_ENTITY);
    }

    private TableValueSetter buildTableValueSetter(String inheritTPL) {
        MetadataBo metadataBo = this.metadataDomainService.getMetaInfoByNumber(inheritTPL, true, false);
        List items = metadataBo.getItems();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("inheritfieldnumber", new Object[0]);
        tableValueSetter.addField("inheritfieldname", new Object[0]);
        tableValueSetter.addField("inheritmustinput", new Object[0]);
        for (EntityItem item : items) {
            if (!(item instanceof Field)) continue;
            Field itemField = (Field)item;
            tableValueSetter.addRow(new Object[]{itemField.getKey(), itemField.getName(), itemField.isMustInput()});
        }
        return tableValueSetter;
    }

    private void setInheritTPLComboItems() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject bizModel = dataEntity.getDynamicObject("bizmodel");
        if (HRObjectUtils.isEmpty((Object)bizModel)) {
            return;
        }
        DynamicObjectCollection inheritTplEntity = bizModel.getDynamicObjectCollection(INHERIT_ENTRY_ENTITY);
        if (ObjectUtils.isEmpty((Object)inheritTplEntity)) {
            return;
        }
        ArrayList items = Lists.newArrayListWithExpectedSize((int)inheritTplEntity.size());
        inheritTplEntity.forEach(entity -> {
            DynamicObject inherit = entity.getDynamicObject("inheritpath");
            String displayName = entity.getString("displayname");
            if (StringUtils.isEmpty((String)displayName)) {
                displayName = inherit.getString("name");
            }
            ComboItem comboItem = new ComboItem(new LocaleString(displayName), inherit.getString("number"));
            items.add(comboItem);
        });
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("inherittpl");
        comboEdit.setComboItems((List)items);
    }

    private void deleteComboItem() {
        this.getModel().setValue("inherittpl", null);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("inherittpl");
        comboEdit.setComboItems(null);
    }

    private String getCurrentISV() {
        IPageCache pageCache = this.getView().getPageCache();
        String currentISV = pageCache.get(ISV_PRE);
        if (StringUtils.isEmpty((String)currentISV)) {
            currentISV = ISVServiceUtils.getCurrentISV();
            pageCache.put(ISV_PRE, currentISV);
        }
        return currentISV;
    }

    private void copyBizModel(AbstractFormDataModel model, BizModelMainEntityBo mainEntityInfo) {
        FormMetadata formMetadata;
        if (mainEntityInfo == null) {
            return;
        }
        model.setValue("bizmodel", (Object)mainEntityInfo.getBizModelUnit());
        model.setValue("name", (Object)mainEntityInfo.getName());
        model.setValue("description", (Object)mainEntityInfo.getDescription());
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        if (mainEntityInfo.getParentId() != null && (formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)mainEntityInfo.getParentId(), (MetaCategory)MetaCategory.Form)) != null) {
            ComboItem comboItem = new ComboItem(formMetadata.getName(), formMetadata.getKey());
            items.add(comboItem);
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("inherittpl");
            comboEdit.setComboItems((List)items);
            model.setValue("inherittpl", (Object)formMetadata.getKey());
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"bizmodel", "inherittpl"});
        List mainEntityFields = mainEntityInfo.getMainEntityFields();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("fieldtype", new Object[0]);
        tableValueSetter.addField("fieldcode", new Object[0]);
        tableValueSetter.addField("fieldname", new Object[0]);
        tableValueSetter.addField("fieldconfig", new Object[0]);
        for (BizModelConfigFieldBo mainEntityField : mainEntityFields) {
            tableValueSetter.addRow(new Object[]{mainEntityField.getFieldType(), mainEntityField.getNumber(), mainEntityField.getName(), mainEntityField.getFieldRuleContent()});
        }
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private static void setCaption(FormShowParameter formShowParameter) {
        if (OperationStatus.ADDNEW.equals((Object)formShowParameter.getStatus())) {
            LocaleString caption = formShowParameter.getFormConfig().getCaption();
            formShowParameter.setCaption(caption.getLocaleValue());
        }
    }
}

