/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.transferconf.scheme;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrdt.common.constants.ConfigItemConstants;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hdtc.hrdt.formplugin.web.utils.CommonPageUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AddConfigItemsEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener,
CellClickListener {
    IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit bizEntity = (BasedataEdit)this.getView().getControl("bizentity");
        bizEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"addrelentity")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object bizEntityObj = this.getModel().getValue("bizentity", entryCurrentRowIndex);
            if (ObjectUtils.isEmpty((Object)bizEntityObj)) {
                this.getView().showTipNotification(BizModeMsgEnum.WRITE_ENTITY_NAME_TIP.get());
                args.setCancel(true);
                return;
            }
            this.showRelEntityF7Page((DynamicObject)bizEntityObj);
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            this.removePageCacheRecord();
        } else if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            if (this.saveBeforeCheck(args)) {
                return;
            }
            this.getModel().setValue("relentityinfo", (Object)this.getPageCache().get("resultTreeMap"));
        }
    }

    private boolean saveBeforeCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(BizModeMsgEnum.ENTRY_ENTITY_IS_EMPTY.get());
            return true;
        }
        Map<String, String> nubmerRowMappingMap = entryEntity.stream().collect(Collectors.toMap(entry -> entry.getString("seq"), entry -> entry.getString("confignumber")));
        StringBuilder sb = new StringBuilder();
        this.checkPageRepeat(entryEntity, nubmerRowMappingMap, sb);
        this.checkDbRepeat(nubmerRowMappingMap, sb);
        if (HRStringUtils.isEmpty((String)sb.toString())) {
            return false;
        }
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
        paramsMap.put("operateName", BizModeMsgEnum.SUCCESS.get());
        paramsMap.put("title", BizModeMsgEnum.SAVE_FAIL.get());
        paramsMap.put("errorMsg", sb.toString());
        this.getView().showForm(CommonPageUtils.showOperationResult(paramsMap));
        args.setCancel(true);
        return true;
    }

    private void checkPageRepeat(DynamicObjectCollection entryEntity, Map<String, String> nubmerRowMappingMap, StringBuilder sb) {
        Map frequencyMap = nubmerRowMappingMap.values().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List duplicatesList = frequencyMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(duplicatesList)) {
            return;
        }
        HashMap repeatNumberMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        nubmerRowMappingMap.entrySet().stream().forEach(entry -> {
            String number = (String)entry.getValue();
            if (!duplicatesList.contains(number)) {
                return;
            }
            if (repeatNumberMap.containsKey(number)) {
                ((List)repeatNumberMap.get(number)).add(entry.getKey());
            } else {
                repeatNumberMap.put(number, new ArrayList<String>(){
                    {
                        this.add(entry.getKey());
                    }
                });
            }
        });
        repeatNumberMap.entrySet().forEach(entry -> sb.append(String.format(Locale.ROOT, BizModeMsgEnum.CONFIG_ITEM_REPEAT_TIP.get(), entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.joining("\u3001")))).append("\n"));
    }

    private void checkDbRepeat(Map<String, String> nubmerRowMappingMap, StringBuilder sb) {
        Collection<String> confItemNumberCollection = nubmerRowMappingMap.values();
        DynamicObject[] configItemNumberArr = this.configItemDomainService.getConfigItemInfoByConfigItemNumbers(new HashSet<String>(confItemNumberCollection));
        Set configItemNumberSet = Arrays.stream(configItemNumberArr).map(con -> con.getString("confignumber")).collect(Collectors.toSet());
        nubmerRowMappingMap.entrySet().forEach(entry -> {
            if (configItemNumberSet.contains(entry.getValue())) {
                sb.append(String.format(Locale.ROOT, BizModeMsgEnum.DB_CONFIG_ITEM_REPEAT_TIP.get(), entry.getKey(), entry.getValue())).append("\n");
            }
        });
    }

    private void removePageCacheRecord() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object bizEntityObj = this.getModel().getValue("bizentity", entryCurrentRowIndex);
        if (!ObjectUtils.isEmpty((Object)bizEntityObj)) {
            String entityNumber = ((DynamicObject)bizEntityObj).getString("number");
            String resultTreeMapStr = this.getPageCache().get("resultTreeMap");
            if (HRStringUtils.isNotEmpty((String)resultTreeMapStr)) {
                Map resultTreeMap = (Map)SerializationUtils.deSerializeFromBase64((String)resultTreeMapStr);
                resultTreeMap.remove(entityNumber);
                this.getPageCache().put("resultTreeMap", SerializationUtils.serializeToBase64((Object)resultTreeMap));
            }
        }
    }

    private void showRelEntityF7Page(DynamicObject bizEntityObj) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hrdt_addrelentityconff7");
        formShowParameter.setCaption(BizModeMsgEnum.REL_ENTITY_TITLE.get());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "relEntityConfirm"));
        formShowParameter.setCustomParam("entitynumber", (Object)bizEntityObj.getString("number"));
        formShowParameter.setCustomParam("resultTreeMap", (Object)this.getPageCache().get("resultTreeMap"));
        this.getView().showForm(formShowParameter);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object treeId = customParams.get("treeId");
        this.getModel().setValue("group", treeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) && (operationResult = afterDoOperationEventArgs.getOperationResult()) != null && operationResult.isSuccess()) {
            this.getModel().setDataChanged(false);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"relEntityConfirm")) {
            List resultTreeList;
            Object returnData = evt.getReturnData();
            if (returnData instanceof Boolean && ((Boolean)returnData).booleanValue()) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String entityNumber = ((DynamicObject)this.getModel().getValue("bizentity", entryCurrentRowIndex)).getString("number");
            Map<String, List> resultTreeMap = Maps.newHashMap();
            String resultTreeMapStr = this.getPageCache().get("resultTreeMap");
            if (HRStringUtils.isNotEmpty((String)resultTreeMapStr)) {
                resultTreeMap = (Map)SerializationUtils.deSerializeFromBase64((String)resultTreeMapStr);
            }
            if (!CollectionUtils.isEmpty((Collection)(resultTreeList = (List)returnData))) {
                this.getModel().setValue("relentity", (Object)this.configItemDomainService.getWriteBackRelEntity(resultTreeList), entryCurrentRowIndex);
                resultTreeMap.put(entityNumber, resultTreeList);
            } else {
                resultTreeMap.remove(entityNumber);
                this.getModel().setValue("relentity", null, entryCurrentRowIndex);
            }
            this.getPageCache().put("resultTreeMap", SerializationUtils.serializeToBase64(resultTreeMap));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String sourceName = Optional.ofNullable(beforeF7SelectEvent).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"bizentity")) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            listShowParameter.setCaption(BizModeMsgEnum.ENTITY_OBJECT_LIST.get());
            qFilters.add(new QFilter("modeltype", "in", (Object)ConfigItemConstants.BASEDATA_TYPE_LIST));
            qFilters.add(new QFilter("tablename", "!=", (Object)""));
            Set configItemNumberSet = this.configItemDomainService.getConfigItemNumber();
            DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("entryentity");
            Set entityNameSet = treeEntry.stream().map(row -> row.getDynamicObject("bizentity")).filter(Objects::nonNull).map(row -> row.getString("number")).collect(Collectors.toSet());
            configItemNumberSet.addAll(entityNameSet);
            qFilters.add(new QFilter("id", "not in", (Object)configItemNumberSet));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"bizentity")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object bizEntityObj = this.getModel().getValue("bizentity", entryCurrentRowIndex);
            if (ObjectUtils.isEmpty((Object)bizEntityObj)) {
                return;
            }
            String entityNumber = ((DynamicObject)bizEntityObj).getString("number");
            this.getModel().setValue("keyfields", (Object)"id", entryCurrentRowIndex);
            boolean his = this.configItemDomainService.isHisModEntity(entityNumber);
            this.getModel().setValue("ishismod", (Object)his, entryCurrentRowIndex);
            this.getView().setEnable(Boolean.valueOf(his), entryCurrentRowIndex, new String[]{"needallhis"});
            this.getModel().setValue("iscontrolentity", (Object)this.configItemDomainService.isCtrEntity(entityNumber), entryCurrentRowIndex);
            this.getModel().setValue("relconfigitem", (Object)this.configItemDomainService.handleRelConfigItem(entityNumber, this.getModel().getDataEntity(true), 0), entryCurrentRowIndex);
            this.getModel().setValue("relentity", null);
            this.getModel().setValue("confignumber", (Object)("c_" + entityNumber));
        }
    }

    public void cellClick(CellClickEvent evt) {
        Object bizEntity;
        String fieldKey = evt.getFieldKey();
        int row = evt.getRow();
        if (HRStringUtils.equals((String)fieldKey, (String)"keyfields") && !ObjectUtils.isEmpty((Object)(bizEntity = this.getModel().getValue("bizentity", row)))) {
            String entityNumber = ((DynamicObject)bizEntity).getString("number");
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl("keyfields");
            keyFieldEdit.setComboItems(CommonPageUtils.initComboFieldVal(entityNumber));
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

