/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.transferconf.scheme;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hdtc.hrdt.formplugin.web.transferconf.scheme.ConfigItemCommonEditPlugin;
import kd.hdtc.hrdt.formplugin.web.utils.CommonPageUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AddRelEntityConfF7EditPlugin
extends ConfigItemCommonEditPlugin {
    private static final String CLOSE_MARK = "closemark";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = customParams.get("entitynumber").toString();
        this.getView().getPageCache().put("entitynumber", entityNumber);
        Object resultTreeMapObj = customParams.get("resultTreeMap");
        if (ObjectUtils.isEmpty(resultTreeMapObj)) {
            this.handleFirstAddRelEntity(entityNumber);
        } else {
            Map resultTreeMap = (Map)SerializationUtils.deSerializeFromBase64((String)resultTreeMapObj.toString());
            List resultTreeList = (List)resultTreeMap.get(entityNumber);
            if (CollectionUtils.isEmpty((Collection)resultTreeList)) {
                this.handleFirstAddRelEntity(entityNumber);
                return;
            }
            DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
            treeEntry.clear();
            resultTreeList.forEach(list -> {
                DynamicObject dyc = new DynamicObject(treeEntry.getDynamicObjectType());
                list.entrySet().forEach(entry -> dyc.set((String)entry.getKey(), entry.getValue()));
                treeEntry.add((Object)dyc);
                DynamicObject sourceEntity = dyc.getDynamicObject("sourceentity");
                String sourceRelField = dyc.getString("sourcerelfield");
                DynamicObject targetEntity = dyc.getDynamicObject("targetentity");
                String targetRelField = dyc.getString("targetrelfield");
                int seq = dyc.getInt("seq");
                ComboEdit keyFieldEdit = (ComboEdit)this.getControl("sourcerelfield");
                keyFieldEdit.setComboItems(CommonPageUtils.initComboFieldVal(sourceEntity.getString("number")));
                this.getModel().setValue("sourcerelfield", (Object)sourceRelField, seq - 1);
                keyFieldEdit = (ComboEdit)this.getControl("targetrelfield");
                keyFieldEdit.setComboItems(CommonPageUtils.initComboFieldVal(targetEntity.getString("number")));
                this.getModel().setValue("targetrelfield", (Object)targetRelField, seq - 1);
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((TreeEntryGrid)this.getControl("treeentryentity")).setCollapse(false);
        this.lockTreeLayer();
    }

    private void handleFirstAddRelEntity(String entityNumber) {
        DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
        ((DynamicObject)treeEntry.get(0)).set("sourceentity", (Object)this.configItemDomainService.getBosEntityObjectByNumber(entityNumber));
        ComboEdit keyFieldEdit = (ComboEdit)this.getControl("sourcerelfield");
        keyFieldEdit.setComboItems(CommonPageUtils.initComboFieldVal(entityNumber));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
        if (HRStringUtils.equals((String)"confirm", (String)operateKey)) {
            String msgTip = this.configItemDomainService.getRelEntityRequireMsgTip(treeEntry);
            if (HRStringUtils.isNotEmpty((String)msgTip)) {
                args.setCancel(true);
                this.getView().showMessage(BizModeMsgEnum.MISS_REQUIERD_TIP.get(), msgTip, MessageTypes.Default);
                return;
            }
            DynamicObjectCollection treeList = this.getModel().getEntryEntity("treeentryentity");
            this.getView().returnDataToParent((Object)this.configItemDomainService.assembleReturnInfo(treeList));
            this.getView().getPageCache().put(CLOSE_MARK, "false");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String closeMark = this.getView().getPageCache().get(CLOSE_MARK);
        if (HRStringUtils.isEmpty((String)closeMark)) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
        }
    }
}

