/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.transferconf.scheme;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrdt.common.constants.ConfigItemConstants;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hdtc.hrdt.formplugin.web.utils.CommonPageUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigItemCommonEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener,
CellClickListener {
    IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit sourceEntity = (BasedataEdit)this.getView().getControl("sourceentity");
        sourceEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetEntity = (BasedataEdit)this.getView().getControl("targetentity");
        targetEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        Long pid = (Long)this.getModel().getValue("pid", entryCurrentRowIndex);
        if (HRStringUtils.equals((String)operateKey, (String)"newentry")) {
            args.setCancel(true);
            if (pid == null || pid.equals(0L)) {
                String entityNumber = this.getView().getPageCache().get("entitynumber");
                if (HRStringUtils.isEmpty((String)entityNumber)) {
                    entityNumber = this.getModel().getDataEntity().getDynamicObject("bizentity").getString("number");
                }
                int newEntryRow = this.getModel().createNewEntryRow("treeentryentity");
                this.getModel().setValue("sourceentity", (Object)this.configItemDomainService.getBosEntityObjectByNumber(entityNumber), newEntryRow);
            } else {
                DynamicObject parentNode = treeEntry.stream().filter(node -> (long)pid.compareTo(node.getLong("id")) == 0L).findFirst().get();
                int newRow = this.getModel().insertEntryRow("treeentryentity", parentNode.getInt("seq") - 1);
                this.getModel().setValue("sourceentity", (Object)parentNode.getDynamicObject("targetentity"), newRow);
            }
        } else if (HRStringUtils.equals((String)"insertentry", (String)operateKey)) {
            if (this.handleInsertTip(args, entryCurrentRowIndex)) {
                return;
            }
            if (this.configItemDomainService.getCurrentLayer(pid, treeEntry, 0) >= 5) {
                args.setCancel(true);
                this.getView().showTipNotification(BizModeMsgEnum.INSERT_UP_TO_FIVE_LAYERS.get());
            }
        } else if (HRStringUtils.equals((String)"deleteentry", (String)operateKey)) {
            if (pid == 0L) {
                return;
            }
            long subCount = treeEntry.stream().filter(entry -> entry.getLong("pid") == pid.longValue()).count();
            if (subCount == 1L) {
                this.getView().setEnable(Boolean.TRUE, this.getParentRowByPid(pid) - 1, new String[]{"targetentity", "sourcerelfield", "targetrelfield"});
            }
        }
    }

    private boolean handleInsertTip(BeforeDoOperationEventArgs args, int entryCurrentRowIndex) {
        ArrayList fieldNameList = Lists.newArrayListWithCapacity((int)3);
        if (this.getModel().getValue("sourcerelfield", entryCurrentRowIndex) == null) {
            fieldNameList.add(BizModeMsgEnum.ENTITY_FIELD_TIP.get());
        }
        if (this.getModel().getValue("targetentity", entryCurrentRowIndex) == null) {
            fieldNameList.add(BizModeMsgEnum.REL_ENTITY_NAME_TIP.get());
        }
        if (this.getModel().getValue("targetrelfield", entryCurrentRowIndex) == null) {
            fieldNameList.add(BizModeMsgEnum.REL_ENTITY_FIELD_TIP.get());
        }
        if (CollectionUtils.isEmpty((Collection)fieldNameList)) {
            return false;
        }
        args.setCancel(true);
        this.getView().showTipNotification(BizModeMsgEnum.PLEASE_WRITE_TIP.get() + fieldNameList.stream().collect(Collectors.joining("\u3001")));
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        Long pid = (Long)this.getModel().getValue("pid", entryCurrentRowIndex);
        if (HRStringUtils.equals((String)"insertentry", (String)operateKey)) {
            DynamicObject parentNode = treeEntry.stream().filter(node -> (long)pid.compareTo(node.getLong("id")) == 0L).findFirst().get();
            this.getModel().setValue("sourceentity", (Object)parentNode.getDynamicObject("targetentity"), entryCurrentRowIndex);
            this.getView().setEnable(Boolean.FALSE, this.getParentRowByPid(pid) - 1, new String[]{"targetentity", "sourcerelfield", "targetrelfield"});
        }
    }

    private int getParentRowByPid(Long pid) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        Optional<Integer> seq = entryEntity.stream().filter(entry -> pid.longValue() == entry.getLong("id")).map(entry -> entry.getInt("seq")).findFirst();
        return seq.get();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String sourceName = Optional.ofNullable(beforeF7SelectEvent).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"sourceentity") || HRStringUtils.equals((String)sourceName, (String)"targetentity")) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCaption(BizModeMsgEnum.ENTITY_OBJECT_LIST.get());
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("modeltype", "in", (Object)ConfigItemConstants.BASEDATA_TYPE_LIST));
            qFilters.add(new QFilter("tablename", "!=", (Object)""));
        }
    }

    public void cellClick(CellClickEvent evt) {
        Object targetEntityObj;
        String fieldKey = evt.getFieldKey();
        int row = evt.getRow();
        if (HRStringUtils.equals((String)fieldKey, (String)"sourcerelfield")) {
            Object sourceEntityObj = this.getModel().getValue("sourceentity", row);
            if (!ObjectUtils.isEmpty((Object)sourceEntityObj)) {
                String entityNumber = ((DynamicObject)sourceEntityObj).getString("number");
                Object pid = this.getModel().getValue("pid", row);
                ComboEdit keyFieldEdit = (ComboEdit)this.getControl("sourcerelfield");
                if (HRStringUtils.equals((String)pid.toString(), (String)"0")) {
                    keyFieldEdit.setComboItems(CommonPageUtils.getRelEntityComboFieldVal(entityNumber));
                } else {
                    keyFieldEdit.setComboItems(CommonPageUtils.initComboFieldVal(entityNumber));
                }
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"targetrelfield") && !ObjectUtils.isEmpty((Object)(targetEntityObj = this.getModel().getValue("targetentity", row)))) {
            String entityNumber = ((DynamicObject)targetEntityObj).getString("number");
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl("targetrelfield");
            keyFieldEdit.setComboItems(CommonPageUtils.initComboFieldVal(entityNumber));
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"targetentity")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
            this.getModel().setValue("targetrelfield", null, entryCurrentRowIndex);
        }
        if (HRStringUtils.equals((String)propertyName, (String)"group")) {
            this.getModel().setValue("orderfield", (Object)this.configItemDomainService.queryNewConfigItemOrderField(this.getModel().getDataEntity()));
        }
    }

    protected void lockTreeLayer() {
        DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
        Map<Long, Integer> treeMap = treeEntry.stream().collect(Collectors.toMap(node -> node.getLong("id"), node -> node.getInt("seq")));
        HashSet seqSet = Sets.newHashSetWithExpectedSize((int)treeEntry.size());
        treeEntry.forEach(node -> {
            long pid = node.getLong("pid");
            Integer seq = (Integer)treeMap.get(pid);
            if (seq != null) {
                seqSet.add(seq);
            }
        });
        seqSet.forEach(seq -> this.getView().setEnable(Boolean.FALSE, seq - 1, new String[]{"targetentity", "sourcerelfield", "targetrelfield"}));
    }
}

