/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.transferconf.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hdtc.hrdt.formplugin.web.transferconf.ConfigTreeBasePlugin;
import kd.hdtc.hrdt.formplugin.web.utils.CommonPageUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigTreeListPlugin
extends ConfigTreeBasePlugin {
    private static final Log LOG = LogFactory.getLog(ConfigTreeListPlugin.class);
    private static final String SYNC_CONFIG_INFO = "syncConfigInfo";
    private static final String DEL_CONFIG_INFO = "delConfigInfo";
    private static final String SUCCESS = "success";
    private static final String MSG = "msg";
    IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btndel"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.clearSchemaFilter();
    }

    private void clearSchemaFilter() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (HRStringUtils.isNotEmpty((String)((String)listShowParameter.getCustomParam("notSyncConfigItem"))) && HRStringUtils.isEmpty((String)this.getView().getPageCache().get("notSyncConfigItem"))) {
            this.getView().getPageCache().put("notSyncConfigItem", "true");
            FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
            ArrayList emptyList = new ArrayList();
            container.schemeSearch(emptyList, emptyList, "hrdt_configitems");
        }
    }

    public void treeToolbarClick(EventObject object) {
        Control ctl = (Control)object.getSource();
        if ("btnnew".equals(ctl.getKey()) || "btnedit".equals(ctl.getKey())) {
            return;
        }
        if ("btndel".equals(ctl.getKey())) {
            this.groupBarDel(object);
            return;
        }
        super.treeToolbarClick(object);
    }

    public void groupBarDel(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        Control ctl = (Control)e.getSource();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (ctl.getKey().equals("btndel")) {
            GroupProp prop = this.getTreeModel().getGroupProp();
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                return;
            }
            if (!prop.isNeedRefreshTree()) {
                return;
            }
            ((FormView)this.getView()).getClientProxy().removeAction("showConfirm");
            TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
            String text = currentNode.getText();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u5206\u7ec4\"%s\"\uff1f", (String)"ConfigTreeListPlugin_10", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]), text);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"new")) {
            args.setCancel(true);
            this.batchAddConfigItems();
        } else if (HRStringUtils.equals((String)operateKey, (String)"synsysconfig")) {
            this.getView().showConfirm(BizModeMsgEnum.SYNC_CONFIG_INFO_TIP.get(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SYNC_CONFIG_INFO, (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Map<Object, String> selectMap = listSelectedData.stream().collect(Collectors.toMap(sel -> sel.getPrimaryKeyValue(), sel -> sel.getName()));
            this.getView().getPageCache().put(DEL_CONFIG_INFO, JSONObject.toJSONString(selectMap));
            this.getView().showConfirm(String.format(Locale.ROOT, BizModeMsgEnum.DEL_CONGIITEM_CONFIRM_TIP.get(), listSelectedData.size()), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(DEL_CONFIG_INFO, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes && (HRStringUtils.equals((String)"group_bar_del", (String)evt.getCallBackId()) || HRStringUtils.equals((String)"delbygroup", (String)evt.getCallBackId()))) {
            this.delConfItemTreeGroup(evt);
        } else if (HRStringUtils.equals((String)evt.getCallBackId(), (String)SYNC_CONFIG_INFO)) {
            if (evt.getResult() != MessageBoxResult.Yes) {
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            stopwatch.elapsed(TimeUnit.SECONDS);
            JSONObject result = this.configItemDomainService.syncConfigTree();
            LOG.info("\u3010HRDT\u3011sync Ricc ConfigTree Elapsed Time\uff1a{}", (Object)stopwatch.stop());
            stopwatch.start();
            JSONObject confItemResult = this.configItemDomainService.syncConfigItem();
            LOG.info("\u3010HRDT\u3011sync Ricc ConfigItem Elapsed Time\uff1a{}", (Object)stopwatch.stop());
            if (!HRStringUtils.equals((String)result.getString(SUCCESS), (String)"true") || !HRStringUtils.equals((String)confItemResult.getString(SUCCESS), (String)"true")) {
                String treeMsg = result.getString(MSG);
                String confItemResultMsg = confItemResult.getString(MSG);
                if (HRStringUtils.isNotEmpty((String)treeMsg) || HRStringUtils.isNotEmpty((String)confItemResultMsg)) {
                    StringBuilder failMsg = new StringBuilder();
                    if (HRStringUtils.isNotEmpty((String)treeMsg)) {
                        String treeFailMsg = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5206\u7ec4\u540c\u6b65\u5931\u8d25\uff1a", (String)"ConfigTreeListPlugin_2", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]), new Object[0]);
                        failMsg.append(treeFailMsg).append("\r\n").append(treeMsg);
                    }
                    if (HRStringUtils.isNotEmpty((String)confItemResultMsg)) {
                        String treeConfItemFailMsg = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u540c\u6b65\u5931\u8d25\uff1a", (String)"ConfigTreeListPlugin_3", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]), new Object[0]);
                        failMsg.append(treeConfItemFailMsg).append("\r\n").append(confItemResultMsg);
                    }
                    this.getView().showErrorNotification(failMsg.toString());
                }
            } else {
                this.getView().showSuccessNotification(BizModeMsgEnum.SYNC_SUCCESS.get());
            }
        } else if (HRStringUtils.equals((String)evt.getCallBackId(), (String)DEL_CONFIG_INFO)) {
            if (evt.getResult() != MessageBoxResult.Yes) {
                return;
            }
            Map selectMap = (Map)JSONObject.parseObject((String)this.getView().getPageCache().get(DEL_CONFIG_INFO), HashMap.class);
            this.delConfigItems(selectMap);
        }
    }

    private void delConfItemTreeGroup(MessageBoxClosedEvent evt) {
        List<Object> list = new ArrayList();
        HashMap<Long, Object> delDataMap = new HashMap<Long, Object>(16);
        if ("group_bar_del".equals(evt.getCallBackId())) {
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
            if (props != null) {
                BasedataEntityType entityType = props.getEntityType();
                DynamicObjectCollection childCol = this.configItemDomainService.getChildrenDynamicObject(new Object[]{nodeId}, entityType);
                if (CollectionUtils.isNotEmpty((Collection)childCol)) {
                    list = childCol.stream().map(child -> child.getPkValue()).collect(Collectors.toList());
                }
                if (list.size() > 1) {
                    TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(nodeId);
                    String text = currentNode.getText();
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"ConfigTreeListPlugin_6", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u7ec4%s\u5b58\u5728\u4e0b\u7ea7\u5206\u7ec4\uff0c\u6b64\u6b21\u5220\u9664\u5c06\u5220\u9664\u5206\u7ec4\u53ca\u6240\u6709\u4e0b\u7ea7\u5206\u7ec4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ConfigTreeListPlugin_7", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]), text), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("delbygroup", (IFormPlugin)this));
                } else {
                    Map failInfoMsg;
                    String errorCode;
                    Map failPkIdsInfoMap;
                    ArrayList<Long> delIds = new ArrayList<Long>(16);
                    long pkId = Long.parseLong(nodeId);
                    delIds.add(pkId);
                    JSONObject delSysGroupResult = this.configItemDomainService.delSysConfigTrees(delIds);
                    if (!(HRStringUtils.equals((String)delSysGroupResult.getString(SUCCESS), (String)"true") || ObjectUtils.isEmpty((Object)(failPkIdsInfoMap = (Map)delSysGroupResult.get((Object)"failPkIdsInfo"))) || "notExistRecords".equals(errorCode = (String)(failInfoMsg = (Map)failPkIdsInfoMap.get(pkId)).get("errorCode")))) {
                        String treeMsg = delSysGroupResult.getString(MSG);
                        this.getView().showTipNotification(treeMsg);
                        return;
                    }
                    IOperationResult opResult = this.getTreeModel().deleteGroup(new Object[]{nodeId});
                    if (opResult.isSuccess()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ConfigTreeListPlugin_8", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showOperationResult((OperationResult)opResult, ResManager.loadKDString((String)"\u5220\u9664", (String)"ConfigTreeListPlugin_9", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]));
                    }
                    this.delGroupRefreshTree(nodeId, opResult);
                }
            }
        } else if ("delbygroup".equals(evt.getCallBackId())) {
            this.delByGroup(delDataMap);
        }
    }

    private void delByGroup(Map<Long, Object> delDataMap) {
        String nodeId = (String)this.getTreeModel().getCurrentNodeId();
        GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
        ArrayList pkIdList = new ArrayList();
        ArrayList delIdList = new ArrayList(16);
        if (props != null) {
            BasedataEntityType entityType = props.getEntityType();
            DynamicObjectCollection childCol = this.configItemDomainService.getChildrenDynamicObject(new Object[]{nodeId}, entityType);
            ArrayList finalList = pkIdList;
            childCol.forEach(c -> {
                Object pkValue = c.getPkValue();
                finalList.add(pkValue);
                long pkId = Long.parseLong(pkValue.toString());
                delIdList.add(pkId);
                delDataMap.put(pkId, c.getString("number"));
            });
        }
        if (pkIdList.size() > 0) {
            JSONObject delSysGroupResult = this.configItemDomainService.delSysConfigTrees(delIdList);
            ArrayList<Long> syncDelSuccessIdList = new ArrayList<Long>(16);
            String operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"ConfigTreeListPlugin_5", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]);
            HashMap syncDelSysGroupFailMap = new HashMap(16);
            if (!HRStringUtils.equals((String)delSysGroupResult.getString(SUCCESS), (String)"true")) {
                Map sysDelGroupFailMap = (Map)delSysGroupResult.get((Object)"failPkIdsInfo");
                syncDelSysGroupFailMap.putAll(sysDelGroupFailMap);
                List pkIds = (List)delSysGroupResult.get((Object)"successPkIds");
                Map failPkIdMap = (Map)delSysGroupResult.get((Object)"failPkIdsInfo");
                pkIds.forEach(pkId -> syncDelSuccessIdList.add(Long.parseLong(pkId.toString())));
                for (Map.Entry failEntry : failPkIdMap.entrySet()) {
                    Map failMap = (Map)failEntry.getValue();
                    String errorCode = (String)failMap.get("errorCode");
                    long pkId2 = Long.parseLong(failEntry.getKey().toString());
                    syncDelSysGroupFailMap.put(pkId2, failEntry.getValue());
                    if (!"notExistRecords".equals(errorCode)) continue;
                    syncDelSuccessIdList.add(pkId2);
                }
            } else {
                syncDelSuccessIdList.addAll(delIdList);
            }
            IOperationResult opResult = this.getTreeModel().deleteGroup(syncDelSuccessIdList.toArray());
            if (opResult.isSuccess() && HRStringUtils.equals((String)delSysGroupResult.getString(SUCCESS), (String)"true")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ConfigTreeListPlugin_8", (String)"hdtc-hrdbs-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter formShowParameterResultMulti = this.configItemDomainService.getDelConfGroupFormShowParameter(delDataMap, (OperationResult)opResult, operateName, syncDelSysGroupFailMap);
                this.getView().showForm(formShowParameterResultMulti);
            }
            this.delGroupRefreshTree(nodeId, opResult);
        }
    }

    private void delGroupRefreshTree(String nodeId, IOperationResult opResult) {
        if (!opResult.getSuccessPkIds().isEmpty()) {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId);
            this.getTreeModel().deleteNode(node, false);
            TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid());
            if (parentNode != null) {
                this.updatePageCache(null);
                this.treeListView.getTreeModel().refreshNode((Object)parentNode.getId());
                this.treeListView.refreshTreeNode(parentNode.getId());
                this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
            }
        }
    }

    private void delConfigItems(Map<Long, String> selectMap) {
        Set selectIdSet = selectMap.keySet().stream().collect(Collectors.toSet());
        StringBuilder errorMsgSb = new StringBuilder();
        DynamicObject[] sysPresetIdArr = this.configItemDomainService.getSysPresetConfigItemInfo(selectIdSet);
        Set<Long> sysPresetIdSet = Arrays.stream(sysPresetIdArr).map(sys -> sys.getLong("id")).collect(Collectors.toSet());
        selectIdSet.removeAll(sysPresetIdSet);
        sysPresetIdSet.forEach(id -> errorMsgSb.append(String.format(Locale.ROOT, BizModeMsgEnum.SYS_PRESET_DATA_NOT_DELETE_TIP.get(), selectMap.get(id))).append("\r\n"));
        JSONObject result = this.configItemDomainService.batchDelRiccConfigItem(selectIdSet);
        LOG.info("sync ricc record(delConfigItems):", (Object)result.toJSONString());
        JSONArray successPkIds = result.getJSONArray("successPkIds");
        if (successPkIds != null) {
            this.configItemDomainService.batchDelConfigItem(successPkIds.stream().map(id -> (Long)id).collect(Collectors.toSet()));
        }
        Map failPkIdsInfo = (Map)result.getObject("failPkIdsInfo", Map.class);
        AtomicInteger notExistRecordsCount = new AtomicInteger(0);
        if (!ObjectUtils.isEmpty((Object)failPkIdsInfo)) {
            HashSet notExistRecordsIdSet = Sets.newHashSet();
            failPkIdsInfo.entrySet().forEach(entry -> {
                Long id = (Long)entry.getKey();
                Map errorInfoMap = (Map)entry.getValue();
                String errorCode = (String)errorInfoMap.get("errorCode");
                if (HRStringUtils.equals((String)errorCode, (String)"notExistRecords")) {
                    notExistRecordsCount.getAndIncrement();
                    notExistRecordsIdSet.add(id);
                } else {
                    errorMsgSb.append((String)selectMap.get(id)).append("\uff1a").append((String)errorInfoMap.get("errorMsg")).append("\r\n");
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)notExistRecordsIdSet)) {
                this.configItemDomainService.batchDelConfigItem((Set)notExistRecordsIdSet);
            }
        }
        int successCount = (successPkIds == null ? 0 : successPkIds.size()) + notExistRecordsCount.get();
        int failCount = selectMap.size() - successCount;
        if (selectMap.size() == 1 && failCount == 1) {
            this.getView().showErrorNotification(errorMsgSb.toString());
            return;
        }
        if (selectMap.size() == successCount) {
            this.getView().showSuccessNotification(BizModeMsgEnum.DELETE_SUCCESS.get());
            this.getView().invokeOperation("refresh");
            return;
        }
        String secondTip = String.format(Locale.ROOT, BizModeMsgEnum.DEL_SECOND_TIP_TITLE.get(), selectMap.size(), successCount, failCount);
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
        paramsMap.put("operateName", BizModeMsgEnum.SUCCESS.get());
        paramsMap.put("title", secondTip);
        paramsMap.put("errorMsg", errorMsgSb.toString());
        this.getView().showForm(CommonPageUtils.showOperationResult(paramsMap));
        this.getView().invokeOperation("refresh");
    }

    private void batchAddConfigItems() {
        BillShowParameter showParameter;
        String pageId;
        String currentNodeIdStr = this.getTreeModel().getCurrentNodeId().toString();
        Long curNodeId = 0L;
        if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(currentNodeIdStr)) {
            curNodeId = Long.parseLong(currentNodeIdStr);
        }
        if (HRStringUtils.isEmpty((String)(pageId = SessionManager.getCurrent().get(this.getView().getPageId() + "new"))) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new BillShowParameter();
            showParameter.setFormId("hrdt_addconfigitems");
            SessionManager.getCurrent().put(this.getView().getPageId() + "new", showParameter.getPageId());
        } else {
            showParameter = (BillShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
        }
        showParameter.setCustomParam("treeId", (Object)curNodeId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void updatePageCache(List<TreeNode> treeNodes) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String treeNodesString = null;
        if (treeNodes != null) {
            treeNodesString = SerializationUtils.toJsonString(treeNodes);
        }
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        pageCache.put(matchNodesCacheKey, treeNodesString);
        pageCache.put(searchNodesCacheKey, treeNodesString);
        pageCache.put(searchIndexCacheKey, String.valueOf(0));
    }
}

