/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.transferconf.scheme;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hdtc.hrdt.common.enums.CompareDetailTypeEnum;

public class TransferConfigCompareDataDetailPlugin
extends AbstractHDTCFormPlugin
implements SearchEnterListener {
    private static final String SEARCH_AP = "searchap";
    private static final String NEW = "new";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String ALL = "all";
    private static final String NEW_COUNT = "newcount";
    private static final String UPDATE_COUNT = "updatecount";
    private static final String DELETE_COUNT = "deletecount";
    private static final String LIST_CACHE_KEY = "listCache";
    private static final String CUSTOM_CONTROL_AP = "customcontrolap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.renderCustomData();
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void renderCustomData() {
        List srcData = (List)this.getView().getFormShowParameter().getCustomParam("details");
        this.renderDataToPage(srcData);
        this.showCount();
        this.putListToCache(srcData);
    }

    private void renderDataToPage(List<Map<String, Object>> boList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOM_CONTROL_AP);
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("dataList", boList);
        result.put("random", new SecureRandom().nextInt(10000000));
        customcontrol.setData(result);
        this.getView().updateView(CUSTOM_CONTROL_AP);
    }

    private void showCount() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(NEW_COUNT, params.get("newNum"));
        this.getModel().setValue(UPDATE_COUNT, params.get("modifyNum"));
        this.getModel().setValue(DELETE_COUNT, params.get("deleteNum"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String BREAK_FLAG = "breakFlag";
        String breakFlag = this.getPageCache().get(BREAK_FLAG);
        if ("1".equals(breakFlag)) {
            return;
        }
        String name = e.getProperty().getName();
        DynamicObject modelEntity = this.getModel().getDataEntity();
        boolean allValue = modelEntity.getBoolean(ALL);
        boolean newValue = modelEntity.getBoolean(NEW);
        boolean updateValue = modelEntity.getBoolean(UPDATE);
        boolean deleteValue = modelEntity.getBoolean(DELETE);
        if (ALL.equals(name)) {
            if (allValue) {
                this.getModel().setValue(NEW, (Object)Boolean.FALSE);
                this.getModel().setValue(UPDATE, (Object)Boolean.FALSE);
                this.getModel().setValue(DELETE, (Object)Boolean.FALSE);
            } else {
                this.getModel().setValue(NEW, (Object)Boolean.TRUE);
                this.getModel().setValue(UPDATE, (Object)Boolean.TRUE);
                this.getModel().setValue(DELETE, (Object)Boolean.TRUE);
            }
        } else if (NEW.equals(name) || UPDATE.equals(name) || DELETE.equals(name)) {
            this.getPageCache().put(BREAK_FLAG, "1");
            if (newValue || updateValue || deleteValue) {
                this.getModel().setValue(ALL, (Object)Boolean.FALSE);
            } else {
                this.getModel().setValue(ALL, (Object)Boolean.TRUE);
            }
            this.getPageCache().put(BREAK_FLAG, "0");
        }
        this.filterList();
    }

    private void putListToCache(List<Map<String, Object>> boList) {
        if (CollectionUtils.isNotEmpty(boList)) {
            this.getPageCache().put(LIST_CACHE_KEY, SerializationUtils.toJsonString(boList));
        }
    }

    private List<Map<String, Object>> getListFromCache() {
        String listStr = this.getPageCache().get(LIST_CACHE_KEY);
        List<Map<String, Object>> boList = new ArrayList<Map<String, Object>>(4);
        if (StringUtils.isNotEmpty((String)listStr)) {
            boList = SerializationUtils.fromJsonStringToList((String)listStr, Map.class);
        }
        return boList;
    }

    public void search(SearchEnterEvent evt) {
        this.filterList();
    }

    private void filterList() {
        Search search = (Search)this.getControl(SEARCH_AP);
        String searchText = search.getSearchKey();
        DynamicObject modelEntity = this.getModel().getDataEntity();
        boolean allValue = modelEntity.getBoolean(ALL);
        boolean newValue = modelEntity.getBoolean(NEW);
        boolean updateValue = modelEntity.getBoolean(UPDATE);
        boolean deleteValue = modelEntity.getBoolean(DELETE);
        List<Map<String, Object>> boList = this.getListFromCache();
        List<Map<String, Object>> result = boList.stream().filter(data -> {
            String displayName = String.valueOf(data.get("displayName"));
            String type = String.valueOf(data.get("type"));
            if (StringUtils.isNotEmpty((String)searchText) && StringUtils.isNotEmpty((String)displayName) && displayName.indexOf(searchText) < 0) {
                return false;
            }
            if (allValue) {
                return true;
            }
            if (newValue && StringUtils.equals((String)type, (String)CompareDetailTypeEnum.ADD.name())) {
                return true;
            }
            if (updateValue && StringUtils.equals((String)type, (String)CompareDetailTypeEnum.MODIFY.name())) {
                return true;
            }
            return deleteValue && StringUtils.equals((String)type, (String)CompareDetailTypeEnum.DELETE.name());
        }).collect(Collectors.toList());
        this.renderDataToPage(result);
    }
}

