/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.transferconf.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hdtc.hrdt.business.application.service.transferconf.ITransferConfigCompareDataApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.model.TransferConfigCompareDataBo;
import kd.hdtc.hrdt.business.common.model.TransferConfigCompareResultDataBo;
import kd.hdtc.hrdt.common.util.ShowParameterUtil;

public class TransferConfigCompareDataPlugin
extends AbstractHDTCFormPlugin {
    private static final String TARGET_DATACENTER = "targetdatacenter";
    private static final String TARGET_DATACENTER_USER = "targetdatacenteruser";
    private static final String CONFIG_ITEM = "configitem";
    private static final String UNIQUE_KEY_VALUE = "uniquekeyitem";
    private static final String CONFIG_ITEMS = "configItems";
    private static final String CUSTOM_CONTROL_AP = "customcontrolap";
    private static final String PAGE_DATA_CACHE = "pageDataCache";
    private ITransferConfigCompareDataApplication transferConfigCompareDataApplication = (ITransferConfigCompareDataApplication)ServiceFactory.getService(ITransferConfigCompareDataApplication.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getView().getControl(UNIQUE_KEY_VALUE);
        textEdit.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        JSONObject json = JSON.parseObject((String)args);
        if ("showPage".equals(eventName)) {
            String entityNumber = json.getString("subEntityNumber");
            String entityName = json.getString("subEntityName");
            String uniqueKeyValue = json.getString("subEntityUniqueKeyValue");
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            Map<String, Object> bo = this.getPageFromCache(entityNumber, uniqueKeyValue);
            if (bo != null) {
                List details = (List)bo.get("details");
                customParams.put("details", details);
                customParams.put("addNum", bo.getOrDefault("addNum", Character.valueOf('0')));
                customParams.put("modifyNum", bo.getOrDefault("modifyNum", Character.valueOf('0')));
                customParams.put("deleteNum", bo.getOrDefault("deleteNum", Character.valueOf('0')));
            }
            this.showDiff(customParams, entityName);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((String)UNIQUE_KEY_VALUE, (String)controlKey)) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
            DynamicObject configItem = entryRowEntity.getDynamicObject(CONFIG_ITEM);
            if (configItem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f20\u8f93\u65b9\u6848", (String)"TransferConfigCompareDataPlugin_5", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = configItem.getString("bizentity.number");
            ListShowParameter parameter = ShowParameterUtil.buildSimpleF7ListShowParameter((String)entityNumber, (ShowType)ShowType.Modal, null);
            parameter.setLookUp(true);
            parameter.setMultiSelect(true);
            StyleCss style = new StyleCss();
            style.setWidth("1000");
            style.setHeight("600");
            parameter.getOpenStyle().setInlineStyleCss(style);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "F7listCallBack"));
            parameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("F7listCallBack".equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
            if (selectedRows == null) {
                return;
            }
            List<Object> ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue(UNIQUE_KEY_VALUE, (Object)Joiner.on((String)",").join(ids), entryCurrentRowIndex);
            DynamicObject configItem = this.getCurrentConfig();
            if (configItem != null) {
                this.putConfigItemToCache(configItem.getString("id"), ids);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject configItem;
        String uni;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (CONFIG_ITEM.equals(key)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue(UNIQUE_KEY_VALUE, null, entryCurrentRowIndex);
            ChangeData[] changeDataArr = e.getChangeSet();
            if (changeDataArr == null || changeDataArr.length <= 0) {
                return;
            }
            ChangeData changeData = changeDataArr[0];
            DynamicObject configItem2 = (DynamicObject)changeData.getOldValue();
            if (configItem2 != null) {
                this.putConfigItemToCache(configItem2.getString("id"), null);
            }
        } else if (UNIQUE_KEY_VALUE.equals(key) && StringUtils.isEmpty((String)(uni = (String)this.getModel().getValue(UNIQUE_KEY_VALUE))) && (configItem = this.getCurrentConfig()) != null) {
            this.putConfigItemToCache(configItem.getString("id"), null);
        }
    }

    private DynamicObject getCurrentConfig() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject configItem = entryRowEntity.getDynamicObject(CONFIG_ITEM);
        return configItem;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("query".equals(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult == null || !operationResult.isSuccess()) {
                return;
            }
            List<TransferConfigCompareDataBo> boList = this.buildAndValidateData();
            if (CollectionUtils.isEmpty(boList)) {
                return;
            }
            String errorInfo = this.transferConfigCompareDataApplication.getConfigCompareDataByConfigInfo(boList);
            if (StringUtils.isNotEmpty((String)errorInfo)) {
                this.getView().showErrorNotification(errorInfo);
                return;
            }
            this.renderDataToPage(boList);
        }
    }

    private List<TransferConfigCompareDataBo> buildAndValidateData() {
        DynamicObject data = this.getModel().getDataEntity();
        TransferConfigCompareDataBo sourceBo = new TransferConfigCompareDataBo();
        sourceBo.setTargetDataCenter(data.getDynamicObject(TARGET_DATACENTER));
        sourceBo.setTargetDatacenterUser(data.getString(TARGET_DATACENTER_USER));
        StringBuilder validateInfoSb = new StringBuilder();
        DynamicObjectCollection configs = data.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)configs)) {
            validateInfoSb.append(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a\n", (String)"TransferConfigCompareDataPlugin_4", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        } else {
            AtomicInteger index = new AtomicInteger();
            configs.stream().forEach(config -> {
                index.incrementAndGet();
                if (config.getDynamicObject(CONFIG_ITEM) == null || StringUtils.isEmpty((String)config.getString(UNIQUE_KEY_VALUE))) {
                    validateInfoSb.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u8bf7\u6b63\u786e\u6dfb\u52a0\u914d\u7f6e\u9879\u6216\u552f\u4e00\u952e\u503c\n", (String)"TransferConfigCompareDataPlugin_3", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), index));
                }
            });
        }
        if (StringUtils.isNotEmpty((String)validateInfoSb.toString())) {
            this.getView().showErrorNotification(validateInfoSb.toString());
            return null;
        }
        Map<String, List<Object>> configItems = this.getConfigItemToCache();
        ArrayList<TransferConfigCompareDataBo> list = new ArrayList<TransferConfigCompareDataBo>(16);
        configs.stream().forEach(config -> {
            DynamicObject confDyn = config.getDynamicObject(CONFIG_ITEM);
            if (confDyn == null) {
                return;
            }
            long confId = confDyn.getLong("id");
            String confName = confDyn.getString("name");
            List ids = (List)configItems.get(String.valueOf(confId));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return;
            }
            ids.stream().forEach(id -> {
                TransferConfigCompareDataBo bo = new TransferConfigCompareDataBo();
                bo.setConfigId(confId);
                bo.setConfigName(confName);
                bo.setTargetDataCenter(sourceBo.getTargetDataCenter());
                bo.setTargetDatacenterUser(sourceBo.getTargetDatacenterUser());
                bo.setUniqueKeyValue(id);
                bo.setEntityNumber(confDyn.getString("bizentity.number"));
                list.add(bo);
            });
        });
        return list;
    }

    private void showDiff(Map<String, Object> customParams, String name) {
        StringBuilder caption = new StringBuilder(ResManager.loadKDString((String)"\u6570\u636e\u5dee\u5f02\u5bf9\u6bd4", (String)"TransferConfigCompareDataPlugin_6", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((String)name)) {
            caption.append("--");
            caption.append(name);
        }
        FormShowParameter formShowParameter = this.formShowParameter("hrdt_compareresult", ShowType.Modal, customParams, caption.toString(), null);
        formShowParameter.setParentPageId(this.getView().getPageId());
        this.getView().showForm(formShowParameter);
    }

    public FormShowParameter formShowParameter(String formId, ShowType showType, Map<String, Object> customParams, String caption, String custPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        if (!StringUtils.isEmpty((String)caption)) {
            formShowParameter.setCaption(caption);
        }
        if (!StringUtils.isEmpty((String)custPlugin)) {
            formShowParameter.addCustPlugin(custPlugin);
        }
        if (customParams != null && !customParams.isEmpty()) {
            formShowParameter.setCustomParams(customParams);
        }
        return formShowParameter;
    }

    private void renderDataToPage(List<TransferConfigCompareDataBo> boList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOM_CONTROL_AP);
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List<TransferConfigCompareResultDataBo> pageData = this.buildPageData(boList);
        pageData.forEach(data -> {
            data.setUniqueKeyValue((Object)String.valueOf(data.getUniqueKeyValue()));
            data.setSubEntityUniqueKeyValue((Object)String.valueOf(data.getSubEntityUniqueKeyValue()));
        });
        result.put("dataList", TransferConfigCompareResultDataBo.buildPageRenderData(pageData));
        this.putListToCache(pageData);
        result.put("random", new SecureRandom().nextInt(10000000));
        customcontrol.setData(result);
        this.getView().updateView(CUSTOM_CONTROL_AP);
    }

    private List<TransferConfigCompareResultDataBo> buildPageData(List<TransferConfigCompareDataBo> boList) {
        ArrayList<TransferConfigCompareResultDataBo> finalResult = new ArrayList<TransferConfigCompareResultDataBo>(boList.size() * 4);
        if (CollectionUtils.isEmpty(boList)) {
            return finalResult;
        }
        boList.forEach(data -> {
            List boInfo = data.getResult();
            if (CollectionUtils.isNotEmpty((Collection)boInfo)) {
                finalResult.addAll(boInfo);
            }
        });
        return finalResult;
    }

    private void putListToCache(List<TransferConfigCompareResultDataBo> pageData) {
        if (CollectionUtils.isEmpty(pageData)) {
            return;
        }
        Map<String, TransferConfigCompareResultDataBo> cacheMap = pageData.stream().collect(Collectors.toMap(data -> {
            StringBuilder sb = new StringBuilder();
            sb.append(data.getSubEntityNumber());
            sb.append(data.getSubEntityUniqueKeyValue());
            return sb.toString();
        }, dd -> dd, (v1, v2) -> v2));
        this.getPageCache().put(PAGE_DATA_CACHE, SerializationUtils.toJsonString(cacheMap));
    }

    private Map<String, Object> getPageFromCache(String entityNumber, String uniqueKeyValue) {
        Map cacheMap;
        String info = this.getPageCache().get(PAGE_DATA_CACHE);
        if (StringUtils.isNotEmpty((String)info) && CollectionUtils.isNotEmpty((Map)(cacheMap = (Map)SerializationUtils.fromJsonString((String)info, Map.class)))) {
            return (Map)cacheMap.get(entityNumber + uniqueKeyValue);
        }
        return null;
    }

    private void putConfigItemToCache(String configId, List<Object> ids) {
        if (StringUtils.isEmpty((String)configId)) {
            return;
        }
        Map<String, List<Object>> cacheItems = this.getConfigItemToCache();
        if (CollectionUtils.isEmpty(ids)) {
            cacheItems.remove(configId);
        } else {
            cacheItems.put(configId, ids);
        }
        this.getPageCache().put(CONFIG_ITEMS, SerializationUtils.toJsonString(cacheItems));
    }

    private Map<String, List<Object>> getConfigItemToCache() {
        Map<String, List<Object>> configItems = new HashMap<String, List<Object>>(16);
        String info = this.getPageCache().get(CONFIG_ITEMS);
        if (StringUtils.isNotEmpty((String)info)) {
            configItems = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
        }
        return configItems;
    }
}

