/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mvc.SessionManager;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.config.IHRDTBaseConfigDomainService;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class CommonPageUtils {
    private static final Log log = LogFactory.getLog(CommonPageUtils.class);

    public static void handleEnvSupport(PreOpenFormEventArgs e) {
        if (!CommonPageUtils.isSupportProdUse()) {
            e.setCancelMessage(BizModeMsgEnum.HRDT_PROD_FUNCTION_ENABLE_MSG.get());
            e.setCancel(true);
        }
    }

    public static boolean isSupportProdUse() {
        boolean env = EnvTypeHelper.isProductEnv();
        log.info("\u662f\u5426\u662f\u751f\u4ea7\u73af\u5883\uff1a{}", (Object)env);
        if (env) {
            String isSupport = ((IHRDTBaseConfigDomainService)ServiceFactory.getService(IHRDTBaseConfigDomainService.class)).queryBaseConfigValueByNumber("hrdt_prod_function_enable");
            return Boolean.parseBoolean(isSupport.trim());
        }
        return true;
    }

    public static List<ComboItem> initComboFieldVal(String entityNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        properties.stream().filter(pro -> HRStringUtils.isNotEmpty((String)pro.getAlias())).filter(pro -> !(pro instanceof EntryProp)).filter(pro -> !(pro instanceof MulBasedataProp)).filter(pro -> !(pro instanceof LongProp) || !((LongProp)pro).isRefId()).forEach(pro -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(pro.getName()));
            comboItem.setValue(pro.getName());
            comboItems.add(comboItem);
        });
        return comboItems;
    }

    public static List<ComboItem> getRelEntityComboFieldVal(String entityNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        properties.stream().filter(pro -> !(pro instanceof LongProp) || !((LongProp)pro).isRefId()).forEach(pro -> {
            if (pro instanceof EntryProp) {
                CommonPageUtils.handleEntry(comboItems, pro);
                return;
            }
            CommonPageUtils.addComboItem(comboItems, pro.getName(), pro);
        });
        return comboItems;
    }

    private static void handleEntry(List<ComboItem> comboItems, IDataEntityProperty pro) {
        String entryName = pro.getName();
        DataEntityPropertyCollection entryProperties = ((EntryProp)pro).getDynamicCollectionItemPropertyType().getProperties();
        entryProperties.stream().filter(prop -> !(prop instanceof LongProp) || !((LongProp)prop).isRefId()).forEach(prop -> CommonPageUtils.handleSubEntry(comboItems, entryName, prop));
    }

    private static void handleSubEntry(List<ComboItem> comboItems, String entryName, IDataEntityProperty prop) {
        if (prop instanceof SubEntryProp) {
            String subEntryName = prop.getName();
            DataEntityPropertyCollection subEntryProperties = ((SubEntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
            subEntryProperties.stream().filter(subProp -> !(subProp instanceof LongProp) || !((LongProp)subProp).isRefId()).forEach(subProp -> {
                StringBuilder sb = new StringBuilder(entryName).append(".").append(subEntryName).append(".").append(subProp.getName());
                CommonPageUtils.addComboItem(comboItems, sb.toString(), subProp);
            });
        }
        CommonPageUtils.addComboItem(comboItems, entryName + "." + prop.getName(), prop);
    }

    private static void addComboItem(List<ComboItem> comboItems, String caption, IDataEntityProperty prop) {
        if (HRStringUtils.isEmpty((String)prop.getAlias())) {
            return;
        }
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(caption);
        comboItems.add(comboItem);
    }

    public static void showFormInHrdtApp(IFormView view, String formId, String billFormId, String key) {
        ListShowParameter showParameter;
        String pageId = SessionManager.getCurrent().get(view.getPageId() + key);
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new ListShowParameter();
            showParameter.setFormId(formId);
            SessionManager.getCurrent().put(view.getPageId() + key, showParameter.getPageId());
        } else {
            showParameter = (ListShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(false);
        showParameter.setBillFormId(billFormId);
        showParameter.setAppId("hrdt");
        view.showForm((FormShowParameter)showParameter);
    }

    public static FormShowParameter showOperationResult(Map<String, Object> paramsMap) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.getCustomParams().putAll(paramsMap);
        return parameters;
    }
}

