/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.workbench.form;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdt.business.common.utils.OpenPageCommonUtils;
import kd.hdtc.hrdt.business.common.utils.PagePaintingUtils;
import kd.hdtc.hrdt.formplugin.web.workbench.form.handler.ToolVectorLinkBo;
import kd.hdtc.hrdt.formplugin.web.workbench.form.handler.ToolVectorLinkContext;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ToolVectorLinkPageEditPlugin
extends HDTCDataBaseEdit {
    private static final String BOS_QUICK_LAUNCH_CONFIG_PAGE = "bos_quicklaunchconfig";
    private static final int MAX_COUNT = 1;
    private static ToolVectorLinkContext linkContext = new ToolVectorLinkContext(Arrays.asList(new ToolVectorLinkBo("linklist", "toolvectorap", "toollinkpanel", "toolMenuPageCache", "toolpageaddr"), new ToolVectorLinkBo("linkform", "formtoolvectorap", "formtoollinkpanel", "formtoolMenuPageCache", "formtoolpageaddr")));

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        Set<String> linkKeys = linkContext.getKeys();
        if (CollectionUtils.isNotEmpty(linkKeys)) {
            for (String linkKey : linkKeys) {
                if (!key.startsWith(linkKey) || !key.contains("iconap")) continue;
                Button button = new Button();
                button.setKey(key);
                button.setView(this.getView());
                button.addClickListener((ClickListener)this);
                args.setControl((Control)button);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Set<String> aps = linkContext.getToolVectorAps();
        if (CollectionUtils.isNotEmpty(aps)) {
            this.addClickListeners(aps.toArray(aps.toArray(new String[0])));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Set<String> linkKeys = linkContext.getKeys();
        if (CollectionUtils.isNotEmpty(linkKeys)) {
            linkKeys.stream().forEach(linkKey -> this.loadLinkPage((String)linkKey, dataEntity.getString(linkContext.getToolPageAddressByKey((String)linkKey))));
        }
    }

    public void click(EventObject evt) {
        Set<String> aps;
        Object source = evt.getSource();
        String opKey = "";
        if (source instanceof Control) {
            opKey = ((Control)source).getKey();
        }
        if (CollectionUtils.isNotEmpty(aps = linkContext.getToolVectorAps()) && aps.contains(opKey)) {
            this.showQuickLaunchConfigPage(linkContext.getKeyByToolVectorAp(opKey));
        } else if (opKey.contains("iconap_del")) {
            String linkKey = linkContext.getKeyByStart(opKey);
            this.removeQuickLaunchFromView(linkKey, linkContext.getToolLinkPanelByKey(linkKey));
            this.showToolVectorAp(linkKey);
        } else if (opKey.contains("iconap")) {
            String linkKey = linkContext.getKeyByStart(opKey);
            this.showToolVectorAp(linkKey);
            OpenPageCommonUtils.openToolPageLine((IFormView)this.getView(), (String)this.getPageCache().get(linkContext.getToolMenuPageCacheKeyByKey(linkKey)), null);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        List retData;
        this.getView().getFormShowParameter().setAppId("hrdt");
        String actionId = event.getActionId();
        if (HRStringUtils.isNotEmpty((String)actionId) && actionId.startsWith(ToolVectorLinkContext.actionPrefix) && CollectionUtils.isNotEmpty((Collection)(retData = (List)event.getReturnData()))) {
            ArrayList menuList = Lists.newArrayListWithExpectedSize((int)retData.size());
            retData.forEach(data -> {
                if (data.containsKey("cache_linkUrl")) {
                    menuList.add(Pair.of(data.get("cache_linkTitle"), (Object)this.generateLinkUrlData((Map<String, String>)data)));
                } else {
                    menuList.add(Pair.of(data.get("cache_sel_appId"), data.get("cache_sel_menuId")));
                }
            });
            this.addLinkPanel(linkContext.getKeyByActionId(actionId), menuList);
            this.hideToolVectorAp(linkContext.getKeyByActionId(actionId));
        }
    }

    private void loadLinkPage(String opKey, String pageAddress) {
        if (HRStringUtils.isNotEmpty((String)pageAddress)) {
            this.getPageCache().put(linkContext.getToolMenuPageCacheKeyByKey(opKey), pageAddress);
            Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)pageAddress, Map.class);
            ArrayList<Pair<String, String>> menuList = new ArrayList<Pair<String, String>>();
            menuList.add(Pair.of(linkPageMaps.get("key"), linkPageMaps.get("value")));
            this.addLinkPanel(opKey, menuList);
            this.hideToolVectorAp(opKey);
        }
    }

    private void hideToolVectorAp(String opKey) {
        String ap = linkContext.getToolVectorApByKey(opKey);
        this.getView().setVisible(Boolean.FALSE, new String[]{ap, ap + "text"});
    }

    private void showToolVectorAp(String opKey) {
        String ap = linkContext.getToolVectorApByKey(opKey);
        this.getView().setVisible(Boolean.TRUE, new String[]{ap, ap + "text"});
    }

    private void removeQuickLaunchFromView(String opKey, String panel) {
        Container c = (Container)this.getView().getControl(panel);
        c.deleteControls(new String[]{linkContext.getLinkPrefixByKey(opKey) + "iflexpanel" + 1});
        this.getPageCache().put(linkContext.getToolMenuPageCacheKeyByKey(opKey), null);
        this.getModel().setValue(linkContext.getToolPageAddressByKey(opKey), null);
    }

    private void addLinkPanel(String opKey, List<Pair<String, String>> menuList) {
        if (CollectionUtils.isNotEmpty(menuList)) {
            HashMap pageMap = Maps.newHashMapWithExpectedSize((int)4);
            ArrayList list = new ArrayList(menuList.size());
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            menuList = this.checkRetData(opKey, menuList);
            menuList.forEach(menuPair -> {
                FlexPanelAp flexAp;
                if (((String)menuPair.getValue()).contains("pageUrl")) {
                    flexAp = PagePaintingUtils.createFlexAp((String)linkContext.getLinkPrefixByKey(opKey), (Object)menuPair, null, (int)1, (OperationStatus)status);
                } else {
                    AppMenuInfo appMenuInfo = this.getAppMenuInfo((Pair<String, String>)menuPair);
                    flexAp = PagePaintingUtils.createFlexAp((String)linkContext.getLinkPrefixByKey(opKey), null, (AppMenuInfo)appMenuInfo, (int)1, (OperationStatus)status);
                }
                pageMap.put("key", menuPair.getKey());
                pageMap.put("value", menuPair.getValue());
                list.add(flexAp.createControl());
            });
            Container c = (Container)this.getView().getControl(linkContext.getToolLinkPanelByKey(opKey));
            c.addControls(list);
            this.createOrUpdateCacheAndDb(opKey, pageMap);
        }
    }

    private void createOrUpdateCacheAndDb(String opKey, Map<String, String> pageMap) {
        String dataStr = SerializationUtils.toJsonString(pageMap);
        this.getPageCache().put(linkContext.getToolMenuPageCacheKeyByKey(opKey), HRStringUtils.equals((String)dataStr, (String)"{}") ? null : dataStr);
        this.getModel().setValue(linkContext.getToolPageAddressByKey(opKey), (Object)(HRStringUtils.equals((String)dataStr, (String)"{}") ? null : dataStr));
        this.getModel().setDataChanged(false);
    }

    private AppMenuInfo getAppMenuInfo(Pair<String, String> menuPair) {
        AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)((String)menuPair.getKey()), (String)((String)menuPair.getValue()).toUpperCase(Locale.ROOT));
        if (appMenuInfo == null) {
            appMenuInfo = AppMetadataCache.getAppMenuInfo((String)((String)menuPair.getKey()), (String)((String)menuPair.getValue()).toLowerCase(Locale.ROOT));
        }
        if (appMenuInfo == null) {
            appMenuInfo = AppMetadataCache.getAppMenuInfo((String)((String)menuPair.getKey()), (String)((String)menuPair.getValue()));
        }
        return appMenuInfo;
    }

    private List<Pair<String, String>> checkRetData(String opKey, List<Pair<String, String>> menuList) {
        String cacheValue = this.getPageCache().get(linkContext.getToolMenuPageCacheKeyByKey(opKey));
        Map linkPageMaps = new HashMap(16);
        if (HRStringUtils.isNotEmpty((String)cacheValue)) {
            linkPageMaps = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
        }
        ArrayList targetMenuList = Lists.newArrayListWithCapacity((int)menuList.size());
        if (CollectionUtils.isNotEmpty(linkPageMaps)) {
            Container container = (Container)this.getView().getControl(linkContext.getToolLinkPanelByKey(opKey));
            container.deleteControls(new String[]{linkContext.getLinkPrefixByKey(opKey) + "iflexpanel" + 1});
            this.getPageCache().remove(linkContext.getToolMenuPageCacheKeyByKey(opKey));
            this.getModel().setValue(linkContext.getToolPageAddressByKey(opKey), null);
            Set menuIdSet = menuList.stream().map(menu -> ((String)menu.getValue()).toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
            if (menuIdSet.contains(((String)linkPageMaps.get("value")).toUpperCase(Locale.ROOT))) {
                targetMenuList.add(Pair.of(linkPageMaps.get("key"), linkPageMaps.get("value")));
            }
        }
        targetMenuList.addAll(menuList);
        if (menuList.size() > 1) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9875\u9762\u94fe\u63a5\u6700\u591a\u53ef\u914d\u7f6e\u4e00\u4e2a\uff0c\u8d85\u51fa\u90e8\u5206\u5df2\u81ea\u52a8\u5ffd\u7565\uff0c\u5982\u9700\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ToolVectorLinkPageEditPlugin_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
        return targetMenuList.subList(0, 1);
    }

    private String generateLinkUrlData(Map<String, String> dataMap) {
        HashMap linkUrlDataMap = Maps.newHashMapWithExpectedSize((int)dataMap.size());
        String cacheLinkUrl = dataMap.get("cache_linkUrl");
        String cacheLinkIcon = dataMap.get("cache_linkIcon");
        if (HRStringUtils.isNotEmpty((String)cacheLinkUrl)) {
            linkUrlDataMap.put("pageUrl", cacheLinkUrl);
        }
        if (HRStringUtils.isNotEmpty((String)cacheLinkIcon)) {
            linkUrlDataMap.put("imgUrl", cacheLinkIcon);
        }
        return JSONObject.toJSONString((Object)linkUrlDataMap);
    }

    private void showQuickLaunchConfigPage(String opKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (!HRStringUtils.isEmpty((String)this.getPageCache().get(linkContext.getToolMenuPageCacheKeyByKey(opKey)))) {
            formShowParameter.setCustomParam("menuMap", (Object)SerializationUtils.toJsonString(this.getCurrConfigMap(opKey)));
        }
        formShowParameter.setShowTitle(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId(BOS_QUICK_LAUNCH_CONFIG_PAGE);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, linkContext.getCallBackActionIdByKey(opKey)));
        this.getView().getFormShowParameter().setAppId(null);
        this.getView().showForm(formShowParameter);
    }

    private Map<String, String> getCurrConfigMap(String opKey) {
        String pageCache = this.getPageCache().get(linkContext.getToolMenuPageCacheKeyByKey(opKey));
        if (HRStringUtils.isEmpty((String)pageCache)) {
            return null;
        }
        HashMap<String, String> currConfigMap = new HashMap<String, String>(16);
        Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)pageCache, Map.class);
        if (!((String)linkPageMaps.get("value")).toLowerCase().contains("http")) {
            currConfigMap.put(((String)linkPageMaps.get("value")).toLowerCase(), (String)linkPageMaps.get("key"));
        }
        return currConfigMap;
    }
}

