/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.workbench.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hdtc.hrdt.business.application.service.IWorkBenchServiceApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hr.hbp.common.util.HRObjectUtils;

public class WorkBenchHomePagePlugin
extends AbstractHDTCFormPlugin
implements ClickListener {
    private IWorkBenchServiceApplication workBenchServiceApplication = (IWorkBenchServiceApplication)ServiceFactory.getService(IWorkBenchServiceApplication.class);
    private String welcomeTips = ResManager.loadKDString((String)"Hi, %1$s ,\u6b22\u8fce\u6765\u5230\u5de5\u4f5c\u53f0\u9996\u9875\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u7684\u89d2\u8272\u662f \u3010%2$s\u3011\uff0c\u5df2\u4e3a\u60a8\u63a8\u8350\u8be5\u89d2\u8272\u7684\u76f8\u5173\u5185\u5bb9~\u5f00\u59cb\u63a2\u7d22\u5427~", (String)"WorkBenchHomePagePlugin_0", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.workBenchServiceApplication.isFirstIntoWorkBench()) {
            SessionManager.getCurrent().put("workbenchrole", "");
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            String data = customcontrol.getData();
            JSONObject json = new JSONObject();
            if (data != null) {
                json = JSON.parseObject((String)data);
            }
            List<Map<String, Object>> allWorkBenchRole = this.buildAllWorkBenchRole();
            String currentWorkRoleId = null;
            if (allWorkBenchRole != null && allWorkBenchRole.get(0) != null) {
                currentWorkRoleId = (String)allWorkBenchRole.get(0).get("id");
            }
            json.put("showModel", (Object)Boolean.TRUE);
            json.put("random", (Object)new SecureRandom().nextInt(10000000));
            json.put("workbenchrole", allWorkBenchRole);
            json.put("currentWorkBenchRoleId", (Object)currentWorkRoleId);
            customcontrol.setData((Object)json.toJSONString());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label labelap = (Label)this.getView().getControl("labelap");
        DynamicObject workBenchRole = this.workBenchServiceApplication.getWorkBenchRole(this.getWorkBenchRoleId());
        if (HRObjectUtils.isEmpty((Object)workBenchRole)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u5de5\u4f5c\u53f0\u89d2\u8272\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u5de5\u4f5c\u53f0\u89d2\u8272\u3002", (String)"WorkBenchHomePagePlugin_1", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]));
        } else {
            labelap.setText(String.format(this.welcomeTips, RequestContext.get().getUserName(), workBenchRole.getLocaleString("name").getLocaleValue()));
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("showRole".equals(eventName)) {
            this.showChangeRole();
        } else if ("changeRole".equals(eventName)) {
            String workBenchRoleId = e.getEventArgs();
            this.workBenchServiceApplication.saveWorkBenchRole(Long.valueOf(Long.parseLong(workBenchRoleId)));
            this.getView().getPageCache().put("currentWorkBenchRoleId", workBenchRoleId);
            IFormController formController = (IFormController)this.getView().getService(IFormController.class);
            formController.loadData();
        }
    }

    private void showChangeRole() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        String data = customcontrol.getData();
        JSONObject json = new JSONObject();
        if (data != null) {
            json = JSON.parseObject((String)data);
        }
        json.put("showModel", (Object)Boolean.TRUE);
        json.put("random", (Object)new SecureRandom().nextInt(10000000));
        json.put("workbenchrole", this.buildAllWorkBenchRole());
        json.put("currentWorkBenchRoleId", (Object)SessionManager.getCurrent().get("workbenchrole"));
        customcontrol.setData((Object)json.toJSONString());
    }

    private List<Map<String, Object>> buildAllWorkBenchRole() {
        List allWorkBenchRole = this.workBenchServiceApplication.queryAllWorkBenchRole();
        if (CollectionUtils.isEmpty((Collection)allWorkBenchRole)) {
            return null;
        }
        ArrayList workBenchRoleMap = Lists.newArrayListWithExpectedSize((int)allWorkBenchRole.size());
        for (DynamicObject workBenchRole : allWorkBenchRole) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", String.valueOf(workBenchRole.getLong("id")));
            map.put("name", workBenchRole.getString("name"));
            map.put("index", workBenchRole.getInt("index"));
            workBenchRoleMap.add(map);
        }
        return workBenchRoleMap;
    }

    private String getWorkBenchRoleId() {
        String currentWorkBenchRoleId = this.getView().getPageCache().get("currentWorkBenchRoleId");
        if (StringUtils.isNotEmpty((String)currentWorkBenchRoleId)) {
            this.getView().getPageCache().put("currentWorkBenchRoleId", null);
        } else {
            SessionManager currentSessionManager = SessionManager.getCurrent();
            currentWorkBenchRoleId = currentSessionManager.get("workbenchrole");
        }
        return currentWorkBenchRoleId;
    }
}

