/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.formplugin.web.workbench.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.mvc.SessionManager;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hdtc.hrdt.business.application.service.IWorkBenchServiceApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.OpenPageCommonUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class WorkBenchWorkSetDetailPlugin
extends AbstractHDTCFormPlugin {
    private IWorkBenchServiceApplication workBenchServiceApplication = (IWorkBenchServiceApplication)ServiceFactory.getService(IWorkBenchServiceApplication.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("showPage".equals(eventName)) {
            String args = e.getEventArgs();
            JSONObject json = JSON.parseObject((String)args);
            String type = json.getString("type");
            if ("knowledge".equals(type)) {
                OpenPageCommonUtils.openLine((IFormView)this.getView(), (String)json.getString("knowledgelink"), null);
            } else if ("tool".equals(type)) {
                SessionManager currentSessionManager = SessionManager.getCurrent();
                String currentWorkBenchRoleId = currentSessionManager.get("workbenchrole");
                this.workBenchServiceApplication.saveOrUpdateCommonTool(Long.valueOf(RequestContext.get().getCurrUserId()), Long.valueOf(Long.parseLong(currentWorkBenchRoleId)), Long.valueOf(Long.parseLong(json.getString("id"))));
                OpenPageCommonUtils.openToolPageLine((IFormView)this.getView(), (String)json.getString("toolpageaddr"), null);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPanesData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("refresh".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.initPanesData();
        }
    }

    private void initPanesData() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ArrayList panes = new ArrayList();
        SessionManager currentSessionManager = SessionManager.getCurrent();
        String currentWorkBenchRoleId = currentSessionManager.get("workbenchrole");
        DynamicObject workBenchRole = this.workBenchServiceApplication.getWorkBenchRole(currentWorkBenchRoleId);
        if (HRObjectUtils.isEmpty((Object)workBenchRole)) {
            return;
        }
        List workItemSets = this.workBenchServiceApplication.getWorkItemSets(Long.valueOf(workBenchRole.getLong("id")), null);
        if (CollectionUtils.isNotEmpty((Collection)workItemSets)) {
            List workItemSetIds = workItemSets.stream().map(workItemSet -> workItemSet.getLong("id")).collect(Collectors.toList());
            Map workItems = this.workBenchServiceApplication.getWorkItems(workItemSetIds);
            for (DynamicObject workItemSet2 : workItemSets) {
                HashMap<String, Object> workItemSetMap = new HashMap<String, Object>(16);
                workItemSetMap.put("id", String.valueOf(workItemSet2.getLong("id")));
                workItemSetMap.put("name", workItemSet2.getString("name"));
                workItemSetMap.put("icon", workItemSet2.getString("vectorapvalue"));
                workItemSetMap.put("description", workItemSet2.getString("description"));
                workItemSetMap.put("datas", this.buildDataList((List)workItems.get(workItemSet2.getLong("id"))));
                panes.add(workItemSetMap);
            }
            result.put("activeId", this.getView().getFormShowParameter().getCustomParam("currentWorkBenchRoleId"));
        }
        result.put("panes", panes);
        result.put("random", new SecureRandom().nextInt(10000000));
        if (customcontrol != null) {
            customcontrol.setData(result);
        }
    }

    private List<Map<String, Object>> buildDataList(List<DynamicObject> workItems) {
        if (CollectionUtils.isEmpty(workItems)) {
            return null;
        }
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)workItems.size());
        for (DynamicObject workItem : workItems) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("name", workItem.getString("name"));
            dataMap.put("description", workItem.getString("description"));
            DynamicObjectCollection tentryentity = workItem.getDynamicObjectCollection("tentryentity");
            ArrayList toolDatas = new ArrayList();
            if (!ObjectUtils.isEmpty((Object)tentryentity)) {
                for (DynamicObject dynamicObject : tentryentity) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    DynamicObject tooEntity = dynamicObject.getDynamicObject("tool");
                    if (!"1".equals(tooEntity.getString("enable"))) continue;
                    map.put("id", String.valueOf(tooEntity.getLong("id")));
                    map.put("name", tooEntity.getString("name"));
                    map.put("toolpageaddr", tooEntity.getString("toolpageaddr"));
                    map.put("description", tooEntity.getString("description"));
                    map.put("type", "tool");
                    toolDatas.add(map);
                }
            }
            dataMap.put("tools", toolDatas);
            DynamicObjectCollection kentryentity = workItem.getDynamicObjectCollection("kentryentity");
            ArrayList knowledgeDatas = new ArrayList();
            if (!ObjectUtils.isEmpty((Object)kentryentity)) {
                for (DynamicObject dynamicObject : kentryentity) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    DynamicObject knowledgeEntity = dynamicObject.getDynamicObject("knowledge");
                    if (!"1".equals(knowledgeEntity.getString("enable"))) continue;
                    map.put("id", String.valueOf(knowledgeEntity.getLong("id")));
                    map.put("name", knowledgeEntity.getString("name"));
                    map.put("linktype", knowledgeEntity.getString("linktype"));
                    map.put("knowledgelink", knowledgeEntity.getString("knowledgelink"));
                    map.put("type", "knowledge");
                    knowledgeDatas.add(map);
                }
            }
            dataMap.put("knowledges", knowledgeDatas);
            datas.add(dataMap);
        }
        return datas;
    }
}

