/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.common.enums;

import java.math.BigDecimal;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public enum WTCItemUnitEnum {
    UNIT_SECOND("second", 1),
    UNIT_MINUTE("minute", 60),
    UNIT_HOUR("hour", 3600),
    UNIT_DAY("day", 3600),
    UNIT_ERROR("error", 0);

    private static final Log logger;
    private String code;
    private Integer number;

    private WTCItemUnitEnum(String code, Integer number) {
        this.code = code;
        this.number = number;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getNumber() {
        return this.number;
    }

    public static WTCItemUnitEnum getByCode(String code) {
        for (WTCItemUnitEnum value : WTCItemUnitEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        return null;
    }

    public static BigDecimal changeValueToSecond(String code, BigDecimal value) {
        if (null == value) {
            return null;
        }
        WTCItemUnitEnum unitEnum = WTCItemUnitEnum.getByCode(code);
        if (unitEnum == UNIT_ERROR || unitEnum == null) {
            return null;
        }
        return value.multiply(new BigDecimal(unitEnum.number));
    }

    static {
        logger = LogFactory.getLog(WTCItemUnitEnum.class);
    }
}

