/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrdt.mservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdt.business.domain.transfer.configitem.impl.ConfigItemDomainServiceImpl;
import kd.hdtc.hrdt.business.domain.transfer.configitem.model.TransferDataBo;
import kd.hdtc.hrdt.common.util.CommonUtils;
import kd.hr.hrdt.mservice.api.IConfigItemService;
import org.apache.commons.io.FilenameUtils;

public class ConfigItemServiceImpl
implements IConfigItemService {
    private static final Log LOG = LogFactory.getLog(ConfigItemServiceImpl.class);
    private String curConfItemUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> exportPacket(Map<String, Object> paras) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(8);
        if (paras.get("entity_number") == null) {
            return retMap;
        }
        ConfigItemDomainServiceImpl configItemDomainService = new ConfigItemDomainServiceImpl();
        long starTime = 0L;
        try {
            LOG.info("exportPacket paras is {}", (Object)SerializationUtils.toJsonString(paras));
            starTime = System.currentTimeMillis();
            String entityNumber = (String)paras.get("entity_number");
            List listSelectedRows = (List)paras.get("listSelectedRowList");
            List idList = listSelectedRows.stream().map(sr -> sr.getPrimaryKeyValue()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
                retMap.put("code", 1);
                retMap.put("msg", "no data.");
                retMap.put("dev_msg", "");
                HashMap<String, Object> hashMap = retMap;
                return hashMap;
            }
            TransferDataBo transferDataBo = new TransferDataBo(entityNumber);
            transferDataBo.setCp("in");
            transferDataBo.setFieldValueList(idList);
            transferDataBo.setFieldKey("id");
            ArrayList entityConfItemDataList = new ArrayList(10);
            ArrayList<Map<String, Map<String, Object>>> sysConfItemDataList = new ArrayList<Map<String, Map<String, Object>>>(10);
            HashSet confItemItselfNumSet = new HashSet(16);
            List confItemData = configItemDomainService.getConfItemData(transferDataBo, entityConfItemDataList, sysConfItemDataList, confItemItselfNumSet);
            LOG.info("exportPacket,confItemData.size={}", (Object)confItemData.size());
            LinkedHashMap confItemEntityMap = configItemDomainService.getHrConfItemMap(confItemItselfNumSet);
            List<Map<String, Object>> mulDataMapList = this.getMulDataMapList(confItemData, entityNumber);
            List<Map<String, Object>> relDataBaseMapList = this.getRelSysConfItemLy(sysConfItemDataList);
            for (Map.Entry confItemEntry : confItemEntityMap.entrySet()) {
                HashMap<String, Object> confItemMap = new HashMap<String, Object>(16);
                String hrCurConfItemEntityNum = (String)confItemEntry.getKey();
                Map confItemDataMap = (Map)confItemEntry.getValue();
                List hrCurConfItemIdList = (List)confItemDataMap.get("id");
                confItemMap.put("entity_number", hrCurConfItemEntityNum);
                confItemMap.put("id_list", hrCurConfItemIdList);
                relDataBaseMapList.add(confItemMap);
            }
            retMap.put("code", 0);
            retMap.put("msg", "");
            retMap.put("dev_msg", "");
            retMap.put("relybd_list", relDataBaseMapList);
            retMap.put("multidata_list", mulDataMapList);
            retMap.put("export_url", this.curConfItemUrl);
        }
        catch (Exception exception) {
            retMap.put("code", 1);
            retMap.put("msg", "importPacket is Exception.");
            retMap.put("dev_msg", CommonUtils.getStackTrace((Throwable)exception));
            LOG.error("ConfigItemServiceImpl.exportPacket is exception", (Throwable)exception);
        }
        finally {
            LOG.info("exportPacket end,cost={},retMap={}", (Object)(System.currentTimeMillis() - starTime), (Object)SerializationUtils.toJsonString(retMap));
        }
        return retMap;
    }

    private List<Map<String, Object>> getRelSysConfItemLy(List<Map<String, Map<String, Object>>> sysConfItemDataList) {
        ArrayList<Map<String, Object>> relDataBaseMapList = new ArrayList<Map<String, Object>>(16);
        if (ObjectUtils.isEmpty(sysConfItemDataList)) {
            return relDataBaseMapList;
        }
        for (Map<String, Map<String, Object>> dataMap : sysConfItemDataList) {
            for (Map.Entry<String, Map<String, Object>> sysDataEntry : dataMap.entrySet()) {
                HashMap<String, Object> sysConfItemMap = new HashMap<String, Object>(16);
                String sysConfItemNumber = sysDataEntry.getKey();
                Map<String, Object> fieldFilterMap = sysDataEntry.getValue();
                List sysConfItemIdList = (List)fieldFilterMap.get("id");
                ArrayList idList = new ArrayList(10);
                for (Object sysItemId : sysConfItemIdList) {
                    if (sysItemId == null || "0".equals(sysItemId.toString())) continue;
                    idList.add(sysItemId);
                }
                if (ObjectUtils.isEmpty(idList)) continue;
                sysConfItemMap.put("entity_number", sysConfItemNumber);
                sysConfItemMap.put("id_list", idList);
                relDataBaseMapList.add(sysConfItemMap);
            }
        }
        return relDataBaseMapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getMulDataMapList(List<Map<String, Object>> confItemData, String curEntityNumber) {
        ArrayList<Map<String, Object>> mulDataMapList = new ArrayList<Map<String, Object>>(16);
        String filePath = FileUtils.generateLocalPath();
        for (Map<String, Object> confItemDataMap : confItemData) {
            String appId = (String)confItemDataMap.get("appId");
            String confItemEntityNumber = (String)confItemDataMap.get("entityNumber");
            File fileTemp = FileUtils.checkAndCreateDir((String)filePath, (String)appId);
            InputStream input = null;
            HashMap<String, Object> mulDataMap = new HashMap<String, Object>(16);
            try {
                String fileName = appId + "-" + confItemEntityNumber + ".json";
                String jsonFilePath = fileTemp + File.separator + fileName;
                FileUtils.writeMap2File((String)fileTemp.getAbsolutePath(), (String)fileName, confItemDataMap);
                input = Files.newInputStream(Paths.get(FilenameUtils.getFullPath((String)jsonFilePath) + FilenameUtils.getName((String)jsonFilePath), new String[0]), new OpenOption[0]);
                String tempFileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, input, 28800);
                if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                    tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
                }
                if (curEntityNumber.equals(confItemEntityNumber)) {
                    this.curConfItemUrl = tempFileUrl;
                    continue;
                }
                List dataList = (List)confItemDataMap.get("data");
                ArrayList retDataMapList = new ArrayList(dataList.size());
                for (Map map : dataList) {
                    HashMap dataMap = new HashMap(8);
                    dataMap.put("id", map.get("id"));
                    dataMap.put("number", map.get("number"));
                    dataMap.put("name", map.get("name"));
                    retDataMapList.add(dataMap);
                }
                mulDataMap.put("entity_number", confItemEntityNumber);
                mulDataMap.put("export_url", tempFileUrl);
                mulDataMap.put("selected_info", retDataMapList);
                mulDataMapList.add(mulDataMap);
            }
            catch (Throwable e) {
                LOG.error("ConfigItemServiceImpl.getMulDataMapList is exception.", e);
            }
            finally {
                FileUtils.deleteLocalFile((File)fileTemp);
                if (input == null) continue;
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.error("ConfigItemServiceImpl.getMulDataMapList input close is exception.", (Throwable)e);
                }
            }
        }
        return mulDataMapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importPacket(Map<String, Object> paramMap) {
        Map<String, Object> retMap = new HashMap<String, Object>(16);
        LOG.info("importPacket paras is {}", (Object)SerializationUtils.toJsonString(paramMap));
        long start = System.currentTimeMillis();
        ConfigItemDomainServiceImpl configItemDomainService = new ConfigItemDomainServiceImpl();
        try {
            Object importUrlObj = paramMap.get("import_url");
            if (ObjectUtils.isEmpty(paramMap) || ObjectUtils.isEmpty((Object)importUrlObj)) {
                retMap.put("code", 1);
                retMap.put("msg", "paramMap is empty.");
                Map<String, Object> map = retMap;
                return map;
            }
            retMap = configItemDomainService.handleConfItemImportData(importUrlObj.toString());
        }
        catch (Exception exception) {
            LOG.error("ConfigItemServiceImpl.importPacket is Exception", (Throwable)exception);
            retMap.put("code", 1);
            retMap.put("msg", "importPacket is Exception.");
            retMap.put("dev_msg", CommonUtils.getStackTrace((Throwable)exception));
        }
        finally {
            long end = System.currentTimeMillis();
            String logInfo = "ConfigItemServiceImpl.importPacket is end. cast=" + (end - start) + "ms; paramMap:" + SerializationUtils.toJsonString(paramMap);
            LOG.info(logInfo);
        }
        return retMap;
    }
}

