/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.cadre.op;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.cadre.ICadreFileToolApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.constants.AppHisEventConstants;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.entity.ICadreFileToolEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.hander.PersonAppEventHandler;
import kd.hdtc.hrdt.common.util.HRDyObjectUtils;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.cadre.validate.CadreFileToolISVNumberValidator;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.cadre.validate.CadreFileToolRepeatRegisterValidator;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.person.validate.PersonFileToolEffectStatusValidator;

public class CadreFileToolEffectOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(CadreFileToolEffectOp.class);
    private final ICadreFileToolApplicationService CadreFileToolApplicationService = (ICadreFileToolApplicationService)ServiceFactory.getService(ICadreFileToolApplicationService.class);
    private final ICadreFileToolEntityService iCadreFileToolEntityService = (ICadreFileToolEntityService)ServiceFactory.getService(ICadreFileToolEntityService.class);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        List fieldKeys = preparePropertysEventArgs.getFieldKeys();
        fieldKeys.add("bizmodel");
        fieldKeys.add("filetype");
        fieldKeys.add("biztype");
        fieldKeys.add("pcview");
        fieldKeys.add("region");
        fieldKeys.add("isbatchmenu");
        fieldKeys.add("cadrefileviews");
        fieldKeys.add("effectivestatus");
        fieldKeys.add("errormessage");
        fieldKeys.add("enable");
        fieldKeys.add("result");
        fieldKeys.add("result_tag");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new PersonFileToolEffectStatusValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new CadreFileToolRepeatRegisterValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new CadreFileToolISVNumberValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        long[] ids = ORM.create().genLongIds("hrdt_cadrefiletool", dataEntities.length);
        int index = 0;
        for (DynamicObject dynamicObject : dataEntities) {
            long primaryId = dynamicObject.getLong("id");
            if (primaryId == 0L) {
                dynamicObject.set("id", (Object)ids[index++]);
            }
            ToolResultBo toolResultBo = this.CadreFileToolApplicationService.effect(dynamicObject);
            dynamicObject.set("effectivestatus", (Object)toolResultBo.getEffectiveStatus());
            dynamicObject.set("errormessage", (Object)toolResultBo.getErrorMsg());
            if (!"2".equals(toolResultBo.getEffectiveStatus()) || !StringUtils.isNotEmpty((String)toolResultBo.metaContentToJson())) continue;
            HRDyObjectUtils.setBigText((DynamicObject)dynamicObject, (String)"result", (String)toolResultBo.metaContentToJson());
        }
        LOG.info("CadreFileToolEffectOp savePersonAppEventInfo start");
        new PersonAppEventHandler().savePersonAppEventInfo("soecs", AppHisEventConstants.Value.CADRE_EVENT_ID.longValue());
        LOG.info("CadreFileToolEffectOp savePersonAppEventInfo end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.iCadreFileToolEntityService.save(e.getDataEntities());
    }
}

