/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.cadre.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.ICadreFileToolDomainService;

public class CadreFileToolISVNumberValidator
extends HDTCDataBaseValidator {
    private final IMetadataDomainService metadataDomainService = (IMetadataDomainService)ServiceFactory.getService(IMetadataDomainService.class);
    private final ICadreFileToolDomainService cadreFileToolDomainService = (ICadreFileToolDomainService)ServiceFactory.getService(ICadreFileToolDomainService.class);
    private final String EXIST_NUMBER_ERROR = ResManager.loadKDString((String)"\u9884\u751f\u6210\u7684%s\u5b9e\u4f53\u7f16\u7801\u5df2\u5b58\u5728", (String)"CommonISVNumberValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.metaDataNumberRepeatValidate();
    }

    protected void metaDataNumberRepeatValidate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            long fileTypeId = dataEntity.getLong("filetype.id");
            String entityNumber = dataEntity.getString("bizmodel.mainentity.number");
            Map sourceNumberMetaNumberMap = this.cadreFileToolDomainService.generateNumbers(Collections.singleton(entityNumber), Long.valueOf(fileTypeId));
            Map metaDataNumberMap = (Map)sourceNumberMetaNumberMap.get(entityNumber);
            Map validResult = this.metadataDomainService.isExistMetaData(metaDataNumberMap.values());
            ArrayList existNumList = new ArrayList(4);
            List<String> metaDataNumberKeyList = Arrays.asList("pagebase", "dialog", "basecard");
            metaDataNumberKeyList.forEach(metaDataNumberKey -> {
                String metaDataNumber = (String)metaDataNumberMap.get(metaDataNumberKey);
                Boolean exist = (Boolean)validResult.get(metaDataNumber);
                if (StringUtils.isNotEmpty((String)metaDataNumber) && exist != null && exist.booleanValue()) {
                    existNumList.add(metaDataNumber);
                }
            });
            if (CollectionUtils.isNotEmpty(existNumList)) {
                this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, this.EXIST_NUMBER_ERROR, String.join((CharSequence)",", existNumList)));
            }
        });
    }
}

